// 610 Swinging Door
// Sixten Inferno
// 1.00 - 12/4/08 - First Created
// 1.01 - 1/23/09 - Added Autoclose and some general clean up - Renamed from 610 Smooth Door

// This can be used in a free standing or linkset as long as the door is not the root prim.
// If this script is in the root prim of a linked set then the whole set will rotate with the root prim
// This can be useful for example a coffin lid.
// This can be used with a standard prim, cut prim, and sliced prim.

// Axis to rotate on, x, y, or z
string axis = "x";

// Set Synced Sounds
string soundOpen = "";
string soundClose = "";
string soundMoving = "2fe283ca-35ab-4b1d-aaec-78d50c705cd1";

// Access Variables
integer isLocked = FALSE;
// Add Full names of avatars to list below if you want them to have access when door is locked
// example = ["Sixten Inferno", "Alice WunderKinde"]
list accessAllowAvatar = [];

// Auto Close 
integer autoCloseOn = TRUE;

// Turn on or off DebugMode
integer debugModeOn = FALSE;

//
// dont change anything below this line unless you know what you are doing.
//

rotation angleRotation;
float spinDirection;
integer angleDegrees = 90;
key toucherKey;
string ScriptName;

Debug(string output)
{
    if(debugModeOn)
    {
        llOwnerSay(ScriptName +  ": " + output);
    }
}

ToggleDoor()
{
    rotation rot = llGetRot();
    llLoopSound(soundMoving, 1.0);
    
    if(axis == "y")
    {
        angleRotation = llEuler2Rot(<(float)angleDegrees, 0.0, 0.0> * DEG_TO_RAD);
        llTargetOmega(<spinDirection, 0.0, 0.0> * rot, 0.5, 1.0);
    }
    if(axis == "z")
    {
        angleRotation = llEuler2Rot(<0.0, (float)angleDegrees, 0.0> * DEG_TO_RAD);
        llTargetOmega(<0.0, spinDirection, 0.0> * rot, 0.5, 1.0);
    }
    if(axis == "x")
    {
        angleRotation = llEuler2Rot(<0.0, 0.0, (float)angleDegrees> * DEG_TO_RAD);
        llTargetOmega(<0.0, 0.0, spinDirection> * rot, 0.5, 1.0);
    }
    
    llSleep(3.0); 
    llTargetOmega( <0.,0.,0.>, 0.0, 0.0 );
    llStopSound();
    
    angleRotation.s *= spinDirection;
    llSetLocalRot(angleRotation * llGetLocalRot());
}

integer PermissionCheck(key id)
{
    integer hasPermission = FALSE;
    
    if(isLocked == FALSE)
    {
        hasPermission = TRUE;
    }
    else if(llGetOwnerKey(id) == llGetOwner())
    {
        hasPermission = TRUE;
    }
    else if(llGetKey() == id)
    {
        hasPermission = TRUE;
    }
    else
    {
        integer inList = llListFindList(accessAllowAvatar, [llKey2Name(id)]);
        
        if(inList != -1)
        {
            hasPermission = TRUE;
        }
    }
    
    return hasPermission;
}

default
{
    state_entry()
    {
        ScriptName = llGetScriptName();
        state Closed;
    }
}

state Open
{
    state_entry()
    {
        spinDirection = 1;
        
        if(autoCloseOn == TRUE)
        {
            llSetTimerEvent(10.0);
        } 
    }
    
    touch_start(integer count)
    {
        toucherKey = llDetectedKey(0);
        
        if(PermissionCheck(toucherKey))
        {
            state Closing;
        }
    }
    
    timer()
    {
        state Closing;
    }
}

state Opening
{
    state_entry()
    {
        llPlaySound(soundOpen, 1.0);
        ToggleDoor();
        state Open;
    }
}

state Closed
{
    state_entry()
    {
        spinDirection = -1;   
    }
    
    touch_start(integer count)
    {
        toucherKey = llDetectedKey(0);
        
        if(PermissionCheck(toucherKey))
        {
            state Opening;
        }
    }
}

state Closing
{
    state_entry()
    {
        llSetTimerEvent(0.0);
        ToggleDoor();
        llPlaySound(soundClose, 1.0);
        state Closed;
    }
}