//Simple Rotation Follower Script
//If this script is set to run, it will turn to match the orientation of the target selected.
// It will perfer to follow the owner
// but if the owner is not there it will pick someone at random within 50 m
// and follow them.

//Based off of scripts by SL Ope Rand & Christopher Omega

// AXIS_* constants, represent the unit vector 1 unit on the specified axis.
vector AXIS_UP = <0,0,1>;
vector AXIS_LEFT = <0,1,0>;
vector AXIS_FWD = <1,0,0>;
vector offset = < -2,2, -0.45>;  //1 meter behind and 1 meter above owner's center.
vector roffset=<0,0,0>;
float rspeed =0.4; 

integer range=20;
integer nestSize=20;
key lastTargetID;
vector nest;
integer nestDefined = 0;
integer textureChan = 9854;

rotation getRotToPointAxisAt(vector axis, vector target) {
return llGetRot() * llRotBetween(axis * llGetRot(), target - llGetPos());
}

integer legalPos( vector pos)
{
    if ((pos.x>5)&&( pos.x<250)&&(pos.y>5)&&( pos.y<250))
    {
        if (nestDefined==1)
        {
          if( (pos.x>nest.x-nestSize)&&( pos.x<nest.x+nestSize)&&(pos.y>nest.y-nestSize)&&( pos.y<nest.y+nestSize) )
            {
                return 1;
            } 
            else
            {
                return 0; // Not in our nest zone
            }
       }
       else
       {
            // No Nest Zone Defined
                 return 1;
           
       }
    }
    else
    {
        return 0; // They broke our liberal rules so we're SOOO over with them
    }
 
}


// Strength and damping are values used to control 
// how llRotLookAt and llLookAt move, these values are tunable.
float strength = 1.0;
float damping = 0.1250;

default 
    {
        state_entry() {
            
        nestDefined=0;
        lastTargetID = llGetOwner();
        
        //Stops it from tipping over
        llSetStatus(STATUS_ROTATE_X, FALSE);
        llSetStatus(STATUS_ROTATE_Y, TRUE); 
        llSetStatus(STATUS_ROTATE_Z, FALSE);
        llSetStatus(STATUS_PHYSICS, FALSE);
        
        
        //llSensorRepeat(string name, key id, integer type, float range, float arc, float rate)
        //llSensorRepeat("",llGetOwner(),AGENT,60,PI,0.2); //set the last three variables lower/higher to lessen lag
    
        llSensorRepeat("","",AGENT,range,PI,1);
        llListen( 0, "", llGetOwner(), "" );

    }
    
    on_rez(integer start_param) { llResetScript(); }
    
    listen(integer channelIn, string name, key id, string message) 
    {
       if (llSubStringIndex(message,"NEST") >= 0) 
         {
            nest = llGetPos();
            llSay(0,"The range of my Nest is: X( "+ (string)(nest.x-nestSize) + ") to X( "+ (string)(nest.x+nestSize) + 
                       ") and y( "+ (string)(nest.y-nestSize)+ ") to y("+ (string)(nest.y+nestSize) +")");
            nestDefined=1;
         } 
    
          if (llSubStringIndex(message,"DENEST") >= 0) 
         {
             nestDefined=0;
         }
    }
    
    sensor(integer num_detected) 
    {
    
        // Pick someone at random but perfer the owner and last target
         integer target_selected = (integer)llFrand((float)num_detected);
         integer i;
         for(i = 0; i < num_detected; i++)
         {
           if ( (llDetectedKey(i)== lastTargetID) && (legalPos(llDetectedPos(i))==1) )
           {
            target_selected = i; // Go with our existing target if possible
           }
           if ( (llDetectedKey(i)== llGetOwner()) && (legalPos(llDetectedPos(i))==1) )
           {
             target_selected = i;
             lastTargetID=llGetOwner();  // forget about that passing fad
           }
         }
         //llShout(0, "num_detected "+ (string)num_detected + " target_selected "+ (string) target_selected);

        //vector target = llDetectedPos(0);
        vector target = llDetectedPos(target_selected);
        
        // This line points the fwd (X) axis at the target:
        //llRotLookAt(getRotToPointAxisAt(AXIS_FWD, target), strength, damping);
        // llLookAt(llGetOwner(),strength, damping);
        
        // This line points the left (Y) axis at the target:
        // llRotLookAt(getRotToPointAxisAt(AXIS_LEFT, target), strength, damping);
        // This points the up (Z) axis at the target:
        // llRotLookAt(getRotToPointAxisAt(AXIS_UP, target), strength, damping);
        
        // Get position and rotation
        vector pos   = llDetectedPos(target_selected);
        rotation rot = llDetectedRot(target_selected);
        vector mypos = llGetPos();
        
        // Offset back one metre in X and up one metre in Z based on world coordinates.
        // use whatever offset you want.
        vector worldOffset = offset;
        
        // Offset relative to owner needs a quaternion.
        vector avOffset = offset * rot;
        
        pos += avOffset+roffset;       // use the one you want, world or relative to AV.
        
        //llShout(0, "MoveTo "+ (string)pos + " @ "+ (string) rspeed);
        //llMoveToTarget(pos,rspeed); 


        
        if (legalPos(pos) ==1)
        { 
            llSetPos(pos);
            llSetRot(rot);
        }
        else
        {
            lastTargetID = NULL_KEY; // Not in our nest zone
        }


        llResetScript(); 
    
    }

}

