vector opensize=<0.062,1.242,0.82>;
vector closedsize=<0.031,0.414,0.547>;
string book="closed";
integer pagesets=11;
// here enter the number of pages
list pageUUIDs=["1477a1ec-cc4e-41e5-b4a7-feb4b3da0e80","290be8e9-60f5-4ed0-8aed-d8efa7c5ce24","73fe845f-10d2-405d-a4e1-042885abd232","d2ae3af2-d9cc-443f-979d-ed2405656d48","ad932c61-258f-4918-ae4d-9a2f5944ac8d","90d9117f-c0e9-45d6-9a4f-cae1776b65a0","95d27e1a-5a51-43f6-bde4-21ef208e1d3a","3d07dce4-e18d-4111-adcf-3418990a0ff3","30c8f7eb-ea30-4ac1-a764-fc54a3555bf6","0f711699-026a-40fc-82e8-7828e3153e9e","4949c6ed-81ab-4e10-a1d1-b4e54042e9df"];
// here enter all UUIDs of the pictures that make the double pages
integer pageset=0;

settexture()
{
    string ID=llList2String(pageUUIDs,pageset);
    key textureID=(key) ID;
    llSetTexture("20f56e6d-39ad-4b97-90b3-77c3a0c8086d",0);
// texture of upper face
    llSetTexture("20f56e6d-39ad-4b97-90b3-77c3a0c8086d",1);
// texture of right side face on open
    llSetTexture("20f56e6d-39ad-4b97-90b3-77c3a0c8086d",3);
// texture of first side face on open
    llSetTexture("20f56e6d-39ad-4b97-90b3-77c3a0c8086d",4);
// texture below face on open
    llSetTexture("63f5294b-6a33-4219-97cc-d3965b7106fb",2);
// texture backside on open
    llSetPrimitiveParams([PRIM_TEXTURE, 5, textureID, <0.5,1,0>, <0.25,0,0>, 0.0]);
    llSetPrimitiveParams([PRIM_TEXTURE, 6, textureID, <0.5,1,0>, <-0.25,0,0>, 0.0]);
    //    llSetTexture(textureID,5);
    // texture all inner right pages
    //    llSetTexture(textureID,6);
    // texture all inner left pages
    llSetTexture("041d02c0-b2fa-4ddf-bafb-c438adf72fc4",7);
// texture below face on open
}

closebook()
{
    llSetPrimitiveParams([PRIM_TYPE, PRIM_TYPE_BOX, 0, <0,1,0>, 0.0, <0,0,0>, <1,1,1>, <0,0,0>]);
    llSetPrimitiveParams([PRIM_SIZE, closedsize]);
    llSetTexture("041d02c0-b2fa-4ddf-bafb-c438adf72fc4",0);
// texture above face
    llSetTexture("041d02c0-b2fa-4ddf-bafb-c438adf72fc4",1);
// texture right side face
    llSetTexture("63f5294b-6a33-4219-97cc-d3965b7106fb",2);
// texture back face
    llSetTexture("20f56e6d-39ad-4b97-90b3-77c3a0c8086d",3);
// texture left side face
    llSetTexture("20f56e6d-39ad-4b97-90b3-77c3a0c8086d",4);
// texture cover face
    llSetTexture("20f56e6d-39ad-4b97-90b3-77c3a0c8086d",5);
// texture below face
}

default
{    
    state_entry()
    {
        closebook();
        book="closed";
        pageset=0;
    }
    
    touch_start(integer num_times)
    {
        if(book=="closed")
        {
            book="open";
            llSetPrimitiveParams([PRIM_TYPE, PRIM_TYPE_BOX, 0, <0,0.725,0>, 0.0, <0,0,0>, <1,1,1>, <0,0,0>]);
            llSetPrimitiveParams([PRIM_SIZE, opensize]);
            settexture();
        } else if(book=="open")
        {
            pageset=pageset + 1;
            if(pageset>(pagesets-1))
            {
                closebook();
                book="closed";
                pageset=0;
            } else {
                settexture();
            }
        }
    } 
}