
// CamTool By: BlueWall
//
// Copyright (C)  2010, BlueWall Information Techniologies, LLC
// All Rights Reserved
//
// License
// 
// This work is released under the Apache License, Version 2
// http://www.apache.org/licenses/LICENSE-2.0.html
//
integer g_usr_chan;

integer g_com_chan;
integer g_mrk_chan;
integer g_tgt_chan;

integer g_marker_count;
integer g_target_active;

string g_rezzing;

default
{
    state_entry()
    {
        llOwnerSay("Script initializing...");
        llSitTarget(<-0.7,0.0,0.0>, llEuler2Rot(<0.0, 270 * DEG_TO_RAD, 0.0>));
        
        g_marker_count = 0;
        
        // Our user command channel...
        g_usr_chan = 10 + (integer) llFrand(10.0);
        llListen(g_usr_chan, llKey2Name(llGetOwner()), llGetOwner(), "");
        // Our listen channel...
        g_com_chan = 0 - (10235 + (integer) llFrand(1024.0));
        llListen(g_com_chan,"","","");
        
        // Marker listen channel...
        g_mrk_chan = g_com_chan + 1;
        
        // Target channel...
        g_tgt_chan = g_mrk_chan + 1;
        
        llOwnerSay("Done:\n\tUsing channel " + (string) g_usr_chan);
    }

    touch_start(integer _det)
    {
        if ( llDetectedKey(0) == llGetOwner())
        {
            llDialog(llDetectedKey(0),
                "Select Operation...",
                ["Help","Reset","Target"], 
                g_usr_chan);
        }
    }
                
    changed(integer _ch)
    {
        if (( _ch & CHANGED_LINK ) == CHANGED_LINK )
        {
            key avatar = llAvatarOnSitTarget();
            if (avatar == NULL_KEY)
                return;
            
            if (avatar != llGetOwner())
            {
                llUnSit(avatar);
                llInstantMessage(avatar, 
                    "This only works with the object owner");
                return;
            }
            else if (avatar == llGetOwner())
            {
                llOwnerSay("Using channel " + (string) g_usr_chan);
                llRequestPermissions(avatar, PERMISSION_TRACK_CAMERA|PERMISSION_CONTROL_CAMERA);
            }
        }
        if (( _ch & CHANGED_OWNER ) == CHANGED_OWNER )
        {
            llResetScript();
        }
    }

    listen(integer _ch, string _nm, key _id, string _msg)
    {
        if ( _msg == "mark" || _msg == "Mark" || _msg == "MARK" )
        {
            if ( g_target_active == 1 )
            {
                llRezObject("Marker",llGetPos() + <1.0,0.0,1.0>, 
                    ZERO_VECTOR, ZERO_ROTATION, g_mrk_chan);
                g_rezzing = "MARKER";
                g_marker_count++;
                return;   
            }
            else
            {
                llOwnerSay("Must rez the target first!");
            }
        }

        if ( _msg == "Reset" )
        {
            llUnSit(llGetOwner());
            llRegionSay(g_tgt_chan,"DISPOSE");
            llRegionSay(g_mrk_chan,"DISPOSE");
            llResetScript();
        }

        if ( _msg == "Target" || _msg == "target" || _msg == "TARGET" )
        {
            if ( g_target_active == 0 )
            {
                g_rezzing = "TARGET";
                llRezObject("Target",llGetPos() + <1.0,0.0,1.0>, 
                    ZERO_VECTOR, ZERO_ROTATION, g_tgt_chan);
            }
            return;
        }
                
        if ( _msg == "help" || _msg == "Help" || _msg == "HELP" )
        {
            llOwnerSay("Use channel " + (string) g_usr_chan +
                        "\n" + g_usr_chan );
            llGiveInventory(llGetOwner(),"Instructions");
            return;
        }
            
        if ( _nm == "Marker" )
        {
            list params = llParseString2List(_msg,["#"],[]);
            string command = llList2String(params,0);
            if ( command == "REFRESH" )
            {
                // Get new cam data & send            
                vector cam_pos = llGetCameraPos();
                rotation cam_rot = llGetCameraRot();

                llRegionSayTo(_id, g_mrk_chan, 
                                    (string)cam_pos + "#" + 
                                    (string) cam_rot + "#" + 
                                    (string) g_marker_count + "#" +
                                    (string) g_tgt_chan + "#" +
                                    (string) g_com_chan );
                return;
            }
            else if ( command == "CAM" )
            {
                // Set camera to this spec
                vector pos = llList2Vector(params,1);
                vector tgt = llList2Vector(params, 2);
                llClearCameraParams();
                
                llSetCameraParams([CAMERA_ACTIVE,TRUE,
                                    CAMERA_FOCUS,tgt,
                                    CAMERA_POSITION,pos,
                                    CAMERA_FOCUS_LOCKED, TRUE,
                                    CAMERA_POSITION_LOCKED, TRUE]);
                return;      
            }
        }
    }
    
    object_rez(key _obj)
    {   
        if ( g_rezzing == "MARKER" )
        {
            g_rezzing = "";
            
            vector cam_pos = llGetCameraPos();
            rotation cam_rot = llGetCameraRot();

            llRegionSayTo(_obj, g_mrk_chan, (string)cam_pos + "#" + 
                                    (string) cam_rot + "#" + 
                                    (string) g_marker_count + "#" +
                                    (string) g_tgt_chan + "#" +
                                    (string) g_com_chan );
            
        }
        else
        {
            g_rezzing = "";
            g_target_active = 1;
        
            llRegionSayTo(_obj, g_tgt_chan, 
                            (string) g_mrk_chan + "#" +
                            (string) g_com_chan );
            
        }
    }
    
    on_rez(integer parm)
    {
        llResetScript();
    }
}