// zTech Texture Sorter v1.0
// Copyright (C) 2010 Zauber Paracelsus (also known as Zauber Exonar)
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307, USA.

key GRID_TEX = "dacd3247-cc73-4209-b849-cafa86db9c30";

list displays;
list buttons;
integer preview1;
integer preview2;

integer current_cat;

//Compile a list of the names of all links in the linkset.
list GET_LINK_NAMES() {
    list names = [""];
    integer i;
    integer len = llGetNumberOfPrims();
    for(i=1;i<=len;i++) {
        names += [llGetLinkName(i)];
    }
    return names;
}

//Compile a list of link names
PROCESS_DISPLAYS() {
    list links = GET_LINK_NAMES();
    displays = [];
    integer done;
    integer i = 1;
    while(done == FALSE) {
        string name = "DISP_" + (string)i;
        integer link = llListFindList(links, [name]);
        if(link == -1) done = TRUE;
        else displays += [link];
        i++;
    }
    preview1 = llListFindList(links, ["PREVIEW1"]);
    preview2 = llListFindList(links, ["PREVIEW2"]);
}

//Scans the links
PROCESS_BUTTONS() {
    list links = GET_LINK_NAMES();
    buttons = [];
    integer i;
    integer len = llGetListLength(links);
    for(i=0;i<len;i++) {
        string name = llList2String(links, i);
        if(name == "CAT") buttons += [i];
    }
}

SEND_DISPLAY_DATA(integer link) {
    list data = displays;
    llMessageLinked(link, 0, "SEND DISPLAY DATA", llList2CSV(displays));
}

SET_CATEGORY(integer link) {
    current_cat = link;
    llSetObjectDesc((string)link);
    llMessageLinked(link, 0, "SEND PREVIEW DATA", llList2CSV([preview1, preview2]));
}

default {
    state_entry() {
        if(llGetNumberOfPrims() == 0) llSetTimerEvent(1);
        else state loading;
    }
    
    timer() {
        if(llGetNumberOfPrims() == 0) return;
        llSetTimerEvent(0);
        state loading;
    }
}

state loading {
    state_entry() {
        PROCESS_DISPLAYS();
        PROCESS_BUTTONS();
        state ready;
    }
}

state ready {
    state_entry() {
        llOwnerSay("Ready!");
        SEND_DISPLAY_DATA(LINK_ALL_CHILDREN);
        
        integer link = (integer)llGetObjectDesc();
        if(llListFindList(buttons, [link]) != -1) {
            llMessageLinked(link, 0, "SET ACTIVE", "");
        }
    }
    
    touch_start(integer num) {
        integer link = llDetectedLinkNumber(0);
        string name = llGetLinkName(link);
        if(link == LINK_THIS) return;
        if(llListFindList(buttons, [link]) != -1) {
            llMessageLinked(link, 0, "SET ACTIVE", "");
            return;
        }
        
        if(llListFindList(displays, [link]) != -1) {
            llMessageLinked(current_cat, llListFindList(displays, [link]), "SET PREVIEW", "");
            return;
        }
        
        if(link == preview1 || link == preview2) {
            if(llDetectedKey(0) == llGetOwner()) {
                llMessageLinked(current_cat, 0, "GIVE TEXTURE", llGetOwner());
                return;
            }
        }
        
        if(llListFindList(["first","prev","next","last"], [name]) != -1) {
            if(current_cat != 0) {
                llMessageLinked(current_cat, 0, "BUTTON", llToUpper(name));
            }
        }
        
        if(name == "reset") {
            llMessageLinked(LINK_SET, 0, "RESET", "");
            llResetScript();            
        }
    }
    
    link_message(integer link, integer num, string query, key field) {
        if(query == "REQUEST DISPLAY DATA") {SEND_DISPLAY_DATA(link);return;}
        if(query == "SET ACTIVE") {SET_CATEGORY(link);return;}
    }
    
    changed(integer change) {
        if(change & CHANGED_LINK) {
            llMessageLinked(LINK_SET, 0, "RESET", "");
            llResetScript();
        }
    }
}