// Original script from the book:
//
// Scripting Recipes for Second Life
// by Jeff Heaton (Encog Dod in SL)
// ISBN: 160439000X
// Copyright 2007 by Heaton Research, Inc.
//
// This script may be freely copied and modified so long as this header
// remains unmodified.
//
// For more information about this book visit the following web site:
//
// http://www.heatonresearch.com/articles/series/22/

/////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////// READ THIS!!! /////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////

// Mocified by Leda Sands to operate in linked set


//YOU CAN LINK THE DOOR TO A LINK SET.
//SCRIPT IS SET TO NOT RUNNING AS SUPPLIED.
//JUST MAKE SURE THAT YOU RESET THE SCRIPT AFTER ADJUSTING IT AND LINKING IT
//OR IT WILL HOP BACK TO ITS REZZED POSITION.
//SAME GOES IF YOU ROTATE OR MOVE THE ROOT
//ALWAYS RESET THE DOOR SCRIPT BEFORE TOUCHING THE DOOR.


/////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////

float       TIMER_CLOSE = 5.0;      
integer     DIRECTION   = 1;       // direction door opens in. Either 1 (outwards) or -1 (inwards);

integer     DOOR_OPEN   = 1;
integer     DOOR_CLOSE  = 2;

vector      originalPos;      

door(integer what)
{
    rotation    rot;
    rotation    delta;
    vector eul;
   
    llSetTimerEvent(0);
   
    if ( what == DOOR_OPEN )
    {
        llTriggerSound("doorOpen", 1);  
        eul = <0, 0, 90*DIRECTION>; //90 degrees around the z-axis, in Euler form
           
    } else if ( what == DOOR_CLOSE)
    {
        llTriggerSound("doorClose", 1);  
        eul = <0, 0, 90*-DIRECTION>; //90 degrees around the z-axis, in Euler form
    }
   
    eul *= DEG_TO_RAD; //convert to radians rotation
    rot = llGetLocalRot();
    delta = llEuler2Rot(eul);
    rot = delta * rot;                  
    llSetLocalRot(rot);
}
       

default
{  
    on_rez(integer start_param)
    {
        llResetScript();
    }
   
    state_entry()
    {
        originalPos = llGetLocalPos();    
    }
   
    touch_start(integer total_number)
    {
        door(DOOR_OPEN);
        state open_state;
       
    }
   
    moving_end()
    {  
        originalPos = llGetLocalPos();
    }
}

state open_state
{
    state_entry()
    {
        llSetTimerEvent(TIMER_CLOSE);
    }
   
    touch_start(integer num)
    {
        door(DOOR_CLOSE);
        llSetPos(originalPos);            
        state default;
    }
   
    timer()
    {
        door(DOOR_CLOSE);
        llSetPos(originalPos);            
        state default;
    }
   
    moving_start()
    {
        door(DOOR_CLOSE);
        state default;
    }
} 