
// CamTool By: BlueWall
//
// Copyright (C)  2010, BlueWall Information Techniologies, LLC
// All Rights Reserved
//
// License
// 
// This work is released under the Apache License, Version 2
// http://www.apache.org/licenses/LICENSE-2.0.html
//integer g_com_chan;

integer g_com_chan;
integer g_mrk_chan;
integer g_tgt_chan;

vector g_pos;
vector g_tgt;
rotation g_rot;

integer g_count;

integer g_listen;
integer g_handle;

vector g_color;

moveto() {

    while ( llVecDist(llGetPos(), g_pos) > 1.0) {
        llSetPos(g_pos);
    }
    
    llSetRot(g_rot);
    llSetText("Marker #" + (string) g_count + 
                "\n" + "Cam Pos: " + (string) g_pos + 
                "\n" + "Cam Rot: " + (string) g_rot + 
                "\n" + "Cam Tgt: " + (string) g_tgt + 
                "\n", <1.0,1.0,0.0>,1.0);                
}

default
{
    state_entry()
    {
    }
    
    touch_start(integer _det)
    {
        key usr = llDetectedKey(0);
        
        if (usr != llGetOwner())
            return;
        
        g_listen = 1544 + (integer) llFrand(1024.0);
        g_handle = llListen(g_listen,llKey2Name(usr), usr, "");
        
        llDialog(usr,"Select...",["Print","Refresh","Cam","Hide"],g_listen);
    }
    
    listen(integer _ch, string _nm, key _id, string _msg)
    {
        if (_ch == g_listen && _id == llGetOwner())
        {
            llListenRemove(g_handle);
            g_handle = 0; g_listen = 0;
            
            if ( _msg == "Print" )
            {
                // Echo params to chat
                llOwnerSay(" # " + (string) g_count +
                "\nCAMERA_POSITION, " +
                (string) g_pos + "\n" +
                "CAMERA_FOCUS, " + (string) g_tgt);
                return;
            }
            else if ( _msg == "Refresh" )
            {
                // update to present cam 
                llRegionSay(g_com_chan,"REFRESH");
                return;
                
            }
            else if ( _msg == "Cam" )
            {
                // Msg controller to set cam to this
                llRegionSay(g_com_chan,"CAM#" +
                            (string) g_pos + "#" +
                            (string) g_tgt );
                return;
            }
            else if ( _msg == "Hide" )
            {
                // Hide marker for a time
                g_color = llGetColor(ALL_SIDES);
                llSetPrimitiveParams([PRIM_COLOR,ALL_SIDES,g_color,0.0,PRIM_GLOW,ALL_SIDES,0.0]);
                llSetTimerEvent(10.0);
            }
        }
        
        if (_nm == "CamTool" && _msg == "DISPOSE")
        {
            llDie();
        }
        else if (_nm == "CamTool" && _msg != "DISPOSE")
        {
            list params = llParseString2List(_msg,["#"],[]);
            
            g_pos = llList2Vector(params,0);
            g_rot = llList2Rot(params,1);
float g_trans = 0.20;
            g_count = llList2Integer(params,2);
            g_tgt_chan = llList2Integer(params,3);
            g_com_chan = llList2Integer(params,4);
            
            llRegionSay(g_tgt_chan, "TARGET_LOC");
        }
        else if (_nm == "Target")
        {
float g_trans = 0.20;
            g_tgt = (vector) _msg;
            moveto();
        }
    }
    
    timer() {
        llSetPrimitiveParams([PRIM_COLOR,ALL_SIDES,g_color,0.70,PRIM_GLOW,ALL_SIDES,0.10]);
        llSetTimerEvent(0.0);
    }
            
    on_rez(integer _parm)
    {
        llListen(_parm,"","","");
        g_mrk_chan = _parm;
    }
}