// (c) The owner of Avatar Jeff Kelley, 2010
//
// This script is licensed under Creative Commons BY-NC-SA
// See <http://creativecommons.org/licenses/by-nc-sa/3.0/>
//
// You may not use this work for commercial purposes.
// You must attribute the work to the author, Jeff Kelley.
// You may distribute, alter, transform, or build upon this work
// as long as you do not delete the name of the original author.


////////////////////////////////////////////////////////////////////////////////
// Auto-configure 2 child prims for a 2x5 xyText display
// The display prim is a prism with 
// Path begin = 0.2, Path End = 0.8,
// Hollow = 65 (ar seen in viewer)
////////////////////////////////////////////////////////////////////////////////

//float WIDTH = 1;        // Width of each 5-chars display
//float BORDER = 0.1;     // Border applied to root prim
//
//float BBRATIO = 0.86;   // This the ratio from the actual size to
//                        // the bouding box for a prism. Needed to
//                        // align precisely the two display prims.
//
//
//vector BACK_COLOR = <0.0,0.0,0.0>;  // Can be changed by editing
//vector TEXT_COLOR = <1.0,0.5,0.0>;  // Can be changed by editing
//
//key BLANK_TX = "5748decc-f629-461c-9a36-a35a221fe21f"; // Blank texture
//
//list xyCellPrimParams =[PRIM_TYPE, 
//                        PRIM_TYPE_PRISM,    // integer prim_type
//                        PRIM_HOLE_DEFAULT,  // integer hole_shape
//                        <0.2, 0.8, 0.0>,    // vector cut 
//                        0.65,               // float hollow 
//                        <0, 0, 0>,          // vector twist 
//                        <1, 1, 0>,          // vector top_size 
//                        <0, 0, 0>           // vector top_shear
//                        ];
//
//configureDisplay(integer link) {
//    // Prim shape
//    llSetLinkPrimitiveParamsFast (link, xyCellPrimParams);
//
//    // Face colors
//    llSetLinkPrimitiveParams (link, [PRIM_FULLBRIGHT,ALL_SIDES,TRUE]);
//    llSetLinkTexture (link, BLANK_TX, ALL_SIDES);
//    llSetLinkColor (link, BACK_COLOR, ALL_SIDES);
//    llSetLinkColor (link, TEXT_COLOR, FACE1);
//    llSetLinkColor (link, TEXT_COLOR, FACE2);
//    llSetLinkColor (link, TEXT_COLOR, FACE3);
//    llSetLinkColor (link, TEXT_COLOR, FACE4);
//    llSetLinkColor (link, TEXT_COLOR, FACE5);
//
//    // Size and Pos
//     vector size = <0.001, WIDTH, WIDTH/4>;
//    llSetLinkPrimitiveParams (link, [PRIM_SIZE, size]);
//}
//
//configureRoot(integer link) {
//    llSetLinkTexture (link, BLANK_TX, ALL_SIDES);
//    llSetLinkColor (link, BACK_COLOR, ALL_SIDES);
//    vector size = <0.1, 2*WIDTH*BBRATIO, WIDTH/4>;
//    size += <0, BORDER, BORDER>;
//    llSetLinkPrimitiveParams (link, [PRIM_SIZE, size]);
//}
//
//configure() {
//    integer nprims = llGetNumberOfPrims();
//    llSay (0, "Found "+(string)nprims+" prims.");
//
//    llSay (0, "Configuring root"); configureRoot(1);
//
//    llSay (0, "Configuring prim 2"); configureDisplay(2);
//    llSetLinkPrimitiveParams (2, [PRIM_POSITION, <0.06,-WIDTH/2*BBRATIO,0>]);
//
//    llSay (0, "Configuring prim 3"); configureDisplay(3);
//    llSetLinkPrimitiveParams (3, [PRIM_POSITION, <0.06, WIDTH/2*BBRATIO,0>]);
//}


////////////////////////////////////////////////////////////////////////////////
// Display 5 characters on sides 3,7,4,6,1 of a flattened prism
// Uses the one character per side texture since it is faster
// Adapted from http://wiki.secondlife.com/wiki/XyText_1.5
// Credits to Xylor Baysklef for original code
// Cell indexing feature removed. Text is broken in 5-char units
// by controller script and each cell is invididually adressed
////////////////////////////////////////////////////////////////////////////////


// Face numbers
integer FACE1 = 3;
integer FACE2 = 7;
integer FACE3 = 4;
integer FACE4 = 6;
integer FACE5 = 1;

// Texture offset adjustments
vector OFFSET1 = <0.050,0.00,0.00>;
vector OFFSET2 = < 0.00,0.00,0.00>;
vector OFFSET3 = <-0.34,0.00,0.00>;
vector OFFSET4 = < 0.00,0.00,0.00>;
vector OFFSET5 = <-0.050,0.00,0.00>;

key gFontTexture;       // Text font
string  gCharIndex;     // All displayable characters


ResetCharIndex() {
    gFontTexture = llGetInventoryKey(llGetInventoryName(INVENTORY_TEXTURE,0));
    gCharIndex  = " !\"#$%&'()*+,-./0123456789:;<=>?@";
    gCharIndex += "ABCDEFGHIJKLMNOPQRSTUVWXYZ[\\]^_`";
    gCharIndex += "abcdefghijklmnopqrstuvwxyz{|}~";
    gCharIndex += "π∂•°√";
    gCharIndex += "\n\n\n\n\n";
}

vector GetGridOffset(integer index) {
    // Calculate the offset needed to display this character.
    integer Row = index / 10;
    integer Col = index % 10;
    // Return the offset in the texture.
    return <-0.45 + 0.1 * Col, 0.45 - 0.1 * Row, 0.0>;
}

ShowChars(integer cell,vector off1,vector off2,vector off3,vector off4,vector off5) {
    llSetLinkPrimitiveParamsFast(cell, [
        PRIM_TEXTURE,FACE1,(string) gFontTexture, 
            <0.16, 0.1, 0>,  off1+OFFSET1, 0.0,
        PRIM_TEXTURE,FACE2,(string) gFontTexture, 
            <0.07, 0.1, 0>,  off2+OFFSET2, 0.0,
        PRIM_TEXTURE,FACE3,(string) gFontTexture, 
            <-1.00, 0.1, 0>, off3+OFFSET3, 0.0,
        PRIM_TEXTURE,FACE4,(string) gFontTexture, 
            <0.07, 0.1, 0>,  off4+OFFSET4, 0.0,
        PRIM_TEXTURE,FACE5,(string) gFontTexture, 
            <0.16, 0.1, 0>, off5+OFFSET5, 0.0
        ]);
}

DisplayString(integer cell,string str) {  // Render 5 characters
   vector off0 = GetGridOffset(llSubStringIndex(gCharIndex,llGetSubString(str,0,0)));
   vector off1 = GetGridOffset(llSubStringIndex(gCharIndex,llGetSubString(str,1,1)));
   vector off2 = GetGridOffset(llSubStringIndex(gCharIndex,llGetSubString(str,2,2)));
   vector off3 = GetGridOffset(llSubStringIndex(gCharIndex,llGetSubString(str,3,3)));
   vector off4 = GetGridOffset(llSubStringIndex(gCharIndex,llGetSubString(str,4,4)));
   // Use these grid positions to display the correct textures/offsets.
   ShowChars(cell,off0,off1,off2,off3,off4);
}

////////////////////////////////////////////////////////////////////////////////
// Main program
////////////////////////////////////////////////////////////////////////////////

integer CELL1;
integer CELL2;

integer findLinkByName(string name) {
    integer nprims = llGetNumberOfPrims();
    integer i; for (i=1; i<=nprims; i++)
        if (llGetLinkName(i) == name) return i;
    return -1;
}

displayGridCoords() {
    vector regionCoor = llGetRegionCorner();
    regionCoor = regionCoor / 256;

    string gridX = (string)llFloor(regionCoor.x);
    string gridY = (string)llFloor(regionCoor.y);

    if (llStringLength(gridX) < 5) gridX = gridX+",";

    if (CELL1 != -1) DisplayString(CELL1, gridX);
    if (CELL2 != -1) DisplayString(CELL2, gridY);
}

default {
    state_entry() {
        ResetCharIndex();
        CELL1 = findLinkByName("xy cell 1");
        CELL2 = findLinkByName("xy cell 2");

        if ((CELL1 == -1) || (CELL2 == -1))
            llOwnerSay ("No display prims found. Location display will be disabled");

        integer type = llGetInventoryType("xyTexture");

        if (type == -1)
            llOwnerSay ("No font texture found. Location display will be disabled");

        displayGridCoords();
    }

    on_rez (integer parm)   { displayGridCoords(); }
    changed(integer what)   { displayGridCoords(); }
}