// Touch a quote script 
// By CodeBastard Redgrave
// Reads quotes from a notecard and displays them sequentially when you touch!
// BEWARE it cannot handle quotes more than 256 characters. Split them into multiple lines if needed.
 
// This is a free script, DO NOT RESELL!
// It's loosely based on the classic dataserver script from the LSL wiki.
// Feel free to modify it to make your own book! Make code not war <3
 
// Globals
integer iNotecardIndex;
integer iNotecardCount;
integer iNoteCardLine;
key kCurrentDataRequest;
string sData;
list QUOTE = [];
integer counter = 0;
string sSettingsNotecard = "_quotes";
 
default
{
    on_rez( integer param )
    {
         llResetScript();
    }
 
    touch_end(integer total_number)
    {
        // integer index = llRound(llFrand(1) * (iNoteCardLine-1));
        llSay(0,llList2String(QUOTE, counter));
        counter++;
 
        if ( counter > (iNoteCardLine-1))  { counter = 0;}
 
    }
 
    state_entry()
    {
        //integer iii;
 
        llOwnerSay("Loading quotes, please wait...");
 
        iNotecardCount = llGetInventoryNumber( INVENTORY_NOTECARD );
        iNotecardIndex = 0;
        if( iNotecardCount > iNotecardIndex ) {
 
            iNoteCardLine = 0;
            kCurrentDataRequest = llGetNotecardLine( sSettingsNotecard, iNoteCardLine );
            iNotecardIndex++;
        }
    }
 
    dataserver( key kQuery, string sData )
    {
        list lSetting;
 
        kCurrentDataRequest = "";
        if( sData != EOF )
        {
                if ( (string)sData == "" ) { return; }
 
                QUOTE += [(string)sData];
 
                kCurrentDataRequest = llGetNotecardLine( sSettingsNotecard, ++iNoteCardLine );
        }
        else
        {
            iNotecardIndex++;
            if( iNotecardIndex < llGetInventoryNumber( INVENTORY_NOTECARD ) )
            {
                iNoteCardLine = 0;
                llGetNotecardLine( sSettingsNotecard, iNoteCardLine );
            }
            else
            {
                llOwnerSay("Ready!");
                llOwnerSay((string)iNoteCardLine + " Quotes Loaded");
                llOwnerSay( "FreeMem: " + (string)llGetFreeMemory() );   
            }
        }
    }
    changed(integer change)
    {
        if (change & CHANGED_INVENTORY)
            llResetScript();
    }
}
