// zTech Texture Sorter v1.0
// Copyright (C) 2010 Zauber Paracelsus (also known as Zauber Exonar)
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307, USA.

key GRID_TEX = "dacd3247-cc73-4209-b849-cafa86db9c30";

string active_texture;
integer tex_total;
integer page_total;
integer current_page = 1;
integer display_total;
integer active;
integer preview1;
integer preview2;
list displays;

LOAD_DISPLAYS(list data) {
    displays = [];
    integer i;
    display_total = llGetListLength(data);
    for(i=0; i<display_total; i++) {
        displays += (integer)llList2String(data, i);
    }
}

LOAD_TEXTURES() {
    tex_total = llGetInventoryNumber(INVENTORY_TEXTURE);
    if(tex_total == 0) return;
    page_total = (integer)llCeil((float)tex_total / display_total);
}

SET_INDICATOR(vector color) {
    llSetLinkPrimitiveParamsFast(LINK_THIS, [PRIM_COLOR, ALL_SIDES, color, 1.0, PRIM_COLOR, 0, <1,1,1>, 1.0]);
}

LOAD_PAGE() {
    integer i;
    integer offset = (current_page-1) * display_total;
    for(i=0;i<display_total;i++) {
        integer link = llList2Integer(displays, i);
        key texture = GRID_TEX;
        if((i+offset+1) <= tex_total) {
            texture = llGetInventoryKey(llGetInventoryName(INVENTORY_TEXTURE, i+offset));
        }
        llSetLinkPrimitiveParamsFast(link, [PRIM_TEXTURE, ALL_SIDES, texture, <1,1,0>, <0,0,0>, 0]);
        //llSetLinkPrimitiveParamsFast(link, [PRIM_TEXT, (string)(i+offset+1), <1,1,1>, 1.0]);
    }
    string text = "Displaying " + (string)(((current_page-1) * display_total)+1) + "-";
    if((current_page * display_total) > tex_total) text += (string)tex_total;
    else text += (string)(current_page * display_total);
    text += " of " + (string)tex_total + " textures";
    llSetLinkPrimitiveParamsFast(LINK_ROOT, [PRIM_TEXT, text, <1,1,1>, 1.0]);
    llSetLinkPrimitiveParamsFast(LINK_THIS, [PRIM_TEXT, llGetObjectDesc(), <1,1,1>, 1.0]);
}

SET_PREVIEW(integer index) {
    integer offset = (current_page-1) * display_total;
    key texture = GRID_TEX;
    if((index+offset+1) <= tex_total) {
        active_texture = llGetInventoryName(INVENTORY_TEXTURE, index+offset);
        texture = llGetInventoryKey(active_texture);
    }
    llSetLinkPrimitiveParamsFast(preview1, [PRIM_TEXTURE, ALL_SIDES, texture, <1,1,0>, <0,0,0>, 0]);
    llSetLinkPrimitiveParamsFast(preview2, [PRIM_TEXTURE, ALL_SIDES, texture, <3,3,0>, <0,0,0>, 0]);
}

default {
    state_entry() {
        llSetTimerEvent(1);
    }
    
    link_message(integer link, integer num, string query, key data) {
        if(link == LINK_ROOT) {
            if(query == "SEND DISPLAY DATA") {
                llSetTimerEvent(0);
                LOAD_DISPLAYS(llCSV2List(data));
                state loading;
            }
        }
    }
    
    timer() {
        llSetTimerEvent(0);
        llMessageLinked(LINK_ROOT, 0, "REQUEST DISPLAY DATA", "");
    }
}

state loading {
    state_entry() {
        LOAD_TEXTURES();
        if(tex_total == 0) SET_INDICATOR(<1,0,0>);
        else {
            state ready;
        }
    }
    
    link_message(integer link, integer num, string query, key data) {
        if(link == LINK_ROOT) {
            if(query == "SEND DISPLAY DATA") {
                LOAD_DISPLAYS(llCSV2List(data));
                return;
            }
            if(query == "SET ACTIVE") {
                llOwnerSay("No textures in this category");
            }
        }
    }
    
    changed(integer change) {
        if(change & CHANGED_INVENTORY) {
            LOAD_TEXTURES();
            if(tex_total != 0) state ready;
        }
    }
}

state ready {
    state_entry() {
        string desc = llList2String(llGetLinkPrimitiveParams(LINK_ROOT, [PRIM_DESC]), 0);
        if((integer)desc == llGetLinkNumber()) {
            active = TRUE;
            llMessageLinked(LINK_ALL_OTHERS, 0, "SET ACTIVE", "");
            current_page = 1;
            LOAD_PAGE();
            SET_PREVIEW(0);
        } else {
            SET_INDICATOR(<1,1,0>);
        }
    }
    
    link_message(integer link, integer num, string query, key data) {
        if(link == LINK_ROOT) {
            if(query == "SEND DISPLAY DATA") {
                LOAD_DISPLAYS(llCSV2List(data));
                return;
            }
            if(query == "RESET") {
                llResetScript();
                return;
            }
            if(query == "SEND PREVIEW DATA") {
                list previews = llCSV2List(data);
                preview1 = (integer)llList2String(previews, 0);
                preview2 = (integer)llList2String(previews, 1);
                return;
            }
            if(query == "SET PREVIEW") {
                SET_PREVIEW(num);
                return;
            }
            
            if(query == "GIVE TEXTURE") {
                llGiveInventory(data, active_texture);
                return;
            }
        }
        
        if(query == "SET ACTIVE") {
            if(link == LINK_ROOT) {
                SET_INDICATOR(<0,1,0>);
                active = TRUE;
                current_page = 1;
                LOAD_PAGE();
                SET_PREVIEW(0);
                llMessageLinked(LINK_ALL_OTHERS, 0, "SET ACTIVE", "");
            } else {
                SET_INDICATOR(<1,1,0>);
                active = FALSE;
            }
            return;
        }
        
        if(query == "BUTTON") {
                 if(data == "FIRST") current_page = 1;
            else if(data == "PREV") current_page--;
            else if(data == "NEXT") current_page++;
            else if(data == "LAST") current_page = page_total;
            if(current_page <= 0) current_page = page_total;
            if(current_page > page_total) current_page = 1;
            LOAD_PAGE();
        }
    }
    
    changed(integer change) {
        if(change & CHANGED_INVENTORY) {
            LOAD_TEXTURES();
            if(tex_total == 0) state loading;
            else {
                LOAD_PAGE();
            }
        }
    }
}