//////////////////////////////////////////////////////////////////////////
// Script Name: TP Hud With Menu
// Author: albertlr Landar
// A teleport hud modified from the plaza teleport system for OSgrid

// when touched, presents a dialog with multiple teleport destinations
// Touch again to teleport - wear in top left corner.  A copy of this 
// Script and the hud can be obtained in the Wright Plaza Freebie building.

// This program is free software; you can redistribute it and/or modify it.
// License information must be included in any script you give out or use.
// This script is licensed under the Creative Commons Attribution-Share Alike 3.0 // License from http://creativecommons.org/licenses/by-sa/3.0 unless licenses are
// included in the script or comments by the original author,in which case
// the authors license must be followed.

// Please leave any authors credits intact in any script you use or publish.
///////////////////////////////////////////////////////////////////////////////
string DestinationName;
vector DestinationPos;
vector DestinationLook;
integer CHANNEL; // dialog channel
integer handle;
list MENU_MAIN = ["Bade Plaza", "Lbsa Plaza", "SeaPrior Plaza", "Teravus Plaza", "Wright Plaza", "Zaius Plaza", "Sandbox Plaza", "Port Azure", "Snoopies", "ScriptWorkz", "Freebie Mall", "Next..."]; // the main menu
list MENU_OPTIONS = ["Place 1", "Place 2", "Place 3", "Place 4", "Place 5", "Place  6", "Place 7", "Place 8", "Place 9", "Place 10", "Place 11", "...Back"]; // a submenu



default {
    state_entry() {
        CHANNEL = (integer)(llFrand(-1000000000.0) - 1000000000.0);
        handle = llListen(CHANNEL, "", NULL_KEY, ""); // listen for dialog answers (from multiple users)
    }

    touch_start(integer total_number)
    {
        llListenControl(handle, TRUE); // ...enable listen
        llDialog(llDetectedKey(0),"Click A Destination, Then Click The Hud To TP.", MENU_MAIN, CHANNEL); // present dialog on click
    }

    listen(integer channel, string name, key id, string message)
    {   // when told "off"...
        if (message == "off") llListenControl(handle, FALSE); // .. disable listen

        //else llSay(0, llList2CSV([name, message])); // repeat message
      
        if (llListFindList(MENU_MAIN + MENU_OPTIONS, [message]) != -1)  // verify dialog choice
        {
            //llSay(0, name + " picked the menu choice '" + message + "'."); // output the answer
            if (message == "Next...")
                llDialog(id, "Click A Destination, Then Click The Hud To TP.", MENU_OPTIONS, CHANNEL); // present submenu on request
            else if (message == "...Back")
                llDialog(id, "Click A Destination, Then Click The Hud To TP.", MENU_MAIN, CHANNEL); // present main menu on request to go back
            // here you have the name and key of the user and can easily verify if they have the permission to use that option or not
            else if (message == "Bade Plaza"){       
            state Bade;} 
            
            if (message == "Lbsa Plaza"){            
            state Lbsa;}

            if (message == "SeaPrior Plaza"){          
            state SeaPrior;}

            if (message == "Teravus Plaza"){            
            state Teravus;}
            
            if (message == "Wright Plaza"){         
            state Wright;}
            
            if (message == "Zaius Plaza"){        
            state Zaius;}
            
            if (message == "Sandbox Plaza"){        
            state Sandbox;}
            
            if (message == "Port Azure"){        
            state Azure;}
            
            if (message == "Snoopies"){        
            state Samsara;}
            
            if (message == "ScriptWorkz"){        
            state ScriptWorkz;}
            
            if (message == "Freebie Mall"){        
            state Freebie;}
            
          //   else
      //  llSay(0, name + " picked invalid option '" + llToLower(message) + "'."); // not a valid dialog choice
         } 
    }
}


state Bade
{
        touch_start(integer num_detected){
            DestinationName = "Bade Plaza";
            DestinationPos = <92.0,115.0,41.0>;
            DestinationLook = <128.0,128.0,22.0>;
            llMapDestination( DestinationName, DestinationPos, DestinationLook );
            state default;}
}

state Lbsa
{
        touch_start(integer num_detected){
            DestinationName = "Lbsa Plaza";
            DestinationPos = <99.0,127.0,40.0>;
            DestinationLook = <128.0,128.0,22.0>;   
            llMapDestination( DestinationName, DestinationPos, DestinationLook );
            state default;}
}

state SeaPrior
{
        touch_start(integer num_detected){
            DestinationName = "SeaPrior Plaza";
            DestinationPos = <142.0,130.0,23.0>;
            DestinationLook = <128.0,128.0,22.0>; 
            llMapDestination( DestinationName, DestinationPos, DestinationLook );
            state default;}
}

state Teravus
{
        touch_start(integer num_detected){
            DestinationName = "Teravus Plaza";
            DestinationPos = <104.0,137.0,23.0>;
            DestinationLook = <128.0,128.0,22.0>;
            llMapDestination( DestinationName, DestinationPos, DestinationLook );
            state default;}
}

state Wright
{
        touch_start(integer num_detected){
            DestinationName = "Wright Plaza";
            DestinationPos = <128.0,126.0,22.0>;
            DestinationLook = <128.0,128.0,22.0>;   
            llMapDestination( DestinationName, DestinationPos, DestinationLook );
            state default;}
}

state Zaius
{
        touch_start(integer num_detected){
            DestinationName = "Zaius Plaza";
            DestinationPos = <120.0,101.0,24.0>;
            DestinationLook = <128.0,128.0,22.0>;   
            llMapDestination( DestinationName, DestinationPos, DestinationLook );
            state default;}
}

state Sandbox
{
        touch_start(integer num_detected){
            DestinationName = "Sandbox Plaza";
            DestinationPos = <133.0,95.0,23.0>;
            DestinationLook = <128.0,128.0,22.0>;   
            llMapDestination( DestinationName, DestinationPos, DestinationLook );
            state default;}
}

state Azure
{
        touch_start(integer num_detected){
            DestinationName = "Port Azure";
            DestinationPos = <133.0,95.0,23.0>;
            DestinationLook = <128.0,128.0,22.0>;   
            llMapDestination( DestinationName, DestinationPos, DestinationLook );
            state default;}
}

state Samsara
{
        touch_start(integer num_detected){
            DestinationName = "Samsara";
            DestinationPos = <154.0,15.0,23.0>;
            DestinationLook = <128.0,128.0,22.0>;   
            llMapDestination( DestinationName, DestinationPos, DestinationLook );
            state default;}
}

state ScriptWorkz
{
        touch_start(integer num_detected){
            DestinationName = "ScriptWorkz";
            DestinationPos = <131.0,130.0,24.0>;
            DestinationLook = <128.0,128.0,22.0>;   
            llMapDestination( DestinationName, DestinationPos, DestinationLook );
            state default;}
}

state Freebie
{
        touch_start(integer num_detected){
            DestinationName = "Wright Plaza";
            DestinationPos = <34.0,142.0,22.0>;
            DestinationLook = <128.0,128.0,22.0>;   
            llMapDestination( DestinationName, DestinationPos, DestinationLook );
            state default;}
}