// Open Sourcve CC-BY-NC
//:AUTHOR: Ferd Frederix
//:Please keep open source Open!


integer _debug = 0;

integer REZ = 3454;

toggle (float what) {
    return;
    integer j = llGetNumberOfPrims();
    integer i;
    for ( i = 1; i < j; i++) {
        llSetLinkAlpha(i, what, ALL_SIDES);        
    }    
} 
 
float INTERVAL = 0.5;
float TOLERANCE = 5;

float SPEED = 10.0; // speed of vehicle 
 
vector TARGET = <0,0,.2>;
vector ROT = <0, 0, 180>; 
 
vector startPos;    
list lCoordinate;
list lRotation ;
list lText;
 
  
// notecard reading
integer iIndexLines; 
integer i;
string NOTECARD = "Route";        // the notecard for configuring

key kNoteCardLines;        // the key of the notecard
key kGetIndexLines;        // the key of the current line

integer count = 0;
   
vector TargetLocation;
rotation TargetRotation;

 
Goto()
{
    if (_debug) 
        llOwnerSay("Looking at Target Location = " + (string) TargetLocation);

    vector ownPosition = llGetPos();    
    float dist = llVecDist(ownPosition, TargetLocation);
    
    float rate = dist / SPEED;
        
    rotation ownRotation = llGetRot();
 
    llSetKeyframedMotion(
            [(TargetLocation - ownPosition) + <0.0, 0.0, -.5> * TargetRotation,
            NormRot(TargetRotation/ownRotation), rate],
            []);

             
}

rotation NormRot(rotation Q)
{
    float MagQ = llSqrt(Q.x*Q.x + Q.y*Q.y +Q.z*Q.z + Q.s*Q.s);
 
    return
        <Q.x/MagQ, Q.y/MagQ, Q.z/MagQ, Q.s/MagQ>;
}

integer locationLength;


string strip( string str)
{        
    string out;
    integer i;
    
    //llOwnerSay("str = " + str);
    
    for ( ; i < llStringLength(str); i++)
    {
        out += llGetSubString(str,i,i);

        out = llStringTrim(out, STRING_TRIM);
        //llOwnerSay("out = " + out + " at " + (string) i);
    }
    return out;

}

string Getline(list Input, integer line)
{
    return strip(llList2String(Input, line));
} 


default
{
    on_rez(integer param)
    {
        llResetScript();
    }
    
    changed( integer change )
    { 
        if (change & CHANGED_INVENTORY) 
        {    
            llResetScript();
        }
    }
    
    state_entry() 
    {
        
         llSetLinkPrimitiveParamsFast(LINK_ROOT,
                [PRIM_PHYSICS_SHAPE_TYPE, PRIM_PHYSICS_SHAPE_CONVEX,
            PRIM_LINK_TARGET, LINK_ALL_CHILDREN,
                PRIM_PHYSICS_SHAPE_TYPE, PRIM_PHYSICS_SHAPE_NONE]);
            
        llSitTarget(<0,0,0>, <0,0,0,1>); // where they sit
        
       // return;
        
        kNoteCardLines = llGetNumberOfNotecardLines(NOTECARD);
        kGetIndexLines = llGetNotecardLine(NOTECARD,0);

         llSay (0, "Tour guide initialising. Please wait.");
    } 
    
     // read notecard on bootup
    dataserver(key queryid, string data)
    {

        vector TempLocation;
        if (queryid == kNoteCardLines)
        {
            iIndexLines = (integer) data;
        }

        if (queryid == kGetIndexLines)
        {
            if (data != EOF) 
            {
                queryid = llGetNotecardLine(NOTECARD, i);
                list lLine = (llParseString2List(data, ["|"], []));
                if (_debug )    llOwnerSay("Line = " + llDumpList2String(lLine,":"));

                TempLocation = (vector)  Getline(lLine,1);  
                TempLocation.z = 20;
                if (TempLocation != ZERO_VECTOR)
                {
                    rotation Rot = (rotation) llList2String(lLine,2);
                    string text = llList2String(lLine,3);
    
                    if (_debug) llOwnerSay((string)TempLocation);
                    
                    //TempLocation += <0,0,4.5>;
                    
                    lCoordinate += [TempLocation];
                    lRotation +=  [Rot];
                    lText += [text];
                    
                    locationLength = (llGetListLength(lCoordinate));
                    integer     InitPerCent = (integer) llRound(((float) locationLength / (float) iIndexLines) * 100);
                    llSetText("Initialising... \n" + (string) InitPerCent + "%" , <1,1,1>, 1.0);
                    if (InitPerCent == 100)
                    {
                        state moving;
                    }        
                } 
                else
                {
                    state moving;
                }
                i++;
            }
            kGetIndexLines = llGetNotecardLine(NOTECARD,i);
            // (_debug ) llOwnerSay("Got " + (string) i);
        } 
    }
    
    
    state_exit()
    {
        llSetText("", <1,1,1>, 1.0);
        TargetLocation = llList2Vector(lCoordinate, 0);  // Look at 0th
        TargetRotation = llList2Rot(lRotation, 0);  // Look at 0th
        startPos = TargetLocation;
        
        Goto();     
    }    
}


state moving
{

    state_entry()
    {
        
        if (_debug) llOwnerSay("State Moving entered, is pointing to target " + (string) TargetLocation );
         
          TargetLocation = llList2Vector(lCoordinate, 0);  // Look at 0th
        TargetRotation = llList2Rot(lRotation, 0);  // Look at 0th
        startPos = TargetLocation;
        
        Goto();     
        
        
        string SpeakThis =  llList2String(lText, count);
        
        if (llStringLength(SpeakThis))
            llSay(0,SpeakThis);
                  
        llSetTimerEvent(INTERVAL);
    }
    
    changed(integer change)
    {
        if (change & CHANGED_REGION_START)
        {
            llResetScript();
        }
    
    }    
     
     
    on_rez(integer param)
    {
        llResetScript();
    }
        
    timer()   
    {
        
        if (llVecMag(llGetPos() - TargetLocation) <= TOLERANCE) {
            
            if (_debug) llOwnerSay("At location: " + (string) llGetPos());
            count ++;
             
            if (count >= locationLength) {   
            
                TargetLocation = llList2Vector(lCoordinate, 0);  // Look at 0th
                TargetRotation = llList2Rot(lRotation, 0);  // Look at 0th
                startPos = TargetLocation;
                
                Goto();     
                
                count = 0;
                    
            } else {
                TargetLocation = llList2Vector(lCoordinate, count);  // Look at nth
                TargetRotation = llList2Rot(lRotation, count);  // Look at nth
                string SpeakThis =  llList2String(lText, count); 
        
                if (llStringLength(SpeakThis))
                    llSay(0,SpeakThis);
                
                Goto();
                if (_debug) llOwnerSay("New Target: " + (string) TargetLocation); 
            }
        }
             
    } 
    
     
}
