integer chatOffset = -2014101600;  
list Users;
integer rows;
integer Question = FALSE;
integer userAdd = FALSE;
integer removeRow;
list AddUsers;
default
{
    state_entry()
    {
        
        llListen(chatOffset, "", "", "");
        llListen(1, "", llGetOwner(), "");
        llSay(chatOffset, "GIVE LIST");       
    }
    
    listen(integer chan, string name, key id, string msg){
                
        if(llSubStringIndex(name, "AvaCon Presenter Screen") > -1){
            Users = llCSV2List(msg);
            rows = llGetListLength(Users)/3;
        
        
            string CommandList = ""; // Storage for our drawing commands
        
            //background header
            CommandList = osSetPenColor( CommandList, "FFFFFFB1" );     
            CommandList = osMovePen( CommandList, 0, 0 );               
            CommandList = osDrawFilledRectangle( CommandList, 512, 30); 
        
            //Dynamically create presenter background rows
            integer i = 0;
            integer start = 30;
            for(i;i<rows;i++){
                CommandList = osSetPenColor( CommandList, "FFF5F5F5" );                         

                //On even rows, the background is darker gray
                if(i%2){
                    CommandList = osSetPenColor( CommandList, "FFCCCCCC" );                         
                }
            
                CommandList = osMovePen( CommandList, 0, start);
                CommandList = osDrawFilledRectangle( CommandList, 512, 30);
                start += 30; 
            
            }
        
            //Draw lines
            CommandList = osSetPenSize( CommandList, 1 );  
            CommandList = osSetPenColor( CommandList, "Black" ); 
            CommandList = osDrawLine( CommandList, 250, 0, 250, 1024 );        
            CommandList = osDrawLine( CommandList, 400, 0, 400, 1024 );
            CommandList = osDrawLine( CommandList, 0, 31, 512, 31 );    
        
            //write header - presenter
            CommandList = osMovePen( CommandList, 5, 5 ); 
            CommandList = osSetPenColor( CommandList, "Black" );             
            CommandList = osSetFontSize( CommandList, 10 );
            CommandList = osDrawText( CommandList,  "Presenters"); 
            
            
            //Add button
            CommandList = osSetPenColor( CommandList, "FFB5B5FF" );     
            CommandList = osMovePen( CommandList, 140, 5 );               
            CommandList = osDrawFilledRectangle( CommandList, 50, 20); 
            CommandList = osMovePen( CommandList, 150, 5 );               
            CommandList = osSetPenColor( CommandList, "Black" ); 
            CommandList = osDrawText( CommandList,  "Add"); 
            
            //Refresh Button
            CommandList = osSetPenColor( CommandList, "FFB5B5FF" );     
            CommandList = osMovePen( CommandList, 195, 5 );               
            CommandList = osDrawFilledRectangle( CommandList, 50, 20); 
            CommandList = osMovePen( CommandList, 197, 5 );               
            CommandList = osSetPenColor( CommandList, "Black" ); 
            CommandList = osDrawText( CommandList,  "Refresh"); 
            
            //Active header     
            CommandList = osMovePen( CommandList, 255, 5);
            CommandList = osDrawText( CommandList,  "Active"); 
            
            //Remove header
            CommandList = osMovePen( CommandList, 405, 5);
            CommandList = osDrawText( CommandList, "Remove"); 
        
            //write rows
            i = 0;
            start = 35;
            for(i;i<rows;i++){
            
                //Name
                CommandList = osMovePen( CommandList, 5, start);
                CommandList = osDrawText( CommandList, llList2String(Users,(i*3) + 1));
            
                //Active status
                string tActive = llList2String(Users,(i*3) + 2);
                if(tActive == "1"){
                    tActive = "Yes";
                }else{
                    tActive = "No";
                }
            
                CommandList = osMovePen( CommandList, 255, start);
                CommandList = osDrawText( CommandList, tActive);
            
                //Remove button
                CommandList = osMovePen( CommandList, 405, start);
                CommandList = osDrawText( CommandList, "Remove");
            
                start += 30;
            }
 
            // Now draw menu
            osSetDynamicTextureData( "", "vector", CommandList, "width:512,height:1024", 0 );
        }else if((chan == 1) && (id == llGetOwner())){
            llSay(chatOffset, msg);
        }
    }
    
    touch_end(integer num_d){
        
        //Add User Logic
        if(userAdd){
            
            vector tPos = llDetectedTouchST(0);

            //translate the tPos to pixel position. texture is 512*512
            float height = 1024 - 1024 * tPos.y;
            float width  = 512 * tPos.x;
            
            integer clickedRow = llFloor(height/30);
             
            if(clickedRow == 0){
                if(width > 450 && width < 500){
                    userAdd = FALSE;
                    llSetTimerEvent(0);
                    llSay(chatOffset, "GIVE LIST");
                }                 
            }else{
                userAdd = FALSE;
                llSetTimerEvent(0);
                clickedRow--;
                llSay(chatOffset, "ADD NEW::" + llList2String(AddUsers, clickedRow*3) + "," + 
                                                llList2String(AddUsers, (clickedRow*3)+2) + "," + "0");
                llOwnerSay("Adding new presenter " + llList2String(AddUsers, (clickedRow*3)+2));
                                                
            }
            
        
        //Remove question logic
        }else if(Question){
            Question = FALSE;
            llSetTimerEvent(0);
            vector tPos = llDetectedTouchST(0);

            //translate the tPos to pixel position. texture is 512*512
            float height = 1024 - 1024 * tPos.y;
            float width  = 512 * tPos.x;
            
            if(height > 30 && width < 256){
                
                llOwnerSay("Removing User: " + llList2String(Users, (removeRow*3) + 1));
                llSay(chatOffset, "REMOVE::" + llList2String(Users,removeRow*3)); 
                
            }else if(height > 30 && width > 256){
                llOwnerSay("Ok not removing them.");                
                llSay(chatOffset, "GIVE LIST");
            }
        
        //Presenter List logic
        }else{
        vector tPos = llDetectedTouchST(0);

        //translate the tPos vector to texture pixel position. texture is 512*512
        float height = 1024 - 1024 * tPos.y;
        float width  = 512 * tPos.x;
        
        //Find out which row was clickced, each row is 30 pixels heigh
        integer clickedRow = llFloor(height/30);
        
        //Find out wich column was clicked.
        integer clickedColumn;
        if(width < 250){
            clickedColumn = 1;
        }else if(width < 400){
            clickedColumn = 2;
        }else if(width < 512){
            clickedColumn = 3;
        }
        
        //See if the row is actually one with a presenter
        if(clickedRow <= rows){
            
            //clicked on the header row. 
            if(clickedRow == 0){
                
                //Clicked the ADD button create a new texture to list 2 people to add
                if((width > 140) && (width < 190)){
                    userAdd = TRUE;
                    llSetTimerEvent(30);
                    //Get all avatars in the sim
                    AddUsers = [llGetOwner(), "", llKey2Name(llGetOwner())];
                    AddUsers += osGetAvatarList();
                    rows = llGetListLength(AddUsers)/3;
                    if(rows>15)rows = 15; //we can only list 15 rows on the texture
                    
                    string CommandList = "";
                    
                    //Create yellow rectangle
                    CommandList = osSetPenColor( CommandList, "FFFFFFB1" );     
                    CommandList = osMovePen( CommandList, 0, 0 );               // Upper left corner at <28,78>
                    CommandList = osDrawFilledRectangle( CommandList, 512, 30);
                    
                    //Write question
                    CommandList = osSetFontSize( CommandList, 10 );
                    CommandList = osSetPenColor( CommandList, "Black" );     
                    CommandList = osMovePen( CommandList, 5, 5 );               
                    CommandList = osDrawText( CommandList, "Select the agent you want to Add.");       
                    
                    //Dynamically create agent rows
                    integer i = 0;
                    integer start = 30;
                    
                    for(i;i<rows;i++){
                        CommandList = osSetPenColor( CommandList, "FFF5F5F5" );                         

                        //On even rows, the background is darker gray
                        if(i%2){
                            CommandList = osSetPenColor( CommandList, "FFCCCCCC" );                         
                        }
            
                        CommandList = osMovePen( CommandList, 0, start);
                        CommandList = osDrawFilledRectangle( CommandList, 512, 30);
                        
                        CommandList = osSetPenColor( CommandList, "Black" );                         
                        CommandList = osMovePen( CommandList, 5, start + 5);
                        CommandList = osDrawText( CommandList, llList2String(AddUsers,(i*3) + 2));
                                                
                        start += 30;    
                    }
                    
                    CommandList = osSetPenColor( CommandList, "FFB5B5FF" );     
                    CommandList = osMovePen( CommandList, 450, 5 );               
                    CommandList = osDrawFilledRectangle( CommandList, 50, 20); 
                    CommandList = osMovePen( CommandList, 455, 5 );               
                    CommandList = osSetPenColor( CommandList, "Black" ); 
                    CommandList = osDrawText( CommandList,  "Back"); 
                    osSetDynamicTextureData( "", "vector", CommandList, "width:512,height:1024", 0 );
                           
                
                //clicked the Refresh button, refreshing the list
                }else if((width > 195) && (width < 245)){
                    llSay(chatOffset, "GIVE LIST");
                }
                    
            //Clicked on a Presenter or option
            }else{                                                
                
                //Change the active status
                if(clickedColumn == 2){
                    llOwnerSay("Changing active status for " + llList2String(Users,((clickedRow-1)*3) + 1));
                    
                    integer tActive = !llList2Integer(Users, ((clickedRow-1)*3)+2);

                    llSay(chatOffset, "CHANGE STATUS::" + llList2String(Users, (clickedRow-1)*3) + "," + 
                                                         llList2String(Users, ((clickedRow-1)*3) + 1) + "," + 
                                                         (string)tActive);

                //User clicked on remove, ask to confirm they want to remove the presenter
                }else if(clickedColumn == 3){
                    Question = TRUE;
                    removeRow = clickedRow-1;
                    llSetTimerEvent(15);
                    
                     string CommandList = ""; // Storage for our drawing commands
                    
                    //Create yellow rectangle
                    CommandList = osSetPenColor( CommandList, "FFFFFFB1" );     
                    CommandList = osMovePen( CommandList, 0, 0 );               // Upper left corner at <28,78>
                    CommandList = osDrawFilledRectangle( CommandList, 512, 30);
                    
                    //Write question
                    CommandList = osSetFontSize( CommandList, 10 );
                    CommandList = osSetPenColor( CommandList, "Black" );     
                    CommandList = osMovePen( CommandList, 5, 5 );               
                    CommandList = osDrawText( CommandList, "Are you sure you want to remove " + llList2String(Users,((clickedRow-1)*3) + 1) + " from the presentation board");       
                    
                    //Draw lines
                    CommandList = osSetPenSize( CommandList, 1 );  
                    CommandList = osSetPenColor( CommandList, "Black" ); 
                    CommandList = osDrawLine( CommandList, 0, 31, 512, 31 );        
                    CommandList = osDrawLine( CommandList, 256, 31, 256, 1024 );
                    
                    
                    //Write Yes
                    CommandList = osMovePen( CommandList, 100, 256 ); 
                    CommandList = osSetPenColor( CommandList, "Black" );             
                    CommandList = osSetFontSize( CommandList, 20 );
                    CommandList = osDrawText( CommandList,  "Yes");                              
                    
                    //Write No
                    CommandList = osMovePen( CommandList, 356, 256 ); 
                    CommandList = osSetPenColor( CommandList, "Black" );             
                    CommandList = osSetFontSize( CommandList, 20 );
                    CommandList = osDrawText( CommandList,  "NO");   
                    osSetDynamicTextureData( "", "vector", CommandList, "width:512,height:1024", 0 );
                                        
                }
            }
        }else{
            llOwnerSay("you clicked in empty space");
        }
        } 
    }
    
    on_rez(integer start_param){
        llResetScript();
    }
    
    timer(){
        llOwnerSay("You waited to long, reloading presenter list");
        Question = FALSE;
        userAdd = FALSE;
        llSetTimerEvent(0);
        llSay(chatOffset, "GIVE LIST");
    }
}
