// Call out to region to see where device is using a "where" command on an indicated channel
// Ai Austin 26-Nov-2007

integer BROADCAST_CHANNEL = 99;   // Object command channel - may be 0
integer RESPONSE_CHANNEL = 100;   // Object region wide response channel - cannot be 0

// add this command into a listener on BROADCAST_CHANNEL to act as an emergency location beacon in a single region
// if (message == "where" ) llRegionSay(EMERGENCY_CHANNEL,"Position="+llGetRegionName()+" "+(string)llGetPos());
        
default
{
    state_entry()
    {
        llSetText("Touch to locate Physical Test Vehicle\nTests only current region", <1,0,0>, 1.0);       
    }
        
touch_start(integer total_number)
    {
      integer i;
      for (i=0;i<total_number;i++)
         {
           key target = llDetectedKey(i);
           if ( (llGetOwner() != target ) && (llSameGroup(target) == 0))
               llSay (0,"Only owner or group members can locate the vehicle.");
           else
            {
                llSay(0, "Checking if Supercar is in current region.  It will respond if so.");
                llRegionSay(BROADCAST_CHANNEL, "where");
                        
                // Listen on indicated channel                 
                llListen(RESPONSE_CHANNEL, "", NULL_KEY, "");       
            }
         }
     }
     
    listen(integer channel, string name, key id, string message) 
    {
        llSay(0, "Supercar responded with "+message);
    }

}

 