// osTeleportAgent Script
//
// Set Destination as described below, There are a Few Options depending on Application:
// IN GRID Teleport 
// Destination = "1000,1000"; = Using In-Grid Map XXXX,YYYY coordinates
// Destination = "RegionName"; = Using RegionName
// HyperGrid Teleport (region must be HG Enabled)
// Destination = "TcpIpAddr:Port:RegionName"; = Using the Target/Destination IP Address
// Destination = "DNSname:Port:RegionName"; = Using the Target/Detination DNSname
// Note: RegionName is Optionally Specified to deliver Avatar to specific region in an instance.
// 
// ========================================================================================
// === SET DESTINATION INFO HERE ===
//
string Destination = "";  // Set to region name for non-local TP
vector LandingPoint = <34,222,23>; // X,Y,Z landing point for avatar to arrive at
vector LookAt = <1,1,0>; // which way they look at when arriving

string label = "";
vector label_color = <0.5,0.5,0.5>;
float  label_alpha = 1.0;

default
{
  on_rez(integer start_param)
  {
    llResetScript();
  }
  changed(integer change) // something changed, take action
  {
    if(change & CHANGED_OWNER)
      llResetScript();
    else if (change & 256) // that bit is set during a region restart
      llResetScript();
  }
  state_entry() {
    //label = llGetObjectName();
    //llSetText("Teleport to\n" + label, label_color, label_alpha);
    llSetText("", label_color, label_alpha);
  }
    
  touch_start(integer num_detected) 
  {
    key avatar = llDetectedKey(0);
    llInstantMessage(avatar, "Teleport");
    // osTeleportAgent(avatar, Destination, LandingPoint, LookAt); 
    osTeleportAgent(avatar, LandingPoint, LookAt); 
  }
} 