string HOLD_ANIM = "Sit Crossed";

default
{
    state_entry()
    {
        llAttachToAvatar(ATTACH_BELLY);
    }

    on_rez(integer rezzed)
    {
        llRequestPermissions(llGetOwner(), PERMISSION_TRIGGER_ANIMATION);
    }
    
    attach(key attached)
    {
        if (attached != llGetOwner())
        {
            if(llGetPermissions() & PERMISSION_TRIGGER_ANIMATION)
                llStopAnimation(HOLD_ANIM);
        }
        else
        {
            llStartAnimation(HOLD_ANIM);
            llSetTimerEvent(1);
        }
    }
    
    run_time_permissions(integer perms)
    {
        if(perms & PERMISSION_TRIGGER_ANIMATION)
        {
            llStartAnimation(HOLD_ANIM);
            llAttachToAvatar(ATTACH_BELLY);
        }
        else
        {
            llDetachFromAvatar();
            llStopAnimation(HOLD_ANIM);
        }
    }

    changed(integer change)
    {
        if (change & CHANGED_TELEPORT) //note that it's & and not &&... it's bitwise!
        {
            llStartAnimation(HOLD_ANIM);
        }
    }

    timer()
    {
        float waterLevel = llWater(llGetPos());
        vector currentPos = llGetPos();
        // llSay(0, (string) currentPos.z + " " + (string) waterLevel);
        if (currentPos.z > (waterLevel + 3))
        {
            llSetTimerEvent(0);
            llDetachFromAvatar();
            llStopAnimation(HOLD_ANIM);
        }
    }
}