//Assumes that the mantle is the root prim.

float TICK = 3.0; // seconds per cycle.

vector originalsize;
vector swollensize;

float SWELL = 1.5; // multiplier to swell up the mantle.
vector RISE_ON_SWELL = < 0.0, 0.0, 0.05 >;  // how much the jelly moves when swelled.

vector originalpos;

default
{
    state_entry()
    {
        originalsize = llGetScale();
        swollensize = < originalsize.x * SWELL, originalsize.y, originalsize.z >;

        llSetTimerEvent( TICK );
    }
    
    on_rez( integer p )
    {
        llResetScript();
    }

    timer()
    {
        //be swollen
        llSetPrimitiveParams([ PRIM_SIZE, swollensize, 
                               PRIM_POSITION, llGetPos() + RISE_ON_SWELL ]); 
        llSleep( 0.5 );
        //be originalsize
        llSetPrimitiveParams([ PRIM_SIZE, originalsize, 
                               PRIM_POSITION, llGetPos() - RISE_ON_SWELL ]); 
    }
}
