// https://github.com/Outworldz/LSL-Scripts/tree/master/Flashing%20Light
// :SHOW:
// :CATEGORY:Lights
// :NAME:Flashing Light
// :AUTHOR:Fred Beckhusen
// :KEYWORDS:
// :CREATED:2019-04-04 20:49:29
// :EDITED:2019-04-04  19:49:29
// :ID:1121
// :NUM:1971
// :REV:1.0
// :WORLD:Second Life, Opensim
// :DESCRIPTION:
// A rapidly blinking light made from a prim
// :CODE:

integer linknum = 18 ; // change to the number of a prim that you want to flash, root=1
integer onoff = 0;
integer enabled = FALSE;
float interval = 1.0;
float range = 1.0;
float intensity = 0.2;
vector color = <0.90,0.72,0.33>;

Off() {
    llSetLinkPrimitiveParamsFast(linknum,[PRIM_POINT_LIGHT, FALSE, color, intensity, range, .1, PRIM_FULLBRIGHT, ALL_SIDES, 0, PRIM_GLOW, ALL_SIDES, 0.2]);
    onoff = 0;
}

On() {
    llSetLinkPrimitiveParamsFast(linknum,[PRIM_POINT_LIGHT, TRUE, color, intensity, range, .1, PRIM_FULLBRIGHT, ALL_SIDES, 1, PRIM_GLOW, ALL_SIDES, 0.0]);
    onoff = 1;
}

default
{
    state_entry()
    {
        Off();
        enabled = 0;
    }
    
    touch_start(integer total_number)
    {
        enabled = !enabled;
        if (enabled) llSetTimerEvent(interval); // interval between events
        else llSetTimerEvent(0.0); // cancel timer
    }
    
    timer()
    {
        if (onoff) {
                Off();
                llSetTimerEvent(interval);
            }
        else {
                On();
                llSetTimerEvent(interval+0.5);
                // Off interval is always less than on
                // https://www.sailingissues.com/navcourse9.html
            }
    }

}
 