//  This script holds unchanging values for the "Swimming Critter" script.

list values = [ 1.0, 1.0, 1.0, 20, 0, 3, 30.0, 5.0, FALSE, TRUE ];

integer SIGNAL_NUMBER_OF_CONFIG_VALUES = -1;

integer SIGNAL_DISTANCE_X_FROM_START = 0;
integer SIGNAL_DISTANCE_Y_FROM_START = 1;
integer SIGNAL_DISTANCE_Z_FROM_START = 2;
integer SIGNAL_NUMBER_OF_STEPS_TOTAL = 3;
integer SIGNAL_NUMBER_OF_STEPS_START = 4;
integer SIGNAL_NUMBER_OF_STEPS_END   = 5;
integer SIGNAL_SLEEP_MAX_SECONDS     = 6;
integer SIGNAL_SLEEP_MIN_SECONDS     = 7;
integer SIGNAL_ALLOW_ABOVE_WATER     = 8;
integer SIGNAL_IGNORE_FACING         = 9;

default
{
    state_entry()
    {
    }
    
    link_message(integer sender_num, integer num, string str, key id)
    {
        if ( str != "" ) return; // Everything we care about has an empty string. 
        
        if ( num == SIGNAL_NUMBER_OF_CONFIG_VALUES)
        {
            if ( str == "" )
            {
                str = ( (string)(llGetListLength(values)) );
                llMessageLinked(LINK_THIS, num, str, NULL_KEY);
            }
            // else ignore.
        }   
        else if ( num > -1 && num < llGetListLength(values) )
            llMessageLinked(LINK_THIS, num, llList2String(values, num), NULL_KEY);
    }
}
