//This is a basic particle system script, it can be used to show how the particle system works
 
 
string  CONTROLLER_ID = "A"; // See comments at end regarding CONTROLLERS.
integer AUTO_START = TRUE;   // Optionally FALSE only if using CONTROLLERS.
 
list particle_parameters=[]; // stores your custom particle effect, defined below.
list target_parameters=[]; // remembers targets found using TARGET TEMPLATE scripts.
 
default {
    touch_start(integer start_params) {
        particle_parameters = [  // start of particle settings
           // Texture Parameters:
           PSYS_SRC_TEXTURE, llGetInventoryName(INVENTORY_TEXTURE, 0),
           PSYS_PART_START_SCALE, <0.2, .2, 0>,  PSYS_PART_END_SCALE, <4,4, 0>,
           PSYS_PART_START_COLOR, <.5,.5,.5>,    PSYS_PART_END_COLOR, <.1,.1,.1>,
           PSYS_PART_START_ALPHA, (float) 0.8,            PSYS_PART_END_ALPHA, (float)0.0,
 
           // Production Parameters:
           PSYS_SRC_BURST_PART_COUNT, (integer)1,
           PSYS_SRC_BURST_RATE, (float) 0.1,
           PSYS_PART_MAX_AGE, (float)3.0,
           PSYS_SRC_MAX_AGE, (float)0.0,
 
           // Placement Parameters:
           PSYS_SRC_PATTERN, (integer)8, // 1=DROP, 2=EXPLODE, 4=ANGLE, 8=ANGLE_CONE,
 
           // Placement Parameters (for any non-DROP pattern):
           PSYS_SRC_BURST_SPEED_MIN, (float)0.5,   PSYS_SRC_BURST_SPEED_MAX, (float)0.5,
        // PSYS_SRC_BURST_RADIUS, 0.0,
 
           // Placement Parameters (only for ANGLE & CONE patterns):
           PSYS_SRC_ANGLE_BEGIN,  (float)0.05*PI,       PSYS_SRC_ANGLE_END, (float)0.0*PI,
        // PSYS_SRC_OMEGA, <0,0,0>,
 
           // After-Effect & Influence Parameters:
           PSYS_SRC_ACCEL, <0.0,0.0,.2>,
        // PSYS_SRC_TARGET_KEY,      llGetLinkKey(llGetLinkNumber() + 1),
 
           PSYS_PART_FLAGS, (integer)( 0            // Texture Options:
                                | PSYS_PART_INTERP_COLOR_MASK
                                | PSYS_PART_INTERP_SCALE_MASK
                                | PSYS_PART_EMISSIVE_MASK
                                | PSYS_PART_FOLLOW_VELOCITY_MASK
                                                  // After-effect & Influence Options:
                                | PSYS_PART_WIND_MASK
                                | PSYS_PART_BOUNCE_MASK
                             // | PSYS_PART_FOLLOW_SRC_MASK
                             // | PSYS_PART_TARGET_POS_MASK
                             // | PSYS_PART_TARGET_LINEAR_MASK
                            )
            //end of particle settings
        ];
 
        if ( AUTO_START ) llParticleSystem( particle_parameters );
 
    }
 
    link_message( integer sibling, integer num, string mesg, key target_key ) {
        if ( mesg != CONTROLLER_ID ) { // this message isn't for me.  Bail out.
            return;
        } else if ( num == 0 ) { // Message says to turn particles OFF:
            llParticleSystem( [ ] );
        } else if ( num == 1 ) { // Message says to turn particles ON:
            llParticleSystem( particle_parameters + target_parameters );
        } else if ( num == 2 ) { // Turn on, and remember and use the key sent us as a target:
            target_parameters = [ PSYS_SRC_TARGET_KEY, target_key ];
            llParticleSystem( particle_parameters + target_parameters );
        } else { // bad instruction number
            // do nothing.
        }
    }
 
}
 