//  Purpose
//  --------------------------------------------------------------
//  This is a basic example of how you can animate an avatar when
//  the object this script is contained in is attached.
//
 
//  Requirements
//  --------------------------------------------------------------
//  A single prim is all that is necessary for this example.
 
//  Usage
//  --------------------------------------------------------------
//  This script is to be put into an object, and then works only
//  when the object is attached.  This particular example
//  will animate your avatar using a default animation "backflip"
//  built into SL.
 
 
//  EVENTS
//  --------------------------------------------------------------
 
default
{
    attach(key id)
    {
        //  This event is fired off any time that you attach OR
        //  detach the object that this script is running in.
 
        //  Since we are only concerned about being attached, we
        //  run a quick check to see if the object is attached.
        //  llGetAttached() will actually return the attachment
        //  point integer representation depending on where the
        //  object is attached to.  If it is not attached anywhere
        //  (detached), then it will return 0 (FALSE).
        if(llGetAttached())
        {
            //  In order to do certain things that take control of
            //  your avatar, such as Animations, the script must ask
            //  you for your permissions.  This is where this
            //  function comes into play.  Animation permissions are
            //  automatically considered OK if they are attached to
            //  an avatar.
            llRequestPermissions(llGetOwner(), PERMISSION_TRIGGER_ANIMATION);
        }
    }
 
    run_time_permissions(integer perm)
    {
        //  This event occurs when llRequestPermssions() returns true
        //  or false and passes the bit field of the type of request
        //  made.
 
        //  In this case, we passed PERMISSION_TRIGGER_ANIMATION as a
        //  request.  When working with PERMISSIONS, you have to
        //  remmeber to use Bitwise operators for conditional
        //  statements or comparisons.
        if(perm & PERMISSION_TRIGGER_ANIMATION)
        {
            //  Since the permissions were accepted, we can now make
            //  make the avatar perform animations.  In this example,
            //  we're using a default animation... but if you wanted
            //  to use a custom animation, all you would have to do
            //  is place the animation into the inventory of the object
            //  that this script is contained in, and change the
            //  "smoke_inhale" to the exact name of the custom animation.
            llStartAnimation("smoke_inhale");
        }
    }
}
 