//  GLOBALS
//  --------------------------------------------------------------
string      g_SitText   =  "Teleport";          //  This changes the text on the pie menue when rightclicked on the object
vector      g_SitOffset =  <0.0, 0.0, 10.0>;    //  This is the sit offset, also considered the teleport location from the object
 
//  EVENTS
//  --------------------------------------------------------------
default
{
    state_entry()
    {
        //  Set up the llSitTarget() and sit text first
        llSetSitText(g_SitText);
        llSitTarget(g_SitOffset, ZERO_ROTATION);
    }
 
    changed(integer change)
    {
        key id = llAvatarOnSitTarget();
        if(change & CHANGED_LINK)
        {
            //  We detect that the avatar sat on the object, so we
            //  unsit them right away thus giving the illusion of a
            //  teleport.
 
            //  Adjust the sleep time depending on the distance of
            //  the teleport.  The further the teleport, the higher
            //  the sleep value should be.  Note that the furtherst
            //  'teleport' distance is 300 meters.
            llSleep(1);
            llUnSit(id);
        }
    }
}