//Instructions
//This object will show text and change the object's color depending on whether the
//owner is online or not.
 
//NOTE: Due to a bug in SL sometimes you may have to slightly move the object for the
//text to start showing above it for the first time.
 
//changeText - set to TRUE if you want to change the text above the object to show the
//owner's online status. Set it to FALSE otherwise.
integer changeText = TRUE;
 
//This is any text you want to display if the owner is online (the owner's name will be
//added in front of this.
string showTextOnline = " is online!";
 
//This is any text you want to display if the owner is offline (the owner's name will be
//added in front of this.
string showTextOffline = " is offline!";
 
//This is the color of the text displayed above the object
vector textColor = <1,1,1>;
 
//This is the transparency of the text displayed above the object. 1 = solid, 0.2 = most
//transparent
float textAlpha = 1;
 
//changeColor - set to TRUE if you want to change the object's color to show the
//owner's online status. Set to FALSE otherwise.
integer changeColor = TRUE;
 
//This is the color to set the object if the owner is online
vector colorOnline = <0,1,0>;
 
//This is the color to set the object if the owner is offline
vector colorOffline = <1,0,0>;
 
//owner will be used to store the owner's key
key owner;
 
//ownerName will be used to store the owner's name
string ownerName;
 
//request will be used to store the dataserver request key;
key request;
 
 
//init() - runs on state_entry and on_rez
init()
{
    //If changeText == FALSE then we don't want to show any text
    if (changeText == FALSE) {
        //Clears any text showing to make sure none is showing.
        llSetText("",<0,0,0>,1);
    }
    //To start with set the timer event to trigger in 1 second to update the
    //item straight away
    llSetTimerEvent(1);
    llSleep(1); // sleep to make sure that the timer event triggers
    //This resets the timer so that it runs timer event every 10 seconds now.
    llSetTimerEvent(10);
    //Get the key of the owner
    owner = llGetOwner();
    //Get the owner's name
    ownerName = llKey2Name(owner);
}
 
default
{
    //state_entry - launches whenever the script is reset (or on change of
    //state but this script doesn't use other states!)
    state_entry()
    {
        init();
    }
 
    //on_rez - launches whenever the object is rezzed
    on_rez(integer times)
    {
        init();
    }
 
    //timer - this event runs every number of seconds specified in an llSetTimerEvent command
    timer()
    {
        //send a request to the SL dataservers. DATA_ONLINE means we're requesting
        //information about whether the owner is online or not
        request =  llRequestAgentData(owner, DATA_ONLINE);
    }
 
    //dataserver - this event runs every time the script recieves some information
    //from the data servers in SL.
    //In this script we will recieve data here when we use llRequestAgentData
    dataserver(key requested, string data)
    {
        //Checks that this dataserver event matches the last one we requested by checking
        //the keys
        if (requested == request) {
            //If the user is online data will have the value of 1
            if (data == "1") {
                //Checks to see if changeText is equal to TRUE, if it is we need to set
                //the text over the object
                if (changeText == TRUE) {
                    //Sets the text over the object to show that the owner is online
                    llSetText(ownerName + showTextOnline,textColor,textAlpha);
                }
                //Checks to see if changeColor is equal to TRUE, if it is we need to set
                //the object's color
                if (changeColor == TRUE) {
                    //Sets the object's color to the online color
                   llSetColor(colorOnline,ALL_SIDES);
                }
            } else {    //data doesn't have the value of 1 so the owner must be offline
                //Checks to see if changeText is equal to TRUE, if it is we need to set
                //the text over the object
                if (changeText == TRUE) {
                    //Sets the text over the object to show that the owner is offline
                    llSetText(ownerName + showTextOffline,textColor,textAlpha);
                }
                //Checks to see if changeColor is equal to TRUE, if it is we need to set
                //the object's color
                if (changeColor == TRUE) {
                    //Sets the object's color to the offline color
                   llSetColor(colorOffline,ALL_SIDES);
                }
            }
        }
    }
}