
/* Script: QuickLinks - Name = Floating Txt, Description = URL
/* Version:  1.0
/* Created by:  Nebadon Izumi
/* License:   CC0 - Creative Commons Public Domain 
/* Modified by Fleep Tuque to display floating text based on the object name, and to launch a URL link based on object description.*/

string objname;
string objdesc;
string textcolor = "<1,1,1>";

 
default {
    state_entry() {
        objname = llGetObjectName();
        llSetText("  ", textcolor, 1);
        
    }
    
    touch_end(integer num_detected) {
        llResetScript();
        
    }
    
    touch_start(integer total_number) {
        objdesc = llGetObjectDesc();
        llLoadURL(llDetectedKey(0), objname, objdesc);
        
    }
    
    
    changed(integer change) {
        if(change & CHANGED_OWNER) {
            llResetScript();
        }
    }
}