//This script will take the first Landmark in the scripted objects inventory and give a copy to anyone who
 //touches it otherwise it will give a landmark to its current position.
 
key request;
string name;
string sim_name;
vector pos;
 
default
{
    state_entry()
    {
        llAllowInventoryDrop(1);
        if(llGetInventoryNumber(INVENTORY_LANDMARK))
        {
            name = llGetInventoryName(INVENTORY_LANDMARK,0);
            request = llRequestInventoryData(name);
        }
        else
            llWhisper(0,"Please drop a landmark on me");
    }
    dataserver(key id, string data)
    {
        if(id == request)
        {
            pos = (vector)data;
            sim_name = llGetRegionName();
            llSetText(" ",<1.0,1.0,1.0>,1.0);
        }
    }
    touch_start(integer a)
    {
        if(name != "")
            llMapDestination(sim_name, pos, pos);
            llGiveInventory(llDetectedKey(0),llGetInventoryName(INVENTORY_LANDMARK, 0));
            llWhisper(0, "A landmark to this destination has been placed in your inventory.");
 
    }
    changed(integer a)
    {
        if(a & (CHANGED_INVENTORY | CHANGED_ALLOWED_DROP))
            if(llGetInventoryNumber(INVENTORY_LANDMARK))
                name = llGetInventoryName(INVENTORY_LANDMARK,0);
                request = llRequestInventoryData(name);
    }
}
  