// Script Name: A_Friendly_Unpacker.lsl
//Send the new owner a friendly message that tells where to look for each unpacked item

// Downloaded from : http://www.free-lsl-scripts.com/cgi/freescripts.plx?ID=1595

// This program is free software; you can redistribute it and/or modify it.
// Additional Licenes may apply that prevent you from selling this code
// and these licenses may require you to publish any changes you make on request.
//
// There are literally thousands of hours of work in these scripts. Please respect
// the creators wishes and follow their license requirements.
//
// Any License information included herein must be included in any script you give out or use.
// Licenses are included in the script or comments by the original author, in which case
// the authors license must be followed.

// A GNU license, if attached by the author, means the original code must be FREE.
// Modifications can be made and products sold with the scripts in them.
// You cannot attach a license to make this GNU License 
// more or less restrictive.  see http://www.gnu.org/copyleft/gpl.html

// Creative Commons licenses apply to all scripts from the Second Life
// wiki and script library and are Copyrighted by Linden Lab. See
// http://creativecommons.org/licenses/

// Please leave any author credits and headers intact in any script you use or publish.
// If you don't like these restrictions, then don't use these scripts.
//////////////////////// ORIGINAL AUTHORS CODE BEGINS ////////////////////////////////////////////
list gItems;
list gNocopy;
list gList_types = [INVENTORY_NONE,INVENTORY_TEXTURE, INVENTORY_SOUND, INVENTORY_LANDMARK,INVENTORY_CLOTHING, INVENTORY_OBJECT, INVENTORY_NOTECARD, INVENTORY_SCRIPT,INVENTORY_BODYPART, INVENTORY_ANIMATION, INVENTORY_GESTURE];
list gList_names = ["None", "Texture", "Sound", "Landmark", "Clothing", "Object", "Notecard", "Script", "Body Part", "Animation", "Gesture"];



default
{
    state_entry()
    {
        llSetText("Alexander City Fiat 500 \nClick to copy to your inventory",<1,1,0>,1);
        integer All = llGetInventoryNumber(INVENTORY_ALL);
        while (All)
        {
            string name = llGetInventoryName(INVENTORY_ALL, All - 1);
            if (name != llGetScriptName())
            {
                if(llGetInventoryPermMask(name, MASK_OWNER) & PERM_COPY)
                {
                    gItems += [name]; //Copy perm items
                }
                else
                {
                    gNocopy += [name];  //No-copy perm items
                }
            }
            --All;
        }
    }
    
    changed (integer change)
    {
        if ((change & CHANGED_INVENTORY) || (change & CHANGED_OWNER))
        {
            llResetScript();
        }
    }

    touch_start(integer num)
    
  
    {
        llInstantMessage(llDetectedKey(0),"Look for unpacked items in a folder named " + llGetObjectName() + " in your inventory.");
        llGiveInventoryList(llDetectedKey(0), llGetObjectName(), gItems);
        integer len = llGetListLength(gNocopy);
         llSetTimerEvent (5.0);
        if (len) 
        {
        llInstantMessage(llDetectedKey(0),"Also, look for the following one-of-a-kind items:");
            while (len) 
            {
                // Determine what kind of inventory this is, and find that type in the gList_types list
                integer idx = llListFindList(gList_types,[llGetInventoryType(llList2String(gNocopy,len-1))]);
                // Then use idx to find the name of that type in the gList_names list and say it
                if (~idx)
                {
                    llInstantMessage(llDetectedKey(0),llList2String(gNocopy,len-1) + " will be in your " + llList2String(gList_names,idx) + " folder.");
                    llGiveInventory(llDetectedKey(0),llList2String(gNocopy,len-1));
                    
                }
        --len;
        
            }
            
        }
  
}
 timer ()
    {
        llSetTimerEvent (0.0);
        llDie();
    }

}


