//rocking chair

integer counter = 5;
float angle = 0.07;
vector BasePos;

default
{
    touch_start(integer total_number)
    {
       state running;
    }

    moving_start()
    {
        llSetTimerEvent(0);
    }
    
    moving_end()
    {
        llResetScript();
    }
}

state running
{
    state_entry()
    {
        BasePos = llGetPos();
        llSetTimerEvent(0.1);
    }

    touch_start(integer total_number)
    {
       llSetTimerEvent(0);
       state default;
    }
    
    timer()
    {
        --counter;
        if(counter == 0)
        {
            counter = 5;
            angle = - angle;
        }
        
        vector pos = BasePos + <0,(counter-3)/10.0,0>;
        rotation rot = llGetRot();
        rotation delta = llEuler2Rot(<0,0,angle>);
        rot = delta * rot;
        llSetRot(rot);
    }
    
    
    moving_start()
    {
        llSetTimerEvent(0);
    }
    
    moving_end()
    {
        llResetScript();
    }
}

