// Script Name: Glow_when_walked_On.lsl
// Author: Ferd Frederix
//I got tired of paying for ridiculously overpriced Avatar-like plants that glow when you walk on them.     Same thing goes for sidewalks that light up.  So here is a simple script that changes the glow of a prim when you walk on it.

// Downloaded from : http://www.free-lsl-scripts.com/cgi/freescripts.plx?ID=1469

// This program is free software; you can redistribute it and/or modify it.
// Additional Licenes may apply that prevent you from selling this code
// and these licenses may require you to publish any changes you make on request.
//
// There are literally thousands of hours of work in these scripts. Please respect
// the creators wishes and Copyright law and follow their license requirements.
//
// License information included herein must be included in any script you give out or use.
// Licenses may also be included in the script or comments by the original author, in which case
// the authors license must be followed, and  their licenses override any licenses outlined in this header.
//
// You cannot attach a license to any of these scripts to make any license more or less restrictive.
//
// All scripts by avatar Ferd Frederix, unless stated otherwise in the script, are licensed as Creative Commons By Attribution and Non-Commercial.
// Commercial use is NOT allowed - no resale of my scripts in any form.  
// This means you cannot sell my scripts but you can give them away if they are FREE.  
// Scripts by Ferd Frederix may be sold when included in a new object that actually uses these scripts. Putting my script in a prim and selling it on marketplace does not constitute a build.
// For any reuse or distribution, you must make clear to others the license terms of my works. This is done by leaving headers intact.
// See http://creativecommons.org/licenses/by-nc/3.0/ for more details and the actual license agreement.
// You must leave any author credits and any headers intact in any script you use or publish.
///////////////////////////////////////////////////////////////////////////////////////////////////
// If you don't like these restrictions and licenses, then don't use these scripts.
//////////////////////// ORIGINAL AUTHORS CODE BEGINS ////////////////////////////////////////////

integer is_on = FALSE;
float glow = .1;
default
{
    collision_start(integer num_detected) 
    {
        if(!is_on)
        {
            float i;
            for(i = 0.0; i < glow; i += 0.005 )
            {
                llSetPrimitiveParams([PRIM_GLOW, ALL_SIDES, i]);
                //llSleep(1.0);
            }
            is_on = TRUE;
        }
    }

    collision_end(integer num_detected) 
    {
        if(is_on)
        {
            float i;
            for(i = glow; i > 0.0; i -= 0.005 )
            {
                llSetPrimitiveParams([PRIM_GLOW, ALL_SIDES, i]);
                //llSleep(1.0);
            }
            is_on = FALSE;
        }
    }
}


