//////////////////////////////////////////// 
// XyText v1.0.3 Script (5 Face, Multi Texture) 
// 
// Written by Xylor Baysklef 
// 
// Modified by Thraxis Epsilon January 20, 2006 
// Added Support for 5 Face Prim, based on modification 
// of XyText v1.1.1 by Kermitt Quick for Single Texture. 
// 
//////////////////////////////////////////// 

/////////////// CONSTANTS /////////////////// 
// XyText Message Map. 
integer DISPLAY_STRING = 204000; 
integer DISPLAY_EXTENDED = 204001; 
integer REMAP_INDICES = 204002; 
integer RESET_INDICES = 204003; 
integer SET_CELL_INFO = 204004;
integer SET_THICKNESS = 204006; 
integer SET_COLOR = 204007; 

// This is an extended character escape sequence. 
string ESCAPE_SEQUENCE = "\\e"; 

// This is used to get an index for the extended character. 
string EXTENDED_INDEX = "123456789abcdef"; 

// Face numbers. 
integer FACE_1 = 0; 
integer FACE_2 = 1; 
integer FACE_3 = 2; 
integer FACE_4 = 3; 
integer FACE_5 = 4;
integer FACE_6 = 5;
integer FACE_7 = 6;
integer FACE_8 = 7; 

// Used to hide the text after a fade-out. 
key TRANSPARENT = "701917a8-d614-471f-13dd-5f4644e36e3c"; 
// This is a list of textures for all 2-character combinations. 
list CHARACTER_GRID = [ 
"0996f596-cd7f-4cdc-872d-791f3dcb7376", 
"30b28219-9f59-4953-8e53-c03375e37ac7", 
"7303a524-33f6-471c-9ec8-aa260671cff3", 
"8c2cb383-82e3-4e82-aad7-e463a9b5545f", 
"5f955e30-b639-4cbb-b742-e47e76e77bdf", 
"81b1e902-0e7e-4189-b511-fecd525a1a4a", 
"6847ef9e-4609-4a51-964d-90879a44a97c", 
"4241744e-ef73-4ae3-b89a-12303e957786", 
"2667c661-722e-40f4-9f7a-8532331e6d10", 
"16acae49-c1f6-455c-b101-299bbefbd995", 
"f27812ee-bd9a-4c79-b561-e6a3cec74b3d", 
"245c0898-c1e6-45d8-8342-a82fed92cec0", 
"22b95071-caf1-4720-a71f-757a62f60d5b", 
"2316031e-81cd-4540-8387-9e8560d9ed2c", 
"4097d246-82a8-4f22-963b-647ec0a0bafe", 
"fb11f52d-848b-4d10-9192-c7ddcb8de3de", 
"a2317bb0-969c-4622-a84d-5315f3a33531", 
"7ef35671-3d81-47ed-8c4e-7a6b4752ffc1", 
"2a35215b-25b3-42fb-8a44-160b30ee3950", 
"eb4e57ed-507e-4860-a36d-c08aa1bafa70", 
"d89e5a4d-ed5d-4bf5-8c00-e0f292c712db", 
"c442e33f-5d4a-4021-a4d9-124f5bc97006", 
"5fda39d1-ec45-4c3f-8d3b-4a46e838bc42", 
"4ddb3bba-5192-43b6-bb38-65371a80907d", 
"5b3817f8-951a-4e90-875b-6f4c35308484", 
"3fab8cb1-5c49-407b-99d1-297ce384866d", 
"bcc33232-8f7f-4a74-9602-af798f4632d7", 
"d7311a6a-352d-4ce6-a254-e0210198823e", 
"696de803-b76a-402e-b8da-ee16a703fb71", 
"86bf94de-fed0-4e7a-a424-5788d33bf9e2", 
"6e27c464-0dac-4410-82f7-111e1a508ea6", 
"6a5fb69a-eb9d-4f19-aa88-e9b9fb3d1046", 
"ab6dd12a-bcac-49a0-9d80-5a2f0e33355f", 
"c92cbf08-47a1-47e0-b4b3-16277dca02ba", 
"079e88a0-35d7-45fa-b21e-e6ba24992672", 
"9c9e7561-c996-4851-89d4-6d4d268882c3", 
"89db5ffb-a152-4b1f-886f-853b12ab28fe", 
"3722013c-1c27-45ed-b4d0-35fe4e23856a", 
"bef324c2-51cd-47da-bb2f-05a076f325fe", 
"bdc9b6c2-1025-4881-b5dc-ad25927f20bd", 
"7c91a239-26a0-4ece-aefc-241b90191ac2", 
"f4e7697e-943a-4508-95a1-c139a2a486ac", 
"cc627d9f-5508-499b-8600-facc875de3a5", 
"2a14a996-81a7-4559-a5a2-4fb863c13661", 
"a849a94d-0350-43b7-9322-e1b9afc561cf", 
"3e3e8689-8fe9-46e1-8f35-f9101c7a2ddf", 
"6b70dc67-efb7-426f-964b-bbae4058f491", 
"d86627b9-35db-42b9-967d-9c988cc82e5a", 
"105d3ed6-20cf-447e-ba35-890064976836", 
"63132779-7145-4017-8308-f72181441e21", 
"bfbad8f3-3582-4bf8-a6f1-992341e2a925", 
"00e80aed-c336-406f-9885-5a63e4354453", 
"36ec0a1a-0588-486d-9bec-1d720a5617c8", 
"250abb76-b933-405b-ac2d-654be3d07fc1", 
"927ffc8e-4b46-4487-973b-e461e19bca87", 
"534e530f-c7ac-4cfc-af59-0cbd1cb79195", 
"f20c0969-93b6-4c4e-99c9-93b9b7974781", 
"84f90c2d-f770-4546-8c0f-e65ac8a1b030", 
"489180fa-6724-4ab2-bc79-16c4919efb78", 
"99c528b8-a66c-44d2-a91f-5a946b1d62dd", 
"49714d7e-f1b7-4962-9b3d-b17009e9011a", 
"323a6d72-85c0-4159-afb7-2c2a304f87e3", 
"4f2493ae-8ab0-431e-88bd-7f5ef7d36a3b", 
"6f1fce88-a096-42bd-b202-6c84249a7d14", 
"1f993f0f-81a1-4eb7-989d-391a5e0d3c49", 
"5ff53aa0-80e1-471a-aacb-ba840b868ba6" 
]; 

///////////// END CONSTANTS //////////////// 


///////////// Set Channel for line//////////////////
integer SET_LINE_CHANNEL = 100105;

//Set the start character - used for long line of chars//
//fisrt 10 chars start at 0, 2nd line starts at 10//
//3rd line starts at 20 and so on...//
integer START_CHAR = 0;

///////////// GLOBAL VARIABLES /////////////// 
// All displayable characters. Default to ASCII order. 
string gCharIndex; 
// This is the channel to listen on while acting 
// as a cell in a larger display. 
integer gCellChannel = -1; 
// This is the starting character position in the cell channel message 
// to render. 
integer gCellCharPosition = 0;
// This is whether or not to use the fade in/out special effect. 
integer gCellUseFading = FALSE; 
// This is how long to display the text before fading out (if using 
// fading special effect). 
// Note: < 0 means don't fade out. 
float gCellHoldDelay = 1.0; 
/////////// END GLOBAL VARIABLES //////////// 

ResetCharIndex() { 
gCharIndex = " !\"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\\]^_`"; 
// \" <-- Fixes LSL syntax highlighting bug. 
gCharIndex += "abcdefghijklmnopqrstuvwxyz{|}~"; 
gCharIndex += "\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n"; 
} 

vector GetGridPos(integer index1, integer index2) { 
// There are two ways to use the lookup table... 
integer Col; 
integer Row; 
if (index1 >= index2) { 
// In this case, the row is the index of the first character: 
Row = index1; 
// And the col is the index of the second character (x2) 
Col = index2 * 2; 
} 
else { // Index1 < Index2 
// In this case, the row is the index of the second character: 
Row = index2; 
// And the col is the index of the first character, x2, offset by 1. 
Col = index1 * 2 + 1; 
} 
return <Col, Row, 0>; 
} 

string GetGridTexture(vector grid_pos) { 
// Calculate the texture in the grid to use. 
integer GridCol = llRound(grid_pos.x) / 20; 
integer GridRow = llRound(grid_pos.y) / 10; 

// Lookup the texture. 
key Texture = llList2Key(CHARACTER_GRID, GridRow * (GridRow + 1) / 2 + GridCol); 
return Texture; 
} 

vector GetGridOffset(vector grid_pos) { 
// Zoom in on the texture showing our character pair. 
integer Col = llRound(grid_pos.x) % 20; 
integer Row = llRound(grid_pos.y) % 10; 

// Return the offset in the texture. 
return <-0.45 + 0.05 * Col, 0.45 - 0.1 * Row, 0.0>; 
} 

ShowChars(vector grid_pos1, vector grid_pos2, vector grid_pos3, vector grid_pos4, vector grid_pos5, vector grid_pos6, vector grid_pos7, vector grid_pos8) { 
// Set the primitive textures directly. 


llSetPrimitiveParams( [ 
PRIM_TEXTURE, FACE_1, GetGridTexture(grid_pos1), <0.1, 0.1, 0>, GetGridOffset(grid_pos1), 0.0, 
PRIM_TEXTURE, FACE_2, GetGridTexture(grid_pos2), <0.1, 0.1, 0>, GetGridOffset(grid_pos2), 0.0, 
PRIM_TEXTURE, FACE_3, GetGridTexture(grid_pos3), <0.1, 0.1, 0>, GetGridOffset(grid_pos3), 0.0, 
PRIM_TEXTURE, FACE_4, GetGridTexture(grid_pos4), <0.1, 0.1, 0>, GetGridOffset(grid_pos4), 0.0, 
PRIM_TEXTURE, FACE_5, GetGridTexture(grid_pos5), <0.1, 0.1, 0>, GetGridOffset(grid_pos5), 0.0,
PRIM_TEXTURE, FACE_6, GetGridTexture(grid_pos6), <0.1, 0.1, 0>, GetGridOffset(grid_pos6), 0.0,
PRIM_TEXTURE, FACE_7, GetGridTexture(grid_pos7), <0.1, 0.1, 0>, GetGridOffset(grid_pos7), 0.0,
PRIM_TEXTURE, FACE_8, GetGridTexture(grid_pos8), <0.1, 0.1, 0>, GetGridOffset(grid_pos8), 0.0 
]); 
}

RenderString(string str) { 
// Get the grid positions for each pair of characters. 
vector GridPos1 = GetGridPos( llSubStringIndex(gCharIndex, llGetSubString(str, 0, 0)), 
llSubStringIndex(gCharIndex, llGetSubString(str, 1, 1)) ); 
vector GridPos2 = GetGridPos( llSubStringIndex(gCharIndex, llGetSubString(str, 2, 2)), 
llSubStringIndex(gCharIndex, llGetSubString(str, 3, 3)) ); 
vector GridPos3 = GetGridPos( llSubStringIndex(gCharIndex, llGetSubString(str, 4, 4)), 
llSubStringIndex(gCharIndex, llGetSubString(str, 5, 5)) ); 
vector GridPos4 = GetGridPos( llSubStringIndex(gCharIndex, llGetSubString(str, 6, 6)), 
llSubStringIndex(gCharIndex, llGetSubString(str, 7, 7)) ); 
vector GridPos5 = GetGridPos( llSubStringIndex(gCharIndex, llGetSubString(str, 8, 8)), 
llSubStringIndex(gCharIndex, llGetSubString(str, 9, 9)) ); 
vector GridPos6 = GetGridPos( llSubStringIndex(gCharIndex, llGetSubString(str, 10, 10)), 
llSubStringIndex(gCharIndex, llGetSubString(str, 11, 11)) ); 
vector GridPos7 = GetGridPos( llSubStringIndex(gCharIndex, llGetSubString(str, 12, 12)), 
llSubStringIndex(gCharIndex, llGetSubString(str, 13, 13)) ); 
vector GridPos8 = GetGridPos( llSubStringIndex(gCharIndex, llGetSubString(str, 14, 14)), 
llSubStringIndex(gCharIndex, llGetSubString(str, 15, 15)) ); 

// Use these grid positions to display the correct textures/offsets. 
ShowChars(GridPos1, GridPos2, GridPos3, GridPos4, GridPos5, GridPos6, GridPos7, GridPos8); 
}

RenderWithEffects(string str) { 
// Get the grid positions for each pair of characters. 
vector GridPos1 = GetGridPos( llSubStringIndex(gCharIndex, llGetSubString(str, 0, 0)), 
llSubStringIndex(gCharIndex, llGetSubString(str, 1, 1)) ); 
vector GridPos2 = GetGridPos( llSubStringIndex(gCharIndex, llGetSubString(str, 2, 2)), 
llSubStringIndex(gCharIndex, llGetSubString(str, 3, 3)) ); 
vector GridPos3 = GetGridPos( llSubStringIndex(gCharIndex, llGetSubString(str, 4, 4)), 
llSubStringIndex(gCharIndex, llGetSubString(str, 5, 5)) ); 
vector GridPos4 = GetGridPos( llSubStringIndex(gCharIndex, llGetSubString(str, 6, 6)), 
llSubStringIndex(gCharIndex, llGetSubString(str, 7, 7)) ); 
vector GridPos5 = GetGridPos( llSubStringIndex(gCharIndex, llGetSubString(str, 8, 8)), 
llSubStringIndex(gCharIndex, llGetSubString(str, 9, 9)) ); 
vector GridPos6 = GetGridPos( llSubStringIndex(gCharIndex, llGetSubString(str, 10, 10)), 
llSubStringIndex(gCharIndex, llGetSubString(str, 11, 11)) ); 
vector GridPos7 = GetGridPos( llSubStringIndex(gCharIndex, llGetSubString(str, 12, 12)), 
llSubStringIndex(gCharIndex, llGetSubString(str, 13, 13)) ); 
vector GridPos8 = GetGridPos( llSubStringIndex(gCharIndex, llGetSubString(str, 14, 14)), 
llSubStringIndex(gCharIndex, llGetSubString(str, 15, 15)) ); 

// First set the alpha to the lowest possible. 
llSetAlpha(0.05, ALL_SIDES); 

// Use these grid positions to display the correct textures/offsets. 
ShowChars(GridPos1, GridPos2, GridPos3, GridPos4, GridPos5, GridPos6, GridPos7, GridPos8);

float Alpha; 
for (Alpha = 0.10; Alpha <= 1.0; Alpha += 0.05) 
llSetAlpha(Alpha, ALL_SIDES); 
// See if we want to fade out as well. 
if (gCellHoldDelay < 0.0) 
// No, bail out. (Just keep showing the string at full strength). 
return; 
// Hold the text for a while. 
llSleep(gCellHoldDelay); 
// Now fade out. 
for (Alpha = 0.95; Alpha >= 0.05; Alpha -= 0.05) 
llSetAlpha(Alpha, ALL_SIDES); 
// Make the text transparent to fully hide it. 
llSetTexture(TRANSPARENT, ALL_SIDES); 
} 

RenderExtended(string str) { 
// Look for escape sequences. 
list Parsed = llParseString2List(str, [], [ESCAPE_SEQUENCE]); 
integer ParsedLen = llGetListLength(Parsed); 

// Create a list of index values to work with. 
list Indices; 
// We start with room for 6 indices. 
integer IndicesLeft = 16; 

integer i; 
string Token; 
integer Clipped; 
integer LastWasEscapeSequence = FALSE; 
// Work from left to right. 
for (i = 0; i < ParsedLen && IndicesLeft > 0; i++) { 
Token = llList2String(Parsed, i); 

// If this is an escape sequence, just set the flag and move on. 
if (Token == ESCAPE_SEQUENCE) { 
LastWasEscapeSequence = TRUE; 
} 
else { // Token != ESCAPE_SEQUENCE 
// Otherwise this is a normal token. Check its length. 
Clipped = FALSE; 
integer TokenLength = llStringLength(Token); 
// Clip if necessary. 
if (TokenLength > IndicesLeft) { 
Token = llGetSubString(Token, 0, IndicesLeft - 1); 
TokenLength = llStringLength(Token); 
IndicesLeft = 0; 
Clipped = TRUE; 
} 
else 
IndicesLeft -= TokenLength; 

// Was the previous token an escape sequence? 
if (LastWasEscapeSequence) { 
// Yes, the first character is an escape character, the rest are normal. 

// This is the extended character. 
Indices += [llSubStringIndex(EXTENDED_INDEX, llGetSubString(Token, 0, 0)) + 95]; 

// These are the normal characters. 
integer j; 
for (j = 1; j < TokenLength; j++) 
Indices += [llSubStringIndex(gCharIndex, llGetSubString(Token, j, j))]; 
} 
else { // Normal string. 
// Just add the characters normally. 
integer j; 
for (j = 0; j < TokenLength; j++) 
Indices += [llSubStringIndex(gCharIndex, llGetSubString(Token, j, j))]; 
} 

// Unset this flag, since this was not an escape sequence. 
LastWasEscapeSequence = FALSE; 
} 
} 

// Use the indices to create grid positions. 
vector GridPos1 = GetGridPos( llList2Integer(Indices, 0), llList2Integer(Indices, 1) ); 
vector GridPos2 = GetGridPos( llList2Integer(Indices, 2), llList2Integer(Indices, 3) ); 
vector GridPos3 = GetGridPos( llList2Integer(Indices, 4), llList2Integer(Indices, 5) ); 
vector GridPos4 = GetGridPos( llList2Integer(Indices, 6), llList2Integer(Indices, 7) ); 
vector GridPos5 = GetGridPos( llList2Integer(Indices, 8), llList2Integer(Indices, 9) ); 
vector GridPos6 = GetGridPos( llList2Integer(Indices, 10), llList2Integer(Indices, 11) ); 
vector GridPos7 = GetGridPos( llList2Integer(Indices, 12), llList2Integer(Indices, 13) ); 
vector GridPos8 = GetGridPos( llList2Integer(Indices, 14), llList2Integer(Indices, 15) ); 

// Use these grid positions to display the correct textures/offsets. 
ShowChars(GridPos1, GridPos2, GridPos3, GridPos4, GridPos5, GridPos6, GridPos7, GridPos8); 
} 

integer ConvertIndex(integer index) { 
// This converts from an ASCII based index to our indexing scheme. 
if (index >= 32) // ' ' or higher 
index -= 32; 
else { // index < 32 
// Quick bounds check. 
if (index > 15) 
index = 15; 

index += 94; // extended characters 
} 

return index; 
} 

default { 
state_entry() { 
// Initialize the character index. 
ResetCharIndex(); 

 integer ThisLink = llGetLinkNumber();

llMessageLinked(ThisLink , SET_CELL_INFO, llList2CSV([SET_LINE_CHANNEL, START_CHAR]), "");
//llSay(0, "Free Memory: " + (string) llGetFreeMemory()); 
} 

link_message(integer sender, integer channel, string data, key id) {
if (channel == DISPLAY_STRING) { 
RenderString(data); 
return; 
} 
if (channel == DISPLAY_EXTENDED) {
RenderExtended(data); 
return; 
} 
if (channel == gCellChannel) { 
// Extract the characters we are interested in, and use those to render. 
string TextToRender = llGetSubString(data, gCellCharPosition, gCellCharPosition + 15);
if (gCellUseFading)
RenderWithEffects( TextToRender );
else // !gCellUseFading
RenderString( TextToRender );
return;
} 
if (channel == REMAP_INDICES) { 
// Parse the message, splitting it up into index values. 
list Parsed = llCSV2List(data); 
integer i; 
// Go through the list and swap each pair of indices. 
for (i = 0; i < llGetListLength(Parsed); i += 2) { 
integer Index1 = ConvertIndex( llList2Integer(Parsed, i) ); 
integer Index2 = ConvertIndex( llList2Integer(Parsed, i + 1) ); 

// Swap these index values. 
string Value1 = llGetSubString(gCharIndex, Index1, Index1); 
string Value2 = llGetSubString(gCharIndex, Index2, Index2); 

gCharIndex = llDeleteSubString(gCharIndex, Index1, Index1); 
gCharIndex = llInsertString(gCharIndex, Index1, Value2); 

gCharIndex = llDeleteSubString(gCharIndex, Index2, Index2); 
gCharIndex = llInsertString(gCharIndex, Index2, Value1); 
} 
return; 
} 
if (channel == RESET_INDICES) { 
// Restore the character index back to default settings. 
ResetCharIndex(); 
return; 
} 
if (channel == SET_CELL_INFO) { 
// Change the channel we listen to for cell commands, and the 
// starting character position to extract from. 
list Parsed = llCSV2List(data); 
gCellChannel = (integer) llList2String(Parsed, 0);
gCellCharPosition = (integer) llList2String(Parsed, 1);
gCellUseFading = (integer) llList2String(Parsed, 2); 
gCellHoldDelay = (float) llList2String(Parsed, 3); 
return; 
}
if (channel == SET_THICKNESS) { 
// Set our z scale to thickness, while staying fixed 
// in position relative the prim below us. 
vector Scale = llGetScale(); 
float Thickness = (float) data; 
// Reposition only if this isn't the root prim. 
integer ThisLink = llGetLinkNumber(); 
if (ThisLink != 0 || ThisLink != 1) { 
// This is not the root prim. 
vector Up = llRot2Up(llGetLocalRot()); 
float DistanceToMove = Thickness / 2.0 - Scale.z / 2.0; 
vector Pos = llGetLocalPos(); 
llSetPos(Pos + DistanceToMove * Up); 
} 
// Apply the new thickness. 
Scale.z = Thickness; 
llSetScale(Scale); 
return; 
} 
if (channel == SET_COLOR) { 
vector newColor = (vector)data; 
llSetColor(newColor, ALL_SIDES); 
} 
} 
} 
