integer Private = 1;    // Change to 1 to prevent others riding.
vector Sitpos = <-0.55,0.45,0.10>;
vector SitrotV = <0,-9,0>;
rotation Sitrot;
integer tt;
key oldagent;
key agent;
float forward_power = 1; //Power used to go forward (1 to 30)
float forward_normal = 1;
float crash_power_forward = 2;
float reverse_power = -1; //Power ued to go reverse (-1 to -30)
float turning_ratio = 0.1; //How sharply the vehicle turns. Less is more sharply. (.1 to 10)
float peelboost;
integer turncount;
string Wheeldir = "WC";
string NewWheeldir = "WC";
string Wheelrot = "S";
string NewWheelrot = "S";
integer scount;
float Speed;
integer Gear = 1;
integer Run;
integer oldn;
string sit_message = "Ride"; //Sit message
string not_owner_message = "You are not the owner of this vehicle, but you can copy it and have one of your very own^^"; //Not owner message
vector COLOR = <1.0,1.0,1.0>;
float ALPHA_ON = 0.10;
float ALPHA_OFF = 0.0;
integer visible = TRUE;
string TITLE="";   
string GearChangeSound = "gear change";
float       SteerSens;
string      OwnerName;
//integer     ListenCh;
//integer     chat;
string      DrivingAnim = "cartdriver3"; //Animation to play when owner sits

//Other variables
key         Owner;
integer     anyone;
integer     screech;
integer     burn;
integer     alarm;
integer     NumGears;
integer     NewSound;
integer     CurDir;
integer     LastDir;
integer     Forward;
vector      SpeedVec;
vector      Linear;
vector      Angular;
integer     Active;
key         sitting;
integer     Moving;
string      SimName;

integer     DIR_STOP = 100;
integer     DIR_START = 101;
integer     DIR_NORM = 102;
integer     DIR_LEFT = 103;
integer     DIR_RIGHT = 104;
integer     DIR_FLIGHT = 105;

go_up()
{
    llSetStatus(STATUS_PHYSICS, FALSE);
    llSetRot(<0,0,0,0>);
    llSetStatus(STATUS_PHYSICS, TRUE);
}

setCamera(float degrees) {
rotation sitRot = llAxisAngle2Rot(<0, 0, 1>, degrees * PI);
llSetCameraEyeOffset(<-10, 0, 3> * sitRot);
llSetCameraAtOffset(<4, 0, 3> * sitRot);
llForceMouselook(FALSE);
}

setVehicle()
{
        llSetVehicleType(VEHICLE_TYPE_CAR);
        llSetVehicleFloatParam(VEHICLE_ANGULAR_DEFLECTION_EFFICIENCY, 0.2);
        llSetVehicleFloatParam(VEHICLE_LINEAR_DEFLECTION_EFFICIENCY, 0.80);
        llSetVehicleFloatParam(VEHICLE_ANGULAR_DEFLECTION_TIMESCALE, 0.10);
        llSetVehicleFloatParam(VEHICLE_LINEAR_DEFLECTION_TIMESCALE, 0.10);
        llSetVehicleFloatParam(VEHICLE_LINEAR_MOTOR_TIMESCALE, 3.0);
        llSetVehicleFloatParam(VEHICLE_LINEAR_MOTOR_DECAY_TIMESCALE, 0.1);
        llSetVehicleFloatParam(VEHICLE_ANGULAR_MOTOR_TIMESCALE, 0.1);
        llSetVehicleFloatParam(VEHICLE_ANGULAR_MOTOR_DECAY_TIMESCALE, 0.1);
        llSetVehicleVectorParam(VEHICLE_LINEAR_FRICTION_TIMESCALE, <100.0, 2.0, 1000.0>);
        llSetVehicleVectorParam(VEHICLE_ANGULAR_FRICTION_TIMESCALE, <0.1, 0.1, 0.1>);
        llSetVehicleFloatParam(VEHICLE_VERTICAL_ATTRACTION_EFFICIENCY, 0.1);
        llSetVehicleFloatParam(VEHICLE_VERTICAL_ATTRACTION_TIMESCALE, 5.0);
        llSetVehicleFloatParam(VEHICLE_BUOYANCY, 0.01 );
        llSetVehicleFloatParam( VEHICLE_BANKING_EFFICIENCY, -0.2 );
        llSetVehicleFloatParam( VEHICLE_BANKING_MIX, 1 );
        llSetVehicleFloatParam( VEHICLE_BANKING_TIMESCALE, 1 );
}

Init()
{
    Sound(0);
    llSetStatus(STATUS_PHYSICS, FALSE);
    vector here = llGetPos();
    vector rotv = llRot2Euler(llGetRot());
    rotation rot = llEuler2Rot(<0,0,rotv.z>);
    llSetRot(rot);
    Sitrot = llEuler2Rot(DEG_TO_RAD * SitrotV);
    llSetVehicleType(VEHICLE_TYPE_NONE);
    llMessageLinked(LINK_ALL_OTHERS, 0, "S", NULL_KEY);     // wheels stop
    llMessageLinked(LINK_ALL_OTHERS, 0, "WC", NULL_KEY);     // wheels straight
    Run = 0;
}

Reset()
{

    vector here = llGetPos();

    vector rotv = llRot2Euler(llGetRot());
    rotation rot = llEuler2Rot(<0,0,rotv.z>);

    llSetRot(rot);
    llSetPos(llGetPos() + <0,0,0.5>);

}

SetMaterial()
{
    llSetPrimitiveParams([PRIM_MATERIAL, PRIM_MATERIAL_GLASS]);
    llMessageLinked(LINK_ALL_OTHERS, 0, "SetMat", NULL_KEY);    // Tell daughter pims on ground to be glass
}

Sound(integer n)
{
    if(n != oldn)
    {
        oldn = n;
        if(n == 2)
        {
            llStopSound();

        }
        else if(n == 1)
        {
            llStopSound();
            llLoopSound("bike_idle",1);
        }
        else
        {
             llStopSound();
        }
    }
}

show(){
    visible = TRUE;
    llSetText(TITLE, COLOR,ALPHA_ON);        
    llSetAlpha(ALPHA_ON, ALL_SIDES);
}
 
hide(){
    visible = FALSE;
    llSetText("", COLOR,ALPHA_ON);        
    llSetAlpha(ALPHA_OFF, ALL_SIDES);
}    

default
{
    state_entry()
    {
        Init();
        llSetSitText(sit_message);
        llSitTarget(Sitpos, Sitrot);
        llStopSound();
        setCamera(0);
    }
               
    changed(integer change)
    {
        if ((change & CHANGED_LINK) == CHANGED_LINK)
        {
            agent = llAvatarOnSitTarget();
            if (agent != NULL_KEY)
            {                
                if( (agent != llGetOwner()) && (Private == 1) )
                {
                    show();
                    llSay(0, not_owner_message);
                    llUnSit(agent);

                }
                else
                {
                    oldagent = agent;
                    setVehicle();
                    SetMaterial();
                    llSleep(.4);
                    llSetStatus(STATUS_PHYSICS, TRUE);
                    llSleep(.5);
                    Run = 1;
                    llSetTimerEvent(0.3);

                    llRequestPermissions(agent, PERMISSION_TRIGGER_ANIMATION | PERMISSION_TAKE_CONTROLS);
                    Sound(1);
                    hide();
                }
            }
            else
            {
                Init();
                llSleep(.4);
                show();
                llReleaseControls();                
                llStopAnimation(DrivingAnim);
                llSetPos(llGetPos() + <0,0,0.5>);
                Run = 0;
                llStopSound();
            }
        }
    }
    
    run_time_permissions(integer perm)
    {
        if (perm)
        {
            forward_power = forward_normal; //Power used to go forward (1 to 30)
            reverse_power = -1; //Power ued to go reverse (-1 to -30)
            turning_ratio = 0.28; //How sharply the vehicle turns. Less is more sharply. (.1 to 10)
            Gear = 2;
            llTakeControls(CONTROL_FWD | CONTROL_BACK | CONTROL_DOWN | CONTROL_UP | CONTROL_RIGHT | CONTROL_LEFT | CONTROL_ROT_RIGHT | CONTROL_ROT_LEFT, TRUE, FALSE);
            llSetPos(llGetPos() + <0,0,0.5>);
            llStartAnimation(DrivingAnim);
            llWhisper(0,"Hit M for mouselook, page up and down to go faster or slower");
        }
    }
    
    control(key id, integer level, integer edge)
    {
        integer reverse=1;
        vector angular_motor;
        
        //get current speed
        vector vel = llGetVel();
        Speed = llVecMag(vel);

        //car controls
        
         if ((level & edge & CONTROL_UP) || ((Gear >= 5) && (level & CONTROL_UP)))
        {
            Gear=Gear+1;
            llTriggerSound(GearChangeSound, 1.0);
            if(Gear == 1){ 
                         }                                           
            if (Gear < 1) Gear = 1;
            if (Gear > 5) Gear = 5;
        }
        
        if ((level & edge & CONTROL_DOWN) || ((Gear >= 5) && (level & CONTROL_DOWN)))
        {
            Gear=Gear-1;
            llTriggerSound(GearChangeSound, 1.0);
            if(Gear == 1){ 
                         }                         
            if (Gear < 1) Gear = 1;
            if (Gear > 5) Gear = 5;
        }
        
        if(level & CONTROL_FWD)
        {
            if(Gear == 1) {

            llLoopSound("bike_drive",1);
            llSetVehicleVectorParam(VEHICLE_LINEAR_FRICTION_TIMESCALE, <10.0, 2.0, 1000.0>);
            llSetVehicleVectorParam(VEHICLE_LINEAR_MOTOR_DIRECTION, <(Gear*forward_power)+5,0,0>);
                          }
            if(Gear == 2) {
            llSetVehicleVectorParam(VEHICLE_LINEAR_FRICTION_TIMESCALE, <10.0, 2.0, 1000.0>);
            llSetVehicleVectorParam(VEHICLE_LINEAR_MOTOR_DIRECTION, <Gear*(forward_power+1),0,0>);
            llLoopSound("bike_drive",1);
                          }
            if(Gear == 3) {
            llSetVehicleVectorParam(VEHICLE_LINEAR_FRICTION_TIMESCALE, <10.0, 2.0, 1000.0>);
            llSetVehicleVectorParam(VEHICLE_LINEAR_MOTOR_DIRECTION, <Gear*(forward_power+2),0,0>);
            llLoopSound("bike_drive",1);                
                          }
                          if(Gear == 4) {
            llSetVehicleVectorParam(VEHICLE_LINEAR_FRICTION_TIMESCALE, <10.0, 2.0, 1000.0>);
            llSetVehicleVectorParam(VEHICLE_LINEAR_MOTOR_DIRECTION, <Gear*(forward_power+3),0,0>);
            llLoopSound("bike_drive",1);                
                          }
                          if(Gear == 5) {
            llSetVehicleVectorParam(VEHICLE_LINEAR_FRICTION_TIMESCALE, <10.0, 2.0, 1000.0>);
            llSetVehicleVectorParam(VEHICLE_LINEAR_MOTOR_DIRECTION, <Gear*(forward_power+4),0,0>);
            llLoopSound("bike_drive",1);                
                          }                                              
            reverse=1;
            llMessageLinked(LINK_ALL_OTHERS, 0, "Brakeoff", NULL_KEY);
            NewWheelrot = "F";
        }

        if(level & CONTROL_BACK)
        {
            llSetVehicleVectorParam(VEHICLE_LINEAR_FRICTION_TIMESCALE, <10.0, 2.0, 1000.0>);
            llSetVehicleVectorParam(VEHICLE_LINEAR_MOTOR_DIRECTION, <Gear*reverse_power,0,0>);
            reverse = -1;
            if(reverse-1)llMessageLinked(LINK_ALL_OTHERS, 0, "Brakeon", NULL_KEY);
            NewWheelrot = "R";
        }

        if(level & (CONTROL_RIGHT|CONTROL_ROT_RIGHT))
        {
            if(Gear == 1) angular_motor.z -= (Speed/256) / (turning_ratio/256);
            if(Gear > 1) angular_motor.z -= Speed / (turning_ratio*Gear) * reverse;
            NewWheeldir = "WR";
            turncount = 10;
        }
                        
        if(level & (CONTROL_LEFT|CONTROL_ROT_LEFT))
        {
            if(Gear == 1) angular_motor.z += (Speed/256) / (turning_ratio/256);
            if(Gear > 1) angular_motor.z += Speed / (turning_ratio*Gear) * reverse;
            NewWheeldir = "WL";
            turncount = 10;
        }

        llSetVehicleVectorParam(VEHICLE_ANGULAR_MOTOR_DIRECTION, angular_motor);
        if(turncount > 0)
        {
            turncount--;
        }
        if(turncount == 1)
        {
            NewWheeldir = "WC";
        }
        if(Wheeldir != NewWheeldir){
            Wheeldir = NewWheeldir;
            llMessageLinked(LINK_ALL_OTHERS, 0, Wheeldir, NULL_KEY);
        }
        if(Wheelrot != NewWheelrot){
            Wheelrot = NewWheelrot;
            llMessageLinked(LINK_ALL_OTHERS, 0, Wheelrot, NULL_KEY);
        }
    } //end control       

    timer(){
        if(Run == 1){
            vector vel = llGetVel();
            Speed = llVecMag(vel);
//llOwnerSay("t, Speed " + (string)Speed);            
            if(Speed > 2.0)
            {
                Sound(2);
            }
           if(CurDir != LastDir)
            {
            llMessageLinked(LINK_ALL_CHILDREN, CurDir, "", NULL_KEY);
            LastDir = CurDir;
            }
            else if(Speed > 0.0)
            {
                llSetVehicleVectorParam(VEHICLE_LINEAR_FRICTION_TIMESCALE, <1.0, 2.0, 1000.0>);
                llSetVehicleVectorParam(VEHICLE_LINEAR_MOTOR_DIRECTION, <0,0,0>);
                llMessageLinked(LINK_ALL_OTHERS, 0, "S", NULL_KEY);
                Sound(1);
                Wheelrot = "S";
            }
            llSetTimerEvent(0.3);          // If restarted timer() appears to keep working  
        }else{
            llSetTimerEvent(0.0);
        }
    }
    
} //end default