string notecard_name = "_Config";
integer iline;
key queryhandle;
key notecarduuid;
integer POT;
integer POURCENT_TO_POT;
integer PRICE;
integer TIME_MODE;
list PAYOUT_TIME;
integer TIMER_START_AFTER;
integer INSTANT_WIN_MODE;
integer SCORE_TO_BEAT;
string AFTER_PAYOUT;
integer CONTEST_MODE;
string SECRET_KEY;
integer BOARD_NUMBER;
integer LOOSE_DECREASE;
integer WIN_INCREASE;
integer DEFAULT_SCORE;
integer REPORT;
string temp;
init()
{
    queryhandle = llGetNotecardLine(notecard_name,++iline);
    notecarduuid = llGetInventoryKey(notecard_name);
}
default
{
    state_entry()
    {
        notecarduuid = llGetInventoryKey(notecard_name);
    }
    
    link_message(integer sender, integer num, string str, key id)
    {
        if (num==200100 && str=="LOAD")
        {
            notecarduuid = llGetInventoryKey(notecard_name);
            llSetText("Reading Config File...\n ",<1,1,0>,1);
            llSleep(1);
            init();
        }
    }
    changed(integer change)
    {
        if (change & CHANGED_INVENTORY)
        {
            if (notecarduuid!=llGetInventoryKey(notecard_name))
                llOwnerSay("Perform a reset to change for new values...");
        }
    }
    dataserver(key query_id, string data)
    {
        if (query_id == queryhandle)
        {
            if (data != EOF)
            {
                data = llStringTrim(data, STRING_TRIM_HEAD);
                if (llGetSubString (data, 0, 0) != "-")
                {
                    integer s = llSubStringIndex(data, "=");
                    if(~s)
                    {
                        string token = llToUpper(llStringTrim(llDeleteSubString(data, s, -1), STRING_TRIM));
                        data = llStringTrim(llDeleteSubString(data, 0, s), STRING_TRIM);
                        
                        if (token == "POT")
                        {
                            POT = (integer)data;
                            llOwnerSay(token+" = "+data);
                            llMessageLinked(8,14,"  "+(string)POT+" B$",NULL_KEY);
                        }
                            
                        else if (token == "SKIN_KEY")
                        {
                            llSetTexture(data,ALL_SIDES);
                        }
                            
                        else if (token == "GRID_KEY")
                        {
                            llMessageLinked(1,7654321,data,"GRID_TEXTURE");
                        }
                        else if (token == "X2_ON")
                        {
                            if ((integer)data==1)
                                llMessageLinked(1,7654321,data,"X2_ON");
                            else
                                llMessageLinked(1,7654321,data,"X2_OFF");
                            llOwnerSay(token+" = "+data);
                        }
                        else if (token == "%_TO_POT")
                        {
                            POURCENT_TO_POT = (integer)data;
                            llOwnerSay(token+" = "+data);
                        }
                            
                        else if (token == "%_TO_POT")
                        {
                            POURCENT_TO_POT = (integer)data;
                            llOwnerSay(token+" = "+data);
                        }
                            
                        else if (token == "PRICE_TO_PLAY")
                        {
                            PRICE = (integer)data;
                            if (PRICE>0)
                            {
                                temp=(string)PRICE;
                                if (PRICE<1000)
                                    temp+=" ";
                                while (llStringLength(temp)<4)
                                    temp = " "+temp;
                                llOwnerSay(token+" = "+data);
                                llMessageLinked(9,9,temp+"  "+(string)POURCENT_TO_POT,NULL_KEY);
                            }
                            else
                            {
                                llOwnerSay("PRICE = FreePlay");
                                llMessageLinked(9,9,"FREE  PLAY",NULL_KEY);
                            }
                        }
                            
                        else if (token == "TIME_MODE")
                        {
                            TIME_MODE = (integer)data;
                            if (TIME_MODE==1)
                                llOwnerSay("TIME_MODE = ON");
                            else
                            {
                                TIME_MODE=0;
                                llOwnerSay("TIME_MODE = OFF");
                            }
                        }
                            
                        else if (token == "PAYOUT_TIME")
                        {
                            PAYOUT_TIME = llParseString2List(data,[","],[]);
                            if (TIME_MODE==1)
                                llOwnerSay(token+" = "+data);
                        }
                        
                        else if (token == "TIMER_START_AFTER")
                        {
                            TIMER_START_AFTER = (integer)data;
                            if (TIME_MODE==1)
                                llOwnerSay(token+" = "+data);
                        }
                                                    
                        else if (token == "INSTANT_WIN_MODE")
                        {
                            INSTANT_WIN_MODE = (integer)data;
                            if (INSTANT_WIN_MODE==1)
                                llOwnerSay("INSTANT_WIN_MODE = ON");
                            else
                            {
                                INSTANT_WIN_MODE=0;
                                llOwnerSay("INSTANT_WIN_MODE = OFF");
                            }
                        }
                            
                        else if (token == "SCORE_TO_BEAT")
                        {
                            SCORE_TO_BEAT = (integer)data;
                            if (INSTANT_WIN_MODE==1)
                                llOwnerSay(token+" = "+data);
                        }
                            
                        else if (token == "AFTER_PAYOUT")
                        {
                            AFTER_PAYOUT = data;
                            if (data=="STOP")
                                llOwnerSay("AFTER_PAYOUT = GO TO MAINTENANCE MODE");
                            else
                            {
                                AFTER_PAYOUT = "NEW";
                                llOwnerSay("AFTER_PAYOUT = NEW GAME");
                            }
                        }
                            
                        else if (token == "CONTEST_MODE")
                        {
                            CONTEST_MODE = (integer)data;
                            if (CONTEST_MODE==1)
                                llOwnerSay("CONTEST_MODE = ON");
                            else
                            {
                                CONTEST_MODE=0;
                                llOwnerSay("CONTEST_MODE = OFF");
                            }
                        }
                            
                        else if (token == "SECRET_KEY")
                        {
                            SECRET_KEY = llMD5String(data,7);
                            if (CONTEST_MODE==1)
                                llOwnerSay(token+" = "+data);
                        }
                            
                        else if (token == "BOARD_NUMBER")
                        {
                            BOARD_NUMBER = (integer)data;
                            if (CONTEST_MODE==1)
                                llOwnerSay(token+" = "+data);
                        }
                        
                        else if (token=="LOOSE_DECREASE")
                        {
                            LOOSE_DECREASE = (integer)data;
                            if (PRICE==0 && LOOSE_DECREASE>0 && INSTANT_WIN_MODE==1)
                            {
                                llOwnerSay("\n-----------------!!! WARNING !!! It's dangerous to set a Loose decrease in FreePlay Mode !\nLOOSE_DECREASE is now set to 0\n-----------------");
                                LOOSE_DECREASE=0;
                            }
                            if (INSTANT_WIN_MODE==1)
                                llOwnerSay(token+" = "+data);
                        }
                        
                        else if (token=="WIN_INCREASE")
                        {
                            WIN_INCREASE = (integer)data;
                            if (INSTANT_WIN_MODE==1)
                                llOwnerSay(token+" = "+data);
                        }
                        
                        else if (token=="DEFAULT_SCORE")
                        {
                            DEFAULT_SCORE = (integer)data;
                            if (CONTEST_MODE==1 || TIME_MODE==1)
                                llOwnerSay(token+" = "+data);
                        }
                        
                        else if (token=="REPORT")
                        {
                            REPORT=(integer)data;
                            if (REPORT==1)
                                llOwnerSay("REPORT = ON");
                            else
                            {
                                REPORT=0;
                                llOwnerSay("REPORT = OFF");
                            }
                        }
                    }
                }
                queryhandle = llGetNotecardLine(notecard_name, ++iline);
            }
            else
            {        
                llSetText("",<1,1,1>,0);
                llMessageLinked(1,2001002,(string)POT+"*s:"+(string)POURCENT_TO_POT+"*s:"+(string)PRICE+"*s:"+(string)TIME_MODE+"*s:"+(string)TIMER_START_AFTER+"*s:"+(string)llList2Integer(PAYOUT_TIME,0)+","+(string)llList2Integer(PAYOUT_TIME,1)+","+(string)llList2Integer(PAYOUT_TIME,2)+"*s:"+(string)INSTANT_WIN_MODE+"*s:"+(string)SCORE_TO_BEAT+"*s:"+(string)AFTER_PAYOUT+"*s:"+(string)CONTEST_MODE+"*s:"+(string)SECRET_KEY+"*s:"+(string)BOARD_NUMBER+"*s:"+(string)LOOSE_DECREASE+"*s:"+(string)WIN_INCREASE+"*s:"+(string)DEFAULT_SCORE+"*s:"+(string)REPORT,llGetOwner());
                llResetScript();
            }
        }
    }
}