//XEngine:lsl
/*
  ScriptName: Tuner_MV2.0
  Creator: Sixtus Majus
  Version: MV2.0
  Create Date: 11/08/2013
*/

// #### USER_SETTINGS BEGIN ####
// Nothing to configure here see config notecard
// #### USER_SETTINGS END ####

key     gAVKey;
string  gAVName;
key     gGroupKey;

string  gStationName;
string  gStationURL;
string  gStationType;
string  gStationTypeName;

string  gSTATIONTypeSC1 = "SC1";
string  gSTATIONTypeNameSC1 = "SHOUTCast V1";
string  gSTATIONTypeSC2 = "SC2";
string  gSTATIONTypeNameSC2 = "SHOUTCast V2";
string  gSTATIONTypeIC2 = "IC2";
string  gSTATIONTypeNameIC2 = "Icecast V2";

list    gStationList;
integer gStationListIDXName     = 0;
integer gStationListIDXURL      = 1;
integer gStationListIDXType     = 2;
integer gStationListIDXTypeName = 3;
integer gStationListCols        = 4;
integer gStationListEntries;

list    gReplaceCharList;
integer gReplaceCharListEntries;

list    gStatusList;
string  gCurrentMenu;

list    gMessageList;
list    gMessagePRIORList;
integer gMessageListEntries;

string  gPlayingMsg;
string  gPlayingMsgPRIOR;

key     gComKey      = "Radio";
string  gFieldDelim    = "♢";

integer gComSyncListenChannel;

// Config Stuff
string  gOFFMessage;
string  gFontTexture;
string  gFontTextureDEFAULT = "XyzzyText Font Verdana";
float   gCheckTime;
float   gCheckTimeDEFAULT = 20.0;
integer gSetParcelURL;
key     gComGroup;
integer gAllowGroup;
list    gAllowedList;


integer  gSyncInProgress;

// Stream Status Stuff
integer STREAM_STATUS_URL  = 22100; // the URL (or host:port) of the stream (polling begins immediatly)
integer STREAM_STATUS_TIME = 22101; // how often to check for a new song title (be kind to your server) (seconds)
integer STREAM_STATUS_DATA = 22103; // the stream status is sent back with this
                                    // the data is a 2-strided list of name/value pairs
                                    // name is UPPERCASE and prefixed by == (to make it easy to find with ListFindList
                                    // The list packed with "♢" delimiters before being sent

// XyzzyText stuff
integer DISPLAY_STRING      = 204000;
integer RESET_INDICES       = 204003;
integer SET_FONT_TEXTURE    = 204005;


// ********** BEGIN DIALOG STUFF **********

integer lnkDialog         = 14001;
integer lnkDialogNotify   = 14004;
integer lnkDialogResponse = 14002;
integer lnkDialogTimeOut  = 14003;
integer lnkDialogTextbox  = 14007;

integer lnkMenuClear      = 15001;
integer lnkMenuAdd        = 15002;
integer lnkMenuShow       = 15003;

string  seperator = "||";
integer dialogTimeOut = 0;

string packDialogMessage(string message, list buttons, list returns)
{
  string packed_message = message + seperator + (string)dialogTimeOut;

  integer i;
  integer count = llGetListLength(buttons);
  string button;

  for(i=0; i<count; i++)
  {
    button = llList2String(buttons, i);
    if ( llStringLength(button) > 24 )
     button = llGetSubString(button, 0, 23);

    packed_message += seperator + button + seperator + llList2String(returns, i);
  }

  return packed_message;
}

dialog(key id, string message, list buttons, list returns){
    llMessageLinked(LINK_THIS, lnkDialog, packDialogMessage(message, buttons, returns), id);
}

dialogTextbox(key id, string message){
    llMessageLinked(LINK_THIS, lnkDialogTextbox, message + seperator + (string)dialogTimeOut, id);
}

dialogNotify(key id, string message){
    list rows;

    llMessageLinked(LINK_THIS, lnkDialogNotify,
        message + seperator + (string)dialogTimeOut + seperator,
        id);
}
// ********** END DIALOG STUFF **********

string GetStatusListValue(string name)
{
  string  lItemName = llToUpper(name);
  integer lIndex;

  if (lItemName == "STATION_NAME") return gStationName;
  else if (lItemName == "STATION_URL")  return gStationURL;
  else if (lItemName == "STATION_TYPE") return gStationType;
  else if (lItemName == "STATION_TYPENAME") return gStationTypeName;

  lIndex = llListFindList(gStatusList,[ "==" + lItemName ]);
  if (lIndex >= 0)
   return( llList2String(gStatusList,lIndex + 1 ) );

  return("");
}

string ReplaceMessageVars( string fText, integer fON )
{
  list    lPartList  = llParseStringKeepNulls(fText,[ "~~" ],[]);
  integer li = llGetListLength(lPartList);
  string  lPart;
  string  lOut;

  if ( li >= 0 )
  {
    @Loop;

     if ( (lPart = llList2String(lPartList,li)) != "" )
     {
       if ( li & 1 ) // Each second string containig a message variable
       {
         if ( fON  )
          lOut = GetStatusListValue( lPart ) + lOut;
         else
          lOut = gOFFMessage + lOut; // OFF message
       }
       else
        lOut = lPart + lOut;
     }

    if ( (--li) >= 0 ) jump Loop;
  }

  return lOut;
}

string ReplaceChars( string fString )
{
  integer li;

  if ( gReplaceCharListEntries > 0 )
  {
   @Loop;

    fString = osReplaceString( fString, llList2String( gReplaceCharList, li ), llList2String( gReplaceCharList, li + 1 ), -1, 0 );

   if ( (li += 2) < gReplaceCharListEntries ) jump Loop;
  }

  return( fString );
}

UpdateMessages( integer fON )
{
  integer li;
  string  lMsgPRIOR;
  string  lMsgNEW;

  // Update messages on board
  if ( gMessageListEntries > 0 )
  {
    @Loop;

     lMsgPRIOR = llList2String(gMessagePRIORList, li);
     lMsgNEW = ReplaceMessageVars( llList2String(gMessageList, li), fON );
     if ( lMsgNEW != lMsgPRIOR )
     {
       gMessagePRIORList = llListReplaceList( gMessagePRIORList,[ lMsgNEW ],li ,li );
       llMessageLinked( LINK_THIS, DISPLAY_STRING, lMsgNEW ,(string)li );
     }

    if ( (++li) < gMessageListEntries ) jump Loop;
  }

  // Display playing message in chat
  if ( fON && GetStatusListValue( "CURRENT_SONG" ) != "" )
  {
      if (gPlayingMsg != "")
      {
        lMsgNEW = ReplaceMessageVars( gPlayingMsg, TRUE );
        if (lMsgNEW != gPlayingMsgPRIOR)
        {
          llSay(0,lMsgNEW);
          gPlayingMsgPRIOR = lMsgNEW;
        }
      }
  }
}

string GetStationTypeNameFromURL( string fURL )
{
  integer lListIndex = llListFindList( gStationList,[ fURL ]);
  if ( lListIndex >= 0 )
   return( llList2String( gStationList, lListIndex + 2 ) );

  return( "SC1" );
}

string GetStationTypeFromURL( string fURL )
{
  integer lListIndex = llListFindList( gStationList,[ fURL ]);
  if ( lListIndex >= 0 )
   return( llList2String( gStationList, lListIndex + 1 ) );

  return( "SC1" );
}

string GetStationNameFromURL( string fURL )
{
  integer lListIndex = llListFindList( gStationList,[ fURL ]);
  if ( lListIndex >= 0 )
   return( llList2String( gStationList, lListIndex - 1 ) );

  return( "Unknown" );
}

string GetURLFromStation( string fStationName )
{
  integer lListIndex = llListFindList( gStationList,[ fStationName ]);
  if ( lListIndex >= 0 )
   return( llList2String( gStationList, lListIndex + 1 ) );

  return( "" );
}

HandleMenuResponse( string fCmd )
{
  string  lCmd;
  string  lValue;
  integer lPosIDX = llSubStringIndex( fCmd, "_" );

  if ( lPosIDX > 0 )
  {
   lCmd = llGetSubString( fCmd, 0, lPosIDX - 1 );
   lValue = llGetSubString( fCmd, lPosIDX + 1,  -1 );
  }
  else
   lCmd = fCmd;

  if ( lCmd == "MENU" )
   gCurrentMenu = lValue;
  else if ( lCmd == "STATION" )
   URLSet( GetURLFromStation( lValue ) );
  else if ( lCmd == "OFF" )
   URLSet( "" );
  else if ( lCmd == "RESTART")
   URLSet();
  else if ( lCmd == "URL")
  {
    string lMsg  = "\nPlease, enter a valid Stream-URL:\nExamples:\n";
           lMsg += "http://108.61.73.119:10002\n";
           lMsg += "http://213.188.119.209:8000/stream\n";
           lMsg += "http://metroradio.hypergrid.org:8000/stream?sid=1";

    dialogTextbox( gAVKey, lMsg );
  }
  else if ( llSubStringIndex( llToLower(fCmd), "http://" ) == 0 )
   URLSet( llToLower(fCmd) );
}


URLSet() { URLSet( gStationURL ); }
URLSet( string lURL )
{
  gPlayingMsgPRIOR = "";
  gStationURL      = lURL;
  gStationName     = GetStationNameFromURL( lURL );

  if ( gStationName != "" )
  {
    gStationType     = GetStationTypeFromURL( lURL );
    gStationTypeName = GetStationTypeNameFromURL( lURL );
  }
  else // URL not known so set to default
  {
   gStationName = "-- Unknown --";
   gStationType = gSTATIONTypeSC1;
   gStationTypeName = gSTATIONTypeNameSC1;
  }

  llMessageLinked( LINK_THIS, STREAM_STATUS_URL, gStationURL + gFieldDelim + gStationType, NULL_KEY );
  if ( gSetParcelURL && !gSyncInProgress )
  {
   llSetParcelMusicURL( gStationURL );

   if ( gComGroup != "" )
   {
    // Send to other radios
    SetupComChannel();
    llRegionSay( gComSyncListenChannel, gComKey     + gFieldDelim +
                                        gComGroup   + gFieldDelim +
                                        gStationURL + gFieldDelim +
                                        gAVName
               );
   }
  }

  if ( gStationURL == "" )
   UpdateMessages( FALSE );
}

integer ConfigLoad()
{
  string lNCName = llList2String(llParseString2List(llGetScriptName(), ["_"], []),0) + " - Config";

  gMessageList            = [];
  gMessageListEntries     = 0;
  gOFFMessage             = "";
  gReplaceCharList        = [];
  gReplaceCharListEntries = 0;
  gPlayingMsg             = "";
  gCheckTime              = -1;
  gFontTexture            = "";
  ConfigLoadNC( lNCName + " - Board" );

  gStationList        = [];
  gStationListEntries = 0;
  gAllowedList        = [];
  gAllowGroup         = FALSE;
  gSetParcelURL       = TRUE;
  gComGroup           = "";
  ConfigLoadNC( lNCName + " - User" );

  return( TRUE );
}

// Load configuration from notecard
integer ConfigLoadNC( string fNCName )
{
  if ( llGetInventoryType( fNCName ) == INVENTORY_NOTECARD )
  {
      list     lCfgList = llParseString2List(osGetNotecard( fNCName ), ["\n"], []);
      integer  lCfgListEntries = llGetListLength( lCfgList );
      string   lLine;
      string   lChar;
      integer  lVari;
      string   lVarName;
      string   lStationType;
      string   lStationTypeName;
      list     lVarNameParts;
      string   lVarValue;
      integer  lVarPosIdx;

      @Loop;

       lLine  = llStringTrim(llList2String( lCfgList, lVari ), STRING_TRIM);
       lChar  = llGetSubString( lLine, 0, 0 );

       if ( lLine != "" && lChar != "#" && lChar != "!" && llSubStringIndex( lLine, "///" ) != 0 )
       {
           if ( (lVarPosIdx = llSubStringIndex( lLine, "=" )) >= 0 )
           {
             lVarName  = llStringTrim(llGetSubString( lLine, 0, lVarPosIdx - 1 ), STRING_TRIM);
             lVarValue = llStringTrim(llGetSubString( lLine, lVarPosIdx + 1, -1 ), STRING_TRIM);

             if ( (lVarPosIdx = llSubStringIndex( lVarValue, "///" )) >= 0 )
              lVarValue = llStringTrim(llGetSubString( lVarValue, 0, lVarPosIdx - 1 ), STRING_TRIM);

             if ( llToUpper(lVarValue) == "TRUE" )
              lVarValue = "1";
             else if ( llToUpper(lVarValue) == "FALSE" )
              lVarValue = "0";

             if ( (lVarPosIdx = llSubStringIndex( lVarValue, "\"" )) >= 0 )
             {
              lVarValue = llGetSubString( lVarValue, 1, -1 );

              if ( lVarValue == "\"" )
               lVarValue = "";
              else if ( llGetSubString( lVarValue, -1, -1 ) == "\"" )
               lVarValue = llGetSubString( lVarValue, 0, -2 );

              lVarValue = osReplaceString( lVarValue, "\\n", "\n", -1, 0 );
            }

            lVarName      = llToLower(lVarName);
            lVarNameParts = llParseStringKeepNulls(lVarName,["[","]"],[]);
            lVarName      = llList2String( lVarNameParts, 0 );

            if (lVarName == "station" && lVarValue != "" )
            {
               if ( (lVarPosIdx = llSubStringIndex( lVarValue, "=" )) >= 0 )
               {
                 lVarName  = llStringTrim(llGetSubString( lVarValue, 0, lVarPosIdx - 1 ), STRING_TRIM);
                 lVarValue = llToLower(llStringTrim(llGetSubString( lVarValue, lVarPosIdx + 1, -1 ), STRING_TRIM));
                 lStationType = llToUpper(llList2String( lVarNameParts, 1 ));

                 if ( lStationType == gSTATIONTypeSC2 )
                  lStationTypeName = gSTATIONTypeNameSC2;
                 else if ( lStationType == gSTATIONTypeIC2 )
                  lStationTypeName = gSTATIONTypeNameIC2;
                 else
                 {
                  lStationType = gSTATIONTypeSC1;
                  lStationTypeName = gSTATIONTypeNameSC1;
                 }

                 if ( llSubStringIndex( lVarValue, "http://" ) == 0 )
                  gStationList += [ lVarName, lVarValue,  llToUpper(lStationType), lStationTypeName ];
               }

            }
            else if (lVarName == "replace" && lVarValue != "" )
            {

               if ( (lVarPosIdx = llSubStringIndex( lVarValue, "=" )) >= 0 )
               {
                 lVarName  = osReplaceString( llStringTrim(llGetSubString( lVarValue, 0, lVarPosIdx - 1 ), STRING_TRIM), "\"", "", -1, 0 );
                 lVarValue = osReplaceString( llToLower(llStringTrim(llGetSubString( lVarValue, lVarPosIdx + 1, -1 ), STRING_TRIM)), "\"", "", -1, 0 );

                 gReplaceCharList += [ lVarName, lVarValue ];
               }

            }
            else if (lVarName == "message")        gMessageList += [ lVarValue ];
            else if (lVarName == "offmessage")     gOFFMessage = lVarValue;
            else if (lVarName == "playingmessage") gPlayingMsg = lVarValue;
            else if (lVarName == "checktime")      gCheckTime = (float)lVarValue;
            else if (lVarName == "fonttexture")    gFontTexture = lVarValue;
            else if (lVarName == "setparcelurl")   gSetParcelURL = (integer)lVarValue;
            else if (lVarName == "allowgroup")     gAllowGroup = (integer)lVarValue;
            else if (lVarName == "allow" && lVarValue != "" ) gAllowedList += [ llToLower(lVarValue) ];
            else if (lVarName == "comgroup")       gComGroup = lVarValue;
           }
        }

      if ( (++lVari) < lCfgListEntries && lChar != "!" ) jump Loop;

      gStationListEntries     = llGetListLength( gStationList ) / gStationListCols;
      gReplaceCharListEntries = llGetListLength( gReplaceCharList );
      gMessageListEntries     = llGetListLength( gMessageList );

      if ( gCheckTime <= 0 )
       gCheckTime =  gCheckTimeDEFAULT;
      else if ( gCheckTime < 5 ) gCheckTime = 5;

      if ( gFontTexture == "" ) gFontTexture = gFontTextureDEFAULT;
  }
  else
   return( FALSE );

  return( TRUE );
}

ClearBoard()
{
  integer li;

  gMessagePRIORList = [];
  gPlayingMsgPRIOR  = "";

  if ( gMessageListEntries > 0 )
  {
    @Loop;
     llMessageLinked( LINK_THIS, DISPLAY_STRING, "", (string)li );
    if ( (++li) < gMessageListEntries ) jump Loop;
  }
}

TunerSync( list fData )
{
  if ( llGetListLength(fData) != 4 )       return;
  if ( llList2Key(fData, 0) != gComKey )   return;
  if ( llList2Key(fData, 1) != gComGroup ) return;
  string lURL = llToLower(llList2String(fData, 2));

  if ( lURL == "" || llSubStringIndex( lURL, "http://" ) == 0 )
  {
   gSyncInProgress = TRUE;
   URLSet( lURL );
   gSyncInProgress = FALSE;
  }
}

integer Key2Channel( key fKey, string fId )
{
    integer i;
    float   lResult;
    string  ls = llToUpper(llDumpList2String( llParseStringKeepNulls(fKey,["-"],[]), fId ));

    @Loop;

     lResult += (float)((integer)("0x"+llGetSubString(ls,i,i + 4)));

     if ( lResult > 2147483647.0 ) lResult -= 2147483647.0;
     if ( lResult < 100 )          lResult += 100;

    if ( (i += 1) < llStringLength(ls) ) jump Loop;

    return( (integer)lResult );
}

integer IsAuthorized( key fAVKey )
{
 if ( fAVKey == llGetOwner() ) return TRUE;
 if ( llGetAgentSize(fAVKey) != ZERO_VECTOR )
 {
  if ( gAllowGroup && llSameGroup( fAVKey ) ) return TRUE;
  if ( llListFindList( gAllowedList, [ llToLower(llKey2Name(fAVKey)) ] ) >= 0 ) return TRUE;
 }
 return FALSE;
}

SetupMenu()
{
 list    lButtons;
 string  lButtonName;
 list    lReturns;
 integer li;

 // Clear menu
 llMessageLinked(LINK_THIS, lnkMenuClear, "", NULL_KEY);

 // Make main menu

 lButtons += [ "Stations",      "URL", "  -  ", "OFF", "RESTART" ];
 lReturns += [ "MENU_Stations", "URL", "  -  ", "OFF", "RESTART" ];

 llMessageLinked( LINK_THIS, lnkMenuAdd,
                  packDialogMessage( "[ Tuner Main Menu ]\n" +
                                     "\nChoose",
                                     lButtons,
                                     lReturns
                                   ),
                     "MainMenu"
                );

 // Make station menu
 lButtons = [];
 lReturns = [];

 @Loop;

  lButtonName = llList2String( gStationList, li * gStationListCols );

  lButtons += [ lButtonName ];
  lReturns += [ "STATION_" + lButtonName ];

 if ( (++li) < gStationListEntries ) jump Loop;

 lButtons += [ "Main Menu" ];
 lReturns += [ "MENU_MainMenu" ];

 llMessageLinked( LINK_THIS, lnkMenuAdd,
                  packDialogMessage( "[ Station Menu ]\n" +
                                     "\nChoose",
                                     lButtons,
                                     lReturns
                                   ),
                     "Stations"
                );
}

SetupComChannel()
{
 key lGroupKey = llList2Key( llGetObjectDetails(llGetKey(),[OBJECT_GROUP]), 0);

 if ( lGroupKey != gGroupKey )
 {
  gComSyncListenChannel  = -Key2Channel( lGroupKey, "" );
  gGroupKey = lGroupKey;
 }

 llListenRemove( gComSyncListenChannel );
 llListen( gComSyncListenChannel,"", NULL_KEY, "" );
}

Setup()
{
  // Setup Menu
  SetupMenu();

  // Setup Board
  llMessageLinked(LINK_THIS,SET_FONT_TEXTURE,"",(key)gFontTexture);
  ClearBoard();

  // Set check time
  llMessageLinked(LINK_SET,STREAM_STATUS_TIME,(string)gCheckTime,NULL_KEY);

  // Set Station-URL
  if ( gStationURL == "" )
  {
   gStationURL  = llList2String( gStationList, gStationListIDXURL );
   gStationType = llList2String( gStationList, gStationListIDXType );
   gStationTypeName = llList2String( gStationList, gStationListIDXTypeName );
  }
}

Reset()
{
  gAVKey = llGetOwner();
  gAVName = llKey2Name( gAVKey );

  llSleep( 3 ); // Wait for other scripts to be reseted first
  llOwnerSay( "Reset(" + llList2String(llParseString2List(llGetScriptName(), [" ","-"], []),0) + ") done." );
  state Config;
}

default
{
  state_entry()
  { Reset(); }
}

state Config
{
  state_entry()
  {
    if ( ConfigLoad() )
    {
     Setup();
     state Work;
    }
  }
}

state Work
{
  state_entry()
  {
    SetupComChannel();
    URLSet();
  }

  on_rez( integer fStartParm )
  { state Restart; }

  touch_start( integer fNum )
  {
    if ( fNum != 1 || !IsAuthorized(llDetectedKey(0))) return;

    gAVKey  = llDetectedKey(0);
    gAVName = llKey2Name( gAVKey );

    if ( gCurrentMenu == "" )
     llMessageLinked( LINK_THIS, lnkMenuShow, "MainMenu", gAVKey );
    else
     llMessageLinked( LINK_THIS, lnkMenuShow, "", gAVKey );
  }

  link_message( integer fSender, integer fNum, string fMsg, key fId )
  {
    if ( fNum == STREAM_STATUS_DATA )
    {
      gStatusList = llParseStringKeepNulls( ReplaceChars(fMsg), [ gFieldDelim ], [] );
      UpdateMessages( TRUE );
    }
    else if ( fNum == lnkDialogResponse )
     HandleMenuResponse( fMsg );
    else if ( fNum == lnkDialogTimeOut )
     dialogNotify( gAVKey, "Menu time-out. Please try again.");
  }

  listen( integer fChannel, string fName, key fId, string fMsg )
  {
    if ( llList2Key( llGetObjectDetails(llGetKey(),[OBJECT_GROUP]), 0) == llList2Key( llGetObjectDetails(fId,[OBJECT_GROUP]), 0) )
     TunerSync( llParseStringKeepNulls( fMsg, [gFieldDelim], [] ) );
  }

  changed(integer change)
  {
    if (change & CHANGED_OWNER)
    { state Restart; }
    else if (change & CHANGED_INVENTORY)
    { state Config; }
  }
}

state Restart
{
  state_entry()
  { llSetTimerEvent( 2 ); }

  timer()
  { state Work; }
}