//XEngine:lsl
/*
  ScriptName: TunerStatus_MV2.0
  Creator: Sixtus Majus
  Version: MV2.0
  Create Date: 11/06/2013
  Revision:
*/

// #### USER_SETTINGS BEGIN ####
// Nothing to configure here see config notecard
// #### USER_SETTINGS END ####

// Stream status
integer STREAM_STATUS_URL     = 22100; // The URL of the stream. Starts polling.
integer STREAM_STATUS_TIME    = 22101; // How often to check for a new song title
integer STREAM_STATUS_DATA    = 22103; // Status data send to board
integer STREAM_STATUS_DJONAIR = 22200; // Set DJ on Air

// Defaults
float   gCheckIntervall  = 20.0; // Check intervall in seconds
float   gDetailTimeOut   = 30.0; // Timeout of Detail Request in seconds

key     gHTTPIdStatus  = NULL_KEY;
key     gHTTPIdDetails = NULL_KEY;

string  gBody;
string  gCurrentSong;
string  gPreviousSong;

list    gDetailList;
list    gStatusList;

string  gURL;
string  gURLServer;
string  gURLDetails;
string  gURLStatus;
string  gURLType;

integer gRequestType;
integer gIsIceCastV2;

integer gTYPEDetails = 1;   // Request Type Details
integer gTYPEStatus  = 2;   // Request Type Status
string  gOFFLineMessage   = "Stream Server is offline.";
string  gOFFLineNAMessage = "Stream Server is offline or Stream Data not available.";

string  gSTREAMTypeSC1 = "SC1";
string  gSTREAMTypeSC2 = "SC2";
string  gSTREAMTypeIC2 = "IC2";

string  gFieldDelim  = "♢";

ParseURL( string fURL, string fStreamType )
{
  fURL = llStringTrim( llToLower(fURL), STRING_TRIM );
  fURL = osReplaceString( fURL, "http://", "", -1, 0 );
  fURL = osReplaceString( fURL, "index.html", "", -1, 0 );
  fURL = osReplaceString( fURL, "index.htm", "", -1, 0 );

  list    lParts     = llParseStringKeepNulls(fURL, [":","/"], []);
  string  lHost      = llList2String( lParts, 0 );
  string  lPort      = llList2String( lParts, 1 );
  gURLServer  = "http://" + lHost + ":" + lPort;
  gURLType = fStreamType;

  if ( fStreamType == gSTREAMTypeSC2 )
  {
    // Check for '?sid=#NO#' in parameter list
    integer lURLSC2StreamNo = -1;
    lParts = llParseStringKeepNulls(llList2String( lParts, 2 ), ["?"], []);
    lParts = llParseStringKeepNulls(llList2String( lParts, 1 ), ["="], []);
    if ( llList2String( lParts, 0 ) == "sid" )
     lURLSC2StreamNo = llList2Integer( lParts, 1 );
    else
     lURLSC2StreamNo = 1; // no sid=... given

    gURLDetails = gURLServer + "/index.html?sid=" + (string)lURLSC2StreamNo;
    gURLStatus  = gURLServer + "/stats?sid=" + (string)lURLSC2StreamNo;
  }
  else if ( fStreamType == gSTREAMTypeIC2 )
  {
    gURLDetails = ""; // Icecast don't have details
    gURLStatus  = gURLServer + "/status.xsl";
  }
  else // SHOUTCast V1
  {
    gURLDetails = gURLServer + "/index.html";
    gURLStatus  = gURLServer + "/7.html";
  }

}

HTTPRequest( integer fRequestType )
{
  gRequestType = fRequestType;

  if ( gURLType == gSTREAMTypeIC2 || gRequestType == gTYPEStatus )
  {
   llSetTimerEvent( gCheckIntervall ); // In case if fails
   gHTTPIdStatus = llHTTPRequest( gURLStatus, [HTTP_METHOD,"GET"],"");
   //llOwnerSay( "HTTPRequest(Status): " + gURLStatus );
  }
  else if ( gRequestType == gTYPEDetails )
  {
   llSetTimerEvent( gDetailTimeOut ); // In case if fails
   gHTTPIdDetails = llHTTPRequest( gURLDetails, [HTTP_METHOD,"GET", HTTP_BODY_MAXLENGTH, 100000],"" );
   //llOwnerSay( "HTTPRequest(Details): " + gURLDetails );
  }
}

string HTMLStrip( string fBody, string fDelimiter )
{
  integer lPosBegin = llSubStringIndex(fBody,"<");
  integer lPosEnd;

  if ( lPosBegin > -1 )
  {
    @Loop;

      lPosEnd = llSubStringIndex( llGetSubString(fBody,lPosBegin,-1) ,">");
      if ( lPosEnd < 0 )
       fBody = llGetSubString(fBody,0,lPosBegin-1);
      else
      {
        if (lPosBegin < 1)
        {
          if ((lPosEnd + lPosBegin + 1) < llStringLength(fBody) )
           fBody = fDelimiter + llGetSubString(fBody,lPosBegin+lPosEnd+1,-1);
          else
           fBody = fDelimiter;
        }
        else
        {
          if ((lPosEnd + lPosBegin + 1) < llStringLength(fBody))
           fBody = llGetSubString(fBody,0,lPosBegin-1) + fDelimiter + llGetSubString(fBody,lPosBegin+lPosEnd+1,-1);
          else
           fBody = llGetSubString(fBody,0,lPosBegin-1) + fDelimiter;
        }
      }

    if ( (lPosBegin = llSubStringIndex(fBody,"<")) > -1 ) jump Loop;
  }

  return( fBody );
}

// Get a value from status list with given status name
string  GetStatusValue( string fStatusName )
{
  integer lListIndex = llListFindList(gStatusList,[ "==" + fStatusName ]);

   if ( lListIndex >= 0 )
    return( llList2String(gStatusList,lListIndex + 1) );

   return( "" );
}

// Get a value from XML with given xml tag name
string GetXMLTagValue( string fXMLTag )
{
  string  lTagNameBegin = "<" + fXMLTag + ">";
  integer lTagBegin;
  integer lTagEnd;

  if (
       (lTagBegin = llSubStringIndex( gBody, lTagNameBegin )) >= 0 &&
       (lTagEnd   = llSubStringIndex( gBody, "</" + fXMLTag + ">")) >= 0
     )
   return( llGetSubString( gBody, lTagBegin + llStringLength(lTagNameBegin), lTagEnd - 1 ) );

  return( "" );
}

// Parse CURRENT_SONG and extract Artist and SongTitle
ParseCURRENT_SONG()
{
  string  lCurrentSong;
  integer lPos;
  string  lArtist;
  string  lSongTitle;

  // Find current song in status list
  if ( (lCurrentSong = GetStatusValue( "CURRENT_SONG" ) ) != "" )
  {
      // Correcting some strange text
      lCurrentSong = llStringTrim( osReplaceString( lCurrentSong, " - - ", " - ", 1, 0 ), STRING_TRIM );
      if ( (lPos = llSubStringIndex( lCurrentSong, "-" )) == 0 )
       lCurrentSong = llStringTrim( llGetSubString( lCurrentSong, 1, -1 ), STRING_TRIM );

      // Extract Artist / Song
      if ( (lPos = llSubStringIndex( lCurrentSong, " - " )) >= 0 )
      {
       lArtist    = llStringTrim( llGetSubString( lCurrentSong, 0, lPos - 1 ), STRING_TRIM );
       lSongTitle = llStringTrim( llGetSubString( lCurrentSong, lPos + 3, -1 ), STRING_TRIM );
      }
      else
      {
       lArtist    = lCurrentSong;
       lSongTitle = "-";
      }

      // Remove beginning minus sign if
      if ( lArtist != "-" && (lPos = llSubStringIndex( lArtist, "-" )) == 0 )
       lArtist = llStringTrim( llGetSubString( lArtist, 1, -1 ), STRING_TRIM );

      if ( lSongTitle != "-" && (lPos = llSubStringIndex( lSongTitle, "-" )) == 0 )
       lSongTitle = llStringTrim( llGetSubString( lSongTitle, 1, -1 ), STRING_TRIM );

  }
  else
   gPreviousSong = lArtist = lSongTitle = "n.a.";  // no song information avaiable

  gStatusList += [ "==CURRENT_SONG_ARTIST", lArtist ];
  gStatusList += [ "==CURRENT_SONG_TITLE",  lSongTitle ];

  // Save current / previous song
  if ( lCurrentSong != gCurrentSong )
  {
   gPreviousSong = gCurrentSong;
   gCurrentSong  = lCurrentSong;
  }

  if ( gPreviousSong == "" )
   gStatusList += [ "==PREVIOUS_SONG", "-" ];
  else
   gStatusList += [ "==PREVIOUS_SONG", gPreviousSong ];

}

integer ParseDETAILS( string fBody )
{
  fBody = osReplaceString( fBody, "Current Song:", "", -1, 0 );
  list    lDetailList    = llParseString2List(HTMLStrip(fBody,gFieldDelim),[ gFieldDelim ], []);
  integer lDetailListLen = llGetListLength(lDetailList);
  integer li;
  string  lName;
  string  lValue;
  integer lServerStatus;
  string  lStreamAim;
  string  lStreamIRC;

  gDetailList = [];

  if ( lDetailListLen > 0 )
  {
    @Loop;

     lName  = llStringTrim(llList2String(lDetailList,li),STRING_TRIM);
     lValue = llStringTrim(llList2String(lDetailList,li + 1),STRING_TRIM);

     if (lName == "Server Status:")
      lServerStatus =  ( llSubStringIndex( llToLower(lValue), "currently up" ) >= 0 );
     else if (lName == "Average Listen Time:")
      gDetailList += [ "==AVERAGE_LISTEN_TIME", lValue ];
     else if (lName == "Stream Title:")
      gDetailList += [ "==STREAM_TITLE", lValue ];
     else if (lName == "Content Type:")
      gDetailList += [ "==CONTENT_TYPE", lValue ];
     else if (lName == "Stream Genre:")
      gDetailList += [ "==STREAM_GENRE", lValue ];
     else if (lName == "Stream URL:")
      gDetailList += [ "==STREAM_URL", lValue ];
     else if (lName == "Stream AIM:")
      lStreamAim = lValue;
     else if (lName == "Stream IRC:")
      lStreamIRC = lValue;

    if ( (++li) < lDetailListLen ) jump Loop;
  }

  if ( lStreamAim == "" || lStreamAim == "NA" || lStreamAim == "N/A" )
   lStreamAim = "-";

  if ( lStreamIRC == "" || lStreamIRC == "NA" || lStreamIRC == "N/A" || lStreamIRC == "#NA" )
   lStreamIRC = "-";

  gDetailList += [ "==STREAM_AIM", lStreamAim ];
  gDetailList += [ "==STREAM_IRC", lStreamIRC ];
  gDetailList += [ "==STREAM_IRC_SAMPLERATE", lStreamIRC ];
  
  // Set DJ on air picture
  llMessageLinked(LINK_THIS,STREAM_STATUS_DJONAIR, lStreamAim, NULL_KEY);

  gDetailList += ["==X_STREAM_URL", gURLServer ];

  return( lServerStatus );
}

integer ParseSTAT_Standard()
{
  list statList = llCSV2List( HTMLStrip(gBody,"") );
  if (llGetListLength(statList) < 7) return( FALSE );

  integer lBitRate = llList2Integer(statList,5);

  gStatusList = [];

  gStatusList += [ "==STREAM_STATUS", "" + (string)lBitRate + "Kbps " + 

                   llList2Integer(statList,5) + " of " + llList2String(statList,3) +
                   " Listener ("+llList2String(statList,0)+" Unique)"
                ];
  gStatusList += [ "==LISTENER_PEAK", llList2String(statList,2) ];
  gStatusList += [ "==CURRENT_SONG", llList2String(statList,6) ];
  
  gStatusList += [ "==STREAM_UPTIME_IC2", "-" ];

  ParseCURRENT_SONG();

  return( (lBitRate > 0) );
}

integer ParseSTAT_ShoutcastV2()
{
  integer lBitRate = (integer)GetXMLTagValue( "BITRATE" );

  gStatusList = [];

  gStatusList += [ "==STREAM_TITLE",       GetXMLTagValue( "SERVERTITLE" ) ];
  gStatusList += [ "==CURRENT_SONG",       GetXMLTagValue( "SONGTITLE" ) ];
  gStatusList += [ "==STREAM_GENRE",       GetXMLTagValue( "SERVERGENRE" ) ];
  gStatusList += [ "==STREAM_URL",         GetXMLTagValue( "SERVERURL" ) ];
  gStatusList += [ "==CONTENT_TYPE",       GetXMLTagValue( "CONTENT" ) ];
  gStatusList += [ "==STREAM_STATUS",      (string)lBitRate + "Kbps " + 
                                           GetXMLTagValue( "CURRENTLISTENERS" ) +
                                           " of "+ GetXMLTagValue( "MAXLISTENERS" )+
                                           " Listener (" + GetXMLTagValue( "UNIQUELISTENERS" ) + " Unique)"
                ];

  gStatusList += [ "==STREAM_UPTIME_IC2", "-" ];


  ParseCURRENT_SONG();

  return( (lBitRate > 0) );
}

integer ParseSTAT_IceCastV2()
{
  string  lBody;
  integer lPosIndex;

  // Get body part of Mount Point: /stream
  if ( (lPosIndex = llSubStringIndex(gBody,"Stream Title:")) >= 0 )
  {
   lBody = "<tr><td>" + llGetSubString(gBody,lPosIndex,-1);
   if ( (lPosIndex = llSubStringIndex(lBody,"</table>")) > 0 )
    lBody = llGetSubString(lBody,0,lPosIndex-1);
   else
    return( FALSE );

   lBody = osReplaceString( lBody, "\n", "", -1, 0 );
   
   if ( llStringLength( lBody ) > 5000 ) // something went wrong if body is to long
    return( FALSE );
  }

  list    lDetailList    = llParseString2List(HTMLStrip(lBody,gFieldDelim),[gFieldDelim], []);
  integer lDetailListLen = llGetListLength(lDetailList);
  integer li;
  string  lName;
  string  lValue;
  string  lCurrentListener;
  integer lStreamBitrate;
  string  lStreamSamplerate;
  string  lStreamUpTime;

  gStatusList = [];

  if ( lDetailListLen > 0 )
  {
    @Loop;

     lName  = llStringTrim(llList2String(lDetailList,li),STRING_TRIM);
     lValue = llStringTrim(llList2String(lDetailList,li + 1),STRING_TRIM);

     if (lName == "Stream Title:")
      gStatusList += [ "==STREAM_TITLE", lValue ];
     else if (lName == "Content Type:")
      gStatusList += [ "==CONTENT_TYPE", lValue ];
     else if (lName == "Stream Genre:")
      gStatusList += [ "==STREAM_GENRE", lValue ];
     else if (lName == "Stream URL:")
      gStatusList += [ "==STREAM_URL", lValue ];
     else if (lName == "Peak Listeners:")
      gStatusList += [ "==LISTENER_PEAK", lValue ];
     else if (lName == "Current Song:")
      gStatusList += [ "==CURRENT_SONG", lValue ];
     else if (lName == "Current Listeners:")
     {
      gStatusList += [ "==CURRENT_LISTENERS", lValue ];
      lCurrentListener = lValue;
     }
     else if ( lName == "Bitrate:" || lName == "ice-bitrate:" )
     {
      gStatusList += [ "==STREAM_BITRATE", lValue ];
      lStreamBitrate = (integer)lValue;
     }
     else if (lName == "Mount Uptime:")
      lStreamUpTime = lValue;
     else if (lName == "ice-samplerate:")
      lStreamSamplerate = lValue;

    if ( (++li) < lDetailListLen ) jump Loop;
  }

  gStatusList += [ "==STREAM_IRC", "-" ];
  gStatusList += [ "==STREAM_AIM", "-" ];
  
  if ( lStreamUpTime == "" ) lStreamUpTime = "-";
  gStatusList += [ "==STREAM_UPTIME_IC2", lStreamUpTime ]; 
  if ( lStreamSamplerate == "" ) lStreamSamplerate = "-";  
  gStatusList += [ "==STREAM_IRC_SAMPLERATE", lStreamSamplerate ]; 

  gStatusList += [ "==STREAM_STATUS", (string)lStreamBitrate + " Kbps" +
                   " " + lCurrentListener + " Listener "] ;

  gStatusList += [ "==X_STREAM_URL", gURLServer ];

  ParseCURRENT_SONG();

  return( (lStreamBitrate > 0) );
}

MsgToBoard( string lMsg )
{
  gStatusList =  [ "==STREAM_TITLE", lMsg ];
  gStatusList += [ "==STREAM_URL", gURLServer ];
  llMessageLinked(LINK_THIS,STREAM_STATUS_DATA, llDumpList2String(gStatusList,gFieldDelim),NULL_KEY);
}

default
{
  state_entry()
  {}

  link_message( integer fSender, integer fNum, string fMsg, key fId )
  {
    if ( fNum == STREAM_STATUS_URL )
    {
      llSetTimerEvent(0.0);
      gHTTPIdStatus  = NULL_KEY;
      gHTTPIdDetails = NULL_KEY;      
      gBody          = "";
      gDetailList    = [];
      gStatusList    = [];
      gCurrentSong   = "";
      gPreviousSong  = "";
                    
      list lData = llParseStringKeepNulls( fMsg, gFieldDelim, []);
      gURL = llList2String( lData, 0 );
      gURLType = llToUpper(llList2String( lData, 1 ));
      
      if ( gURL != "" )
      {
       ParseURL( gURL, gURLType );
       MsgToBoard( "Connecting to Stream Server..." );
       HTTPRequest( gTYPEDetails );
      }
    }
    else if ( fNum == STREAM_STATUS_TIME )
     gCheckIntervall = (float)fMsg;
  }

  http_response(key fId, integer fStatus, list metadata, string fBody )
  {
    integer lStatus;

    //llOwnerSay( "http_response(" + (string)fStatus + "): " + fBody );
    llSetTimerEvent(0);

    if ( gHTTPIdDetails == NULL_KEY && gHTTPIdStatus == NULL_KEY ) return;

    lStatus = ( fStatus == 200 && llSubStringIndex(fBody,"ERROR") < 0 );

    if ( lStatus )
    {
      if (fId == gHTTPIdStatus)
      {
        gHTTPIdStatus = NULL_KEY;

        if ( gBody == "" || fBody != gBody ) // do nothing if unchanged
        {
          gBody = fBody;
          if ( gURLType == gSTREAMTypeIC2 ) // Icecast V2
           lStatus = ParseSTAT_IceCastV2();
          else if ( gURLType == gSTREAMTypeSC2 ) // Shoucast V2
           lStatus = ParseSTAT_ShoutcastV2();
          else                              // Standard Status
           lStatus = ParseSTAT_Standard();

          if ( lStatus )
           llMessageLinked(LINK_THIS,STREAM_STATUS_DATA, llDumpList2String(gDetailList + gStatusList,gFieldDelim),NULL_KEY);
          else
          {
           if ( gURLType == gSTREAMTypeIC2 ) // Icecast V2
            MsgToBoard( gOFFLineNAMessage );
           else
            MsgToBoard( gOFFLineMessage );
          }

          gStatusList = [];
        }
      }
      else if (fId == gHTTPIdDetails)
      {
        gHTTPIdDetails = NULL_KEY;
        gBody = "";
        if ( ParseDETAILS( fBody ) )
         HTTPRequest( gTYPEStatus );
        else
         MsgToBoard( gOFFLineMessage );
      }
    }
    else
    {
     gRequestType = gTYPEDetails;
     MsgToBoard( fBody );
    }

    llSetTimerEvent( gCheckIntervall );
  }

  timer()
  {
   llSetTimerEvent(0);
   HTTPRequest( gRequestType ); // call the current request
  }
}