//
//  Slot Machine 
//

integer bet_amount = 0;
key bettor;
string ownername;
integer waitingforcommand = FALSE;
integer lit = FALSE;
integer not_registered = TRUE;
integer owner_listen;
integer wheel1_score;
integer wheel2_score; 
integer wheel3_score;

float sound_volume = 1.000000;

integer PAYOUT_THREEBAR = 5;
integer PAYOUT_THREESAME = 3;
integer PAYOUT_TWOBAR = 2;
integer PAYOUT_TWOSAME = 1;
integer PAYOUT_ONEBAR = 0;

integer MIN_BET = 10;
integer MAX_BET = 100;
integer MAX_PAYOUT_BEFORE_RESET = 700;
integer needs_reset = FALSE;
integer in_play = FALSE;

integer ringer_countdown = 0; 
 
integer num_plays = 0; 
integer amount_bet = 0; 
integer amount_paid = 0;

display_payouts(integer isowner)
{
    integer PO2 = 10 * PAYOUT_TWOSAME;
    integer PO3 = 10 * PAYOUT_THREESAME;
    integer PO1B = 10 * PAYOUT_ONEBAR;
    integer PO2B = 10 * PAYOUT_TWOBAR;
    integer PO3B = 10 * PAYOUT_THREEBAR;
    if ((isowner) || (PAYOUT_THREEBAR > 0)) llWhisper(0, "Three BARS: x" + (string)PAYOUT_THREEBAR + " ($10 Bet = $" + (string)PO3B + ")");
    if ((isowner) || (PAYOUT_THREESAME > 0)) llWhisper(0, "Three Same: x" + (string)PAYOUT_THREESAME + " ($10 Bet = $" + (string)PO3 + ")");
    if ((isowner) || (PAYOUT_TWOBAR > 0)) llWhisper(0, "Two BARS: x" + (string)PAYOUT_TWOBAR + " ($10 Bet = $" + (string)PO2B + ")");
    if ((isowner) || (PAYOUT_TWOSAME > 0)) llWhisper(0, "Two Same: x" + (string)PAYOUT_TWOSAME + " ($10 Bet = $" + (string)PO2 + ")");
    if ((isowner) || (PAYOUT_ONEBAR > 0)) llWhisper(0, "One BAR: x" + (string)PAYOUT_ONEBAR + " ($10 Bet = $" + (string)PO1B + ")");
}

default
{
    state_entry()
    {
        owner_listen = llListen(0,"",llGetOwner(),"");
        llWhisper(0, "Left-Click on the Slot Machine to register/activate it.");
        llStopSound();
    }
    
    on_rez(integer start_param)
    {
        integer perm = llGetPermissions();
        if ((llKey2Name(llGetOwner()) != ownername) || (not_registered == TRUE) || ((perm & PERMISSION_DEBIT) != PERMISSION_DEBIT))
        {
            state resetslotmachine;
        }
    }
    
    run_time_permissions(integer type)
    {
        if (type == PERMISSION_DEBIT)
        {
            llWhisper(0, "New Slot Machine registered to " + ownername);
            not_registered = FALSE;
            llGiveInventory(llGetOwner(), "Slot Machine Help");
        }
    }
    
    touch_start(integer total_number)
    {
        if (((llDetectedKey(0) == llGetOwner()) && (llDetectedName(0) != ownername)) || ((llDetectedKey(0) == llGetOwner()) && (not_registered == TRUE)))
        {
            ownername = llKey2Name(llGetOwner());
            llRequestPermissions(llGetOwner(), PERMISSION_DEBIT);
            //llWhisper(0, "Requesting debit permission from owner: " + ownername);
        }
        else
        {
            if (llGetOwner() == llDetectedKey(0))
            {
                waitingforcommand = TRUE;
                llWhisper(0, "Waiting For Command...");
            }
            else
            {
                if (!needs_reset)
                {
                    llTriggerSound("switch", sound_volume);
                    llWhisper(0, "Right-Click And 'Pay' To Play."); 
                    llWhisper(0, "Min Bet: $" + (string)MIN_BET);
                    llWhisper(0, "Max Bet: $" + (string)MAX_BET);
                    llWhisper(0, " "); 
                    llWhisper(0, "WINNING PAYOUTS:");
                    display_payouts(FALSE);
                }
                else
                {
                    llWhisper(0, "This machine is currently down for servicing");
                }
            }
        }
    }
    
    money(key giver, integer amount)
    {
        if (not_registered == TRUE)
        {
            llWhisper(0, "This machine has not been activated. Please contact the owner for a refund.");
            return;
        }
        if (in_play)
        {
            llWhisper(0, "Another bet is in play");
            llGiveMoney(giver, amount);
            return;
        }
        if ((amount > MAX_BET) || (amount < MIN_BET))
        {
            llWhisper(0, "Min bet is $" + (string)MIN_BET);
            llWhisper(0, "Max bet is $" + (string)MAX_BET);
            llGiveMoney(giver, amount);
            return;
        }
        else
        {
            if (!needs_reset)
            {
                llWhisper(0, "$" + (string)amount + " bet!");
                bet_amount = amount;
                bettor = giver;
                wheel1_score = 0;
                wheel2_score = 0;
                wheel3_score = 0;
                in_play = TRUE;
                llMessageLinked(2,0,"Spin", "");
                llMessageLinked(3,0,"Spin", "");
                llMessageLinked(4,0,"Spin", "");
                llTriggerSound("handle", sound_volume);
                num_plays++;
                amount_bet += amount;
            }
            else
            {
                llWhisper(0, "This machine is currently down for servicing");
                llGiveMoney(giver, amount);
            }
        }
    }
    
    link_message(integer sender_num, integer num, string str, key id)
    {
        //
        //  Accumulate wheel scores 
        //  
        if (num == 1)
        {
            wheel1_score = (integer)str;
        }
        else if (num == 2)
        {
            wheel2_score = (integer)str;
        }
        else if (num == 3)
        {
            wheel3_score = (integer)str;
        }
        //
        //  Done spinning? 
        //
        if ((wheel1_score > 0) && (wheel2_score > 0) && (wheel3_score > 0)) 
        {
            // 
            //  Compute score 
            // 
            integer three_bar = FALSE;
            integer two_bar = FALSE;
            integer one_bar = FALSE;
            integer three_same = FALSE;
            integer two_same = FALSE;
                
            integer score;
            score = wheel1_score + wheel2_score + wheel3_score;

            if ((score == 3) && (PAYOUT_THREEBAR > 0)) three_bar = TRUE;
            else if (((wheel1_score == wheel2_score) && 
                (wheel2_score == wheel3_score)) && (PAYOUT_THREESAME > 0)) three_same = TRUE;
            else if ((((wheel1_score == 1) && (wheel2_score == 1)) ||
                ((wheel1_score == 1) && (wheel3_score == 1)) ||
                ((wheel2_score == 1) && (wheel3_score == 1))) && (PAYOUT_TWOBAR > 0)) two_bar = TRUE;
            else if (((wheel1_score == wheel2_score) || 
                (wheel2_score == wheel3_score) || 
                (wheel3_score == wheel1_score)) && (PAYOUT_TWOSAME > 0)) two_same = TRUE;
            else if (((wheel1_score == 1) || 
                (wheel2_score == 1) ||
                (wheel3_score == 1)) && (PAYOUT_ONEBAR > 0)) one_bar = TRUE;                                
            //
            //  Compute payout 
            //
            integer payout = 0;
            
            if (three_bar)
            {
                payout = PAYOUT_THREEBAR;
                ringer_countdown = 12;
            }
            else if (three_same)
            {
                payout = PAYOUT_THREESAME;
                ringer_countdown = 12;
            }
            else if (two_bar)
            {
                payout = PAYOUT_TWOBAR;
                ringer_countdown = 3;
            }
            else if (two_same)
            {
                payout = PAYOUT_TWOSAME;
                ringer_countdown = 3;
            }
            else if (one_bar)
            {
                payout = PAYOUT_ONEBAR;
                ringer_countdown = 1;
            }
            
            if ((bet_amount > 0) && (payout > 0))
            {
                //llMessageLinked(5,0,"Flash", "");
                llTriggerSound("payout", sound_volume);
                llTriggerSound("bell", sound_volume);
                llGiveMoney(bettor, bet_amount * payout);
                llWhisper(0, "Winner! $" + (string) (bet_amount * payout));
                amount_paid += (bet_amount * payout);
                if (amount_paid > MAX_PAYOUT_BEFORE_RESET)
                {
                    needs_reset = TRUE;
                    vector mypos = llGetPos();
                    llInstantMessage(llGetOwner(), "Max Payout Has Been Reached! (" + llGetRegionName() + " " + (string)llRound(mypos.x) + ", " + (string)llRound(mypos.y) + ")");
                }
            }
            else
            {
                //
                //  No win - play sound 
                //
                llWhisper(0, "Thanks for playing!");
                llTriggerSound("no_win", sound_volume);
            }
            in_play = FALSE;
            bet_amount = 0;
        }
    }
    
    listen(integer channel, string name, key id, string message)
    {
        if (waitingforcommand == TRUE)
        {
            list said = llParseString2List(message, [" "], []);
            if (llToLower(llList2String(said, 0)) == "slot")
            {
                waitingforcommand = FALSE;
                if (llToLower(llList2String(said, 1)) == "help")
                {
                    llGiveInventory(llGetOwner(), "Slot Machine Help");
                }
                else if (llToLower(llList2String(said, 1)) == "stats")
                {
                    llWhisper(0, "Number Of Plays: " + (string)num_plays);
                    llWhisper(0, "Total Amount Bet: $" + (string)amount_bet);
                    llWhisper(0, "Total Amount Paid: $" + (string)amount_paid);
                    integer amount_profit = amount_bet - amount_paid;
                    llWhisper(0, "Total Profit Amount: $" + (string)amount_profit);
                }
                else if (llToLower(llList2String(said, 1)) == "settings")
                {
                    llWhisper(0, "Min Bet: $" + (string)MIN_BET);
                    llWhisper(0, "Max Bet: $" + (string)MAX_BET);
                    llWhisper(0, "Max Payout Before Reset: $" + (string)MAX_PAYOUT_BEFORE_RESET);
                    llWhisper(0, " ");
                    llWhisper(0, "Sound Volume: " + (string)sound_volume);
                    llWhisper(0, " ");
                    llWhisper(0,"PAYOUTS:");
                    display_payouts(TRUE);
                }
                else if (llToLower(llList2String(said, 1)) == "reset")
                {
                    needs_reset = FALSE;
                    in_play = FALSE;
                    num_plays = 0;
                    amount_bet = 0;
                    amount_paid = 0;
                    llWhisper(0, "The Slot Machine Has Been Reset");
                }
                else if (llToLower(llList2String(said, 1)) == "set")
                {
                    if (llToLower(llList2String(said, 2)) == "volume")
                    {
                        sound_volume = llList2Float(said, 3);
                        llMessageLinked(2,0,"Volume " + (string)sound_volume, "");
                        llMessageLinked(3,0,"Volume " + (string)sound_volume, "");
                        llMessageLinked(4,0,"Volume " + (string)sound_volume, "");
                        llWhisper(0, "Sound Volume Has Been Set To " + (string)sound_volume);
                    }
                    else if (llToLower(llList2String(said, 2)) == "payout:twosame")
                    {
                        PAYOUT_TWOSAME = llList2Integer(said, 3);
                        integer PO2 = 10 * PAYOUT_TWOSAME;
                        llWhisper(0, "Two Same Payout Has Been Set To x" + (string)PAYOUT_TWOSAME + " ($10 Bet = $" + (string)PO2 + ")");
                    }
                    else if (llToLower(llList2String(said, 2)) == "payout:threesame")
                    {
                        PAYOUT_THREESAME = llList2Integer(said, 3);
                        integer PO3 = 10 * PAYOUT_THREESAME;
                        llWhisper(0, "Three Same Payout Has Been Set To x" + (string)PAYOUT_THREESAME + " ($10 Bet = $" + (string)PO3 + ")");
                    }
                    else if (llToLower(llList2String(said, 2)) == "payout:onebar")
                    {
                        PAYOUT_ONEBAR = llList2Integer(said, 3);
                        integer PO1B = 10 * PAYOUT_ONEBAR;
                        llWhisper(0, "One Bar Payout Has Been Set To x" + (string)PAYOUT_ONEBAR + " ($10 Bet = $" + (string)PO1B + ")");
                    }
                    else if (llToLower(llList2String(said, 2)) == "payout:twobars")
                    {
                        PAYOUT_TWOBAR = llList2Integer(said, 3);
                        integer PO2B = 10 * PAYOUT_TWOBAR;
                        llWhisper(0, "Two Bars Payout Has Been Set To x" + (string)PAYOUT_TWOBAR + " ($10 Bet = $" + (string)PO2B + ")");
                    }
                    else if (llToLower(llList2String(said, 2)) == "payout:threebars")
                    {
                        PAYOUT_THREEBAR = llList2Integer(said, 3);
                        integer PO3B = 10 * PAYOUT_THREEBAR;
                        llWhisper(0, "Three Bars Payout Has Been Set To x" + (string)PAYOUT_THREEBAR + " ($10 Bet = $" + (string)PO3B + ")");
                    }
                    else if (llToLower(llList2String(said, 2)) == "minbet")
                    {
                        MIN_BET = llList2Integer(said, 3);
                        llWhisper(0, "Min Bet Has Been Set To $" + (string)MIN_BET);
                    }
                    else if (llToLower(llList2String(said, 2)) == "maxbet")
                    {
                        MAX_BET = llList2Integer(said, 3);
                        llWhisper(0, "Max Bet Has Been Set To $" + (string)MAX_BET);
                    }
                    else if (llToLower(llList2String(said, 2)) == "maxpayout")
                    {
                        MAX_PAYOUT_BEFORE_RESET = llList2Integer(said, 3);
                        llWhisper(0, "Max Payout Before Reset Has Been Set To $" + (string)MAX_PAYOUT_BEFORE_RESET);
                    }
                }
            }
        }
    }
}

state resetslotmachine
{
    state_entry()
    {
        waitingforcommand = FALSE;
        lit = FALSE;
        not_registered = TRUE;

        PAYOUT_THREEBAR = 10;
        PAYOUT_THREESAME = 5;
        PAYOUT_TWOBAR = 3;
        PAYOUT_TWOSAME = 2;
        PAYOUT_ONEBAR = 0;

        sound_volume = 1.000000;

        MIN_BET = 1;
        MAX_BET = 100;
        MAX_PAYOUT_BEFORE_RESET = 1000;
        needs_reset = FALSE;
        in_play = FALSE;

        ringer_countdown = 0; 
 
        num_plays = 0; 
        amount_bet = 0; 
        amount_paid = 0;
        
        llMessageLinked(2,0,"Volume " + (string)sound_volume, "");
        llMessageLinked(3,0,"Volume " + (string)sound_volume, "");
        llMessageLinked(4,0,"Volume " + (string)sound_volume, "");
        
        llListenRemove(owner_listen);
        
        state default;
    }
} 