/* ******************************************************************************************************************************
  File: Game GreedyZilch V2
  Author: Seth Nygard @ osgrid
  Date:   2014-06-25

  A simple sit handler, with modifications for Greedy Zilch game table
****************************************************************************************************************************** */
vector    gPosition    = <0.1, 0.3, 0.65>;
vector    gRotation    = <0.0, 0.0, 67.5>;
string    gAnimName    = "";
integer   gUsed        = FALSE;
key       gUser        = NULL_KEY;
integer   gSeatNumber  = -1;
string    SIT_JOIN     = "SIT_JOIN";
string    SIT_LEAVE    = "SIT_LEAVE";
string    SIT_STATE    = "SIT_STATE";
string    CMD_RESET    = "CMD_RESET";
string    CMD_EJECT    = "CMD_EJECT";
string    CMD_SITCHECK = "CMD_SITCHECK";


Init()
{
  gSeatNumber = (integer)llGetSubString( llGetObjectDesc(), 1, 1);
  gAnimName = llGetInventoryName(INVENTORY_ANIMATION,0);
}


DoAnimation( string AnimName )
{
  llStopAnimation("sit");
  llStopAnimation(AnimName);
  llSleep(0.05);
  llStartAnimation(AnimName);
}


HandleChange()
{
  key prevAvatar = gUser;
  if(!gUsed) {
      gUser = llAvatarOnSitTarget();
      gUsed = (gUser != NULL_KEY);
      llRequestPermissions(gUser,PERMISSION_TRIGGER_ANIMATION);
  } else {
      gUser = llAvatarOnSitTarget();
      if ( gUser != prevAvatar && prevAvatar != NULL_KEY )
         llMessageLinked( LINK_ROOT, 0, SIT_LEAVE, prevAvatar );
      if (gUser==NULL_KEY) {
        llStopAnimation(gAnimName);
        gUser = NULL_KEY;
        gUsed = FALSE;
      }
  }
}


default
{
    state_entry()
    {
        llSitTarget(gPosition,llEuler2Rot(gRotation*DEG_TO_RAD));
        Init();
        if(gAnimName == "") {
            state ERROR;
        } else {
            state IDLE;
        }
    }
}


state IDLE
{
    link_message(integer sender_number, integer number, string message, key id)
    {
        list msgParts = llParseString2List( message, [" "], [] );
        string cmd = llList2String( msgParts, 0 );

        if( cmd == CMD_SITCHECK ){
            llMessageLinked( LINK_ROOT, 100+gSeatNumber, SIT_STATE+" "+(string)gUsed, gUser );
        }else if( cmd == CMD_RESET ){
            if( gUser != NULL_KEY ) {
                llUnSit(gUser);
            }
            llResetScript();
        }
    }


    changed(integer change)
    {
        if (change & CHANGED_LINK) {
            HandleChange();
        }

        if(change & CHANGED_INVENTORY) {
            llResetScript(); // Reset the script if the inventory has changed.
        }
    }

    run_time_permissions(integer perm) {
        if(perm & PERMISSION_TRIGGER_ANIMATION) {
            DoAnimation(gAnimName);
            llMessageLinked( LINK_ROOT, 100+gSeatNumber, SIT_JOIN+" "+(string)gSeatNumber, gUser );
            state ACTIVE;
        }
    }
}


state ACTIVE
{

    link_message(integer sender_number, integer number, string message, key id)
    {
        list msgParts = llParseString2List( message, [" "], [] );
        string cmd = llList2String( msgParts, 0 );

        if( cmd == CMD_SITCHECK ){
            llMessageLinked( LINK_ROOT, 100+gSeatNumber, SIT_STATE+" "+(string)gUsed, gUser );
        }else if( cmd == CMD_RESET ){
            if( gUser != NULL_KEY ) {
                llUnSit(gUser);
            }
            llResetScript();
        }else if( cmd == CMD_EJECT ){
            if( gUser != NULL_KEY ) {
                llUnSit(gUser);
            }
        }
    }

    changed(integer change)
    {
        if (change & CHANGED_LINK) {
            HandleChange();
            if(!gUsed)
               state IDLE;
        }

        if(change & CHANGED_INVENTORY) {
            llResetScript(); // Reset the script if the inventory has changed.
        }
    }

    run_time_permissions(integer perm)
    {
        if(perm & PERMISSION_TRIGGER_ANIMATION) {
            DoAnimation(gAnimName);
        }
    }
}


state ERROR
{
    state_entry()
    {
        llOwnerSay("Sorry, no animation was found.");
    }

    changed(integer change)
    {
        if(change & CHANGED_INVENTORY) {
            llOwnerSay("re-initializing");
            llResetScript();
        }
    }
}