//XEngine:lsl
/*
  ScriptName: TunerDJOnAir_MV1.0
  Creator: Sixtus Majus
  Version: MV1.0
  Create Date: 11/04/2013
  Revision:
*/

// #### USER_SETTINGS BEGIN ####

integer gDJOnAirTexturePrimFace   = 3;                  // Prim face to display the texture
string  gDJOnAirPrimName          = "DJOnAir";          // The Prim name to display the texture
string  gDJOnAirTextureNamePrefix = "Tuner_DJOnAir_";   // The Texture name(Prefix)
string  gDJOnAirTextureDefault    = "Default";          // The Texture name(Suffix) if no texture is found

// #### USER_SETTINGS END ####

string  gDJOnAirNameDEFAULT;
string  gDJOnAirName;
integer gDJOnAirLinkNo;

integer STREAM_STATUS_DJONAIR = 22200; // DJ on Air

SetDJOnAir()
{
  if ( gDJOnAirLinkNo == -1 ) return;

  string lTextureName = gDJOnAirTextureNamePrefix + gDJOnAirName;

  if ( llGetInventoryType( lTextureName ) == INVENTORY_NONE )
  {
    if ( llGetInventoryType( gDJOnAirNameDEFAULT ) == INVENTORY_NONE )
     lTextureName = TEXTURE_BLANK;
    else
     lTextureName = gDJOnAirNameDEFAULT;
  }

  llSetLinkTexture( gDJOnAirLinkNo, lTextureName, gDJOnAirTexturePrimFace );
}

LinkNoFind()
{
  integer lLinkedPrims = llGetNumberOfPrims();
  string  lLinkName;
  integer lLinkNo = 2;

  gDJOnAirLinkNo = -1;

  if ( lLinkedPrims < 2 ) return;
  @Loop;

   lLinkName = llToLower(llGetLinkName(lLinkNo));

   if ( lLinkName == llToLower(gDJOnAirPrimName) )
    gDJOnAirLinkNo = lLinkNo;

  if ( ++lLinkNo <= lLinkedPrims ) jump Loop;
}

Reset()
{
  LinkNoFind();
  gDJOnAirNameDEFAULT = gDJOnAirTextureNamePrefix + gDJOnAirTextureDefault;
}

default
{
  state_entry()
  { Reset(); }

  link_message(integer sender, integer num, string message, key id)
  {
    if (num == STREAM_STATUS_DJONAIR)
    {
      gDJOnAirName = message;
      SetDJOnAir();
    }
  }

  changed(integer change)
  {
    if (change & CHANGED_LINK) { LinkNoFind(); }
    if (change & CHANGED_INVENTORY) { SetDJOnAir(); }
  }
}