key     TRANSPARENT     = "b5fc01f6-2b4a-4e42-855d-6872ea360aae";

list    CHARACTER_GRID  = ["5051e617-e7ed-4239-823e-0a37961de44d","4eea18ba-d099-4ae3-bddf-342ba245c28c","1d1fe3ae-b49d-4286-b920-f90754878faa","1e8a804b-8f69-42e2-8ecd-2b54ab57f06d","769da83a-296b-4866-b7ae-5fac46ccdefa","88667afc-3046-475f-8fc8-f311cd161677","70a1a2a8-683d-496b-8fc8-995ac01ab155","ef50a6da-3776-4558-bdc9-b2afa619701f","b8b32073-42f0-487b-bfeb-8b51a8f4addf","42919db0-ca2c-43a6-8192-18326efeefc2","774e17b0-6d21-48c4-a702-919870aae20a","68725957-93b4-4b50-8947-348a8e9f8cfa","2cb35ff9-80f6-4584-b80c-934b18ced081","9cdc8bf0-5c31-465a-998a-2b17970bbdf1","0063f252-6f46-41c1-be18-caa9634af070","f093402c-39ef-44b4-a062-7f7956f2f19e","55728875-66b7-4eea-8a4a-9f697738fad8","55febbe7-4904-41fc-9807-09cda12e72ae","f6f5181e-4ca0-4fec-b29a-7fa639745deb","0d9eea9d-0043-486f-ba46-c36576798006","4b7b95a6-a24e-4076-ad10-436760c99c98","29e3ecd4-c607-403d-817a-a1eb6b2a7873","50469d2e-b6c2-4c50-9835-c63cebb7f71c","c27a83e7-1b69-47a1-9a9e-c26f6640662a","90a06661-e6da-4d3a-b64c-9bf3c5f1203e","cc439e14-5003-4868-8e87-392214d56626","08af3bc7-3e5e-4a66-98e2-3c84c00b99d5","89891e48-ef70-4f84-9cc4-9bb5788396d5","be53061d-08f8-4538-85b8-57bdf6f42f50","049f3024-3dad-4f91-87db-21e82ada00a2","212156f1-b8ad-47fa-a143-ea5548820112","d2c63c71-3b7d-4a6e-8223-bef98f5ce97c","8e4a6f7d-e92f-451f-b1d6-2e8cab186ce2","9b2711d5-f0a6-4ce1-b419-e07dbd3568bf","3acda0f1-0420-4386-aa31-3ac1ecadfdcc","db38cc84-db09-464a-aab6-ca93921c9f47","50414d73-eac5-44ca-a816-5049f5e87869","8153fe4a-0c6b-4bdc-bb85-2e2c091bfab4","4b9421e4-ef68-4aa9-8dc5-9024786d315b","46a6854e-98ff-48f2-91f9-5f0dfdb11ef9","e9589e63-f2e1-40da-ad09-27c9b5a9b88a","1b1eca43-d41a-4af1-b345-cda7f6a62d8a","f0953302-adf2-499d-b0b5-df6cb9844e7c","ca39e990-84dc-4860-9041-d80917a5df8c","8d615593-0c91-413c-90f0-16cabbffda22","439314d1-d535-4f12-9a99-3ef4f8c6ad53","b7d33ba6-ae2d-4da8-8b7b-fa547569d44c","4afed66b-4820-4f07-9805-df1c8be0b6e1","7ca90368-3d7d-4678-9544-e5389a3e922a","20b43f4f-c5ce-42f6-a4d7-79b24678110b","fdeb9c73-e872-4186-920a-ba3bf5c01e50","ef753bb0-7baa-43ac-a680-354b51d0d199","565e97bb-723b-4b0b-811e-83737903a9b7","05c37788-79f4-4a92-ab48-8e6cfd1581a7","15d7dbca-b0d3-4b9a-ae9e-5f9cdda1a6d5","184f2baa-bc5e-4d06-a5ad-08279dd6951a","4b5f4927-8607-43ce-8a02-b848662fd5e7","9ac1cfb9-8142-4443-bfbb-49c5abe8f0e1","748e44d1-c28c-4af3-b27a-30a7b0913955","96d9e77b-fb49-4356-a756-0df4d4200334","2987060d-3595-407f-9b97-e8ceb42f5f23","88a2cb57-857a-4933-ac02-08fdd429b4b2","d5b9e529-81aa-4855-b446-987f16b0b30f","08bd3029-e111-4387-af51-e53f2a943051","caf2b3e1-9962-4100-84b7-239c1be409a2","6b4d6103-1242-4705-a9da-7f895fe75a95"];
string gCharIndex = " !\"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\\]^_`abcdefghijklmnopqrstuvwxyz{|}~\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n";

list couleurs = [<255,255,255>,<0,0,0>,<255,0,0>,<0,255,0>,<0,0,255>,<255,255,0>,<0,255,255>,<255,0,255>];
vector lcolor;

vector GetGridPos(integer index1, integer index2) 
{
    if (index1 >= index2) 
        return <index2*2,index1, 0>;
    else 
        return <index1*2+1,index2, 0>;
}
 
string GetGridTexture(vector grid_pos) 
{
    return llList2Key(CHARACTER_GRID, (llRound(grid_pos.y) / 10) * ((llRound(grid_pos.y) / 10) + 1) / 2 + (llRound(grid_pos.x) / 20));
}
 
vector GetGridOffset(vector grid_pos) 
{
    return <-0.45 + 0.05 * (llRound(grid_pos.x) % 20), 0.45 - 0.1 * (llRound(grid_pos.y) % 10), 0.0>;
}
 
ShowChars(integer prim,integer color,vector grid_pos1, vector grid_pos2, vector grid_pos3, vector grid_pos4, vector grid_pos5) 
{
    lcolor = llList2Vector(couleurs,color);
    llSetLinkPrimitiveParams(prim,[
        PRIM_TEXTURE, 3, GetGridTexture(grid_pos1), <0.25, 0.1, 0>, GetGridOffset(grid_pos1) + <0.075, 0, 0>, 0.0,
        PRIM_TEXTURE, 7, GetGridTexture(grid_pos2), <0.1, 0.1, 0>, GetGridOffset(grid_pos2), 0.0,
        PRIM_TEXTURE, 4, GetGridTexture(grid_pos3), <-1.48, 0.1, 0>, GetGridOffset(grid_pos3)+ <0.371, 0, 0>, 0.0,
        PRIM_TEXTURE, 6, GetGridTexture(grid_pos4), <0.1, 0.1, 0>, GetGridOffset(grid_pos4), 0.0,
        PRIM_TEXTURE, 1, GetGridTexture(grid_pos5), <0.25, 0.1, 0>, GetGridOffset(grid_pos5) - <0.075, 0, 0>, 0.0,
        PRIM_COLOR,3,lcolor,1,
        PRIM_COLOR,7,lcolor,1,
        PRIM_COLOR,4,lcolor,1,
        PRIM_COLOR,6,lcolor,1,
        PRIM_COLOR,1,lcolor,1
        ]);
}
 
RenderString(integer prim,integer color,string str) 
{

    vector GridPos1 = GetGridPos( llSubStringIndex(gCharIndex, llGetSubString(str, 0, 0)),
                                  llSubStringIndex(gCharIndex, llGetSubString(str, 1, 1)) );
    vector GridPos2 = GetGridPos( llSubStringIndex(gCharIndex, llGetSubString(str, 2, 2)),
                                  llSubStringIndex(gCharIndex, llGetSubString(str, 3, 3)) );
    vector GridPos3 = GetGridPos( llSubStringIndex(gCharIndex, llGetSubString(str, 4, 4)),
                                  llSubStringIndex(gCharIndex, llGetSubString(str, 5, 5)) );
    vector GridPos4 = GetGridPos( llSubStringIndex(gCharIndex, llGetSubString(str, 7, 7)),
                                  llSubStringIndex(gCharIndex, llGetSubString(str, 7, 7)) );
    vector GridPos5 = GetGridPos( llSubStringIndex(gCharIndex, llGetSubString(str, 8, 8)),
                                  llSubStringIndex(gCharIndex, llGetSubString(str, 9, 9)) );
    ShowChars(prim, color, GridPos1, GridPos2, GridPos3, GridPos4, GridPos5);
}
 
integer ConvertIndex(integer index) 
{
    if (index >= 32)
        index -= 32;
    else 
    {
        if (index > 15)
            index = 15;
        index += 94;
    }
    return index;
}

integer channel;
string txt;
integer Sound = TRUE;
default
{
    state_entry()
    {
    }

    link_message(integer sender, integer color, string str, key id)
    {
        if (id=="ECRIS")
        {
            integer n = llStringLength(str);
            while (n<8)
            {
                str=str+" ";
                n = llStringLength(str);
            }
            if (color<10)
                str += "0"+(string)color;
            else
                str += (string)color;
            color = 3;
            n = llGetLinkNumber();
            RenderString(n,color,llGetSubString(str,0,9));
        }
    }
}