//
//    Slot Machine Wheel
//

integer WHEEL = 2;
integer MIN_SPIN_COUNT = 25;       //  Minimum counts to spin
float STOP_VAR = 0.20;             //  Percentage chance of stopping per turn

float SYMBOLS = 8.0;               //  Number of symbols around the wheel texture 
float BASE_TIME = 1.0;
float VAR_TIME = 1.0;

float SPIN_SPEED = 1.0;
float SPIN_VAR = 0.9;

float sound_volume = 1.000000;

integer spinning = FALSE;
integer spin_count = 0;
float symbol_inc;
 
integer temp_value;
  
float offset = 0.0;
 
default
{
    state_entry()
    {
        symbol_inc = 1.0/(2.0 * SYMBOLS);
    }
    
    link_message(integer sender_num, integer num, string str, key id)
    {
        list message = llParseString2List(str, [" "], []);
        if (llList2String(message, 0) == "Spin")
        {
            //
            //  Spin wheel and see what we get!
            //
            llSetTimerEvent(0.1);
            spin_count = 1;
            llLoopSound("spinner", sound_volume);
            float rate = llFrand(SPIN_VAR) + SPIN_SPEED;
            llSetTextureAnim(ANIM_ON | LOOP | SMOOTH, 1, 0,0, offset, 1.0, rate);
        }
        if (llList2String(message, 0) == "Volume")
        {
            sound_volume = llList2Float(message, 1);
        }
    }
    
    //touch_start(integer which) 
    //{
    //    llSetTimerEvent(0.1);
    //    spin_count = 1; 
   // }

    timer()
    {
        //
        //  Spin wheel for a while.
        //
        if (spin_count > 0)
        {
            spin_count += 1;
            offset += symbol_inc;
            if (offset > 1.0) offset -= 1.0;
            //llOffsetTexture(0.0, offset, -1);
        }
        if ((spin_count > MIN_SPIN_COUNT) && (llFrand(1.0) < STOP_VAR))
        {
            //
            //  Stop a while after min spins reached
            //
            llStopSound();
            llSetTextureAnim(0, 1, 0,0,0.0, 1.0, 0.0);
            spin_count = 0;
            llSetTimerEvent(0.0);
            //
            //  Measure outcome, snapping wheel to correct symbol
            //
            float value = offset * SYMBOLS;
            float temp = llFloor(value);
            value = temp;
            //llSay(0, "value: " + (string)value);
            if (value == SYMBOLS) value = 0.0;
            offset = value/SYMBOLS;
            llOffsetTexture(offset, 0.0, -1);
            integer out = (integer)value + 1;
            //llSay(0, "Wheel 2 score = " + (string) out);
            llMessageLinked(1, WHEEL, (string)out, "");
        }     
    }
} 