// Lockble Door Script v1.3 by Prospero Frobozz

// lockabledoor.lsl is Copyright (C) 2012 Rob Knop aka Prospero Frobozz
//
// This script is free software, available under the GNU GPL version 2.
// You are free to use it, modify it, or distribute it.  If you distribute
// this script or any modified versions, they must also be under the GNU GPL.
// This means that the script itself must be mod/copy/transfer.  Objects that
// use the script, or other components of such objects, do not themselves need
// to be mod/copy/transfer, but the script, or any other scripts derived from
// it, must.

// The door opens and closes when touched.  Optinally, the door may be locked.
// If it is locked, only the owner, or people on an access list, can open and
// close it.  Anybody on the access list can give it commands, as can the owner.

// Voice commands are:
//   /6 lock
//   /6 unlock
//   /6 listaccess
//   /6 adduser Firstname Lastname
//   /6 deluser Firstname Lastname
//   /6 togglemode
// substitute the control channel for 6 in all of the above.

// **************************************************
// CONFIGURATION -- set the variables below

// Which direction does the door rotate?  Set to 1 or -1.

float direction=-1;

// How many steps should it take to open or close?  (1 = just pop open.)

integer steps = 4;

// Play a sound when the door opens or closes; that sound must be in the door's
//   inventory with this script.

string opensound="creakydooropen";
string closesound="creakydoorclose";

// Set "toggle" to 1 to click once for open, once for close.  If "toggle"
//   is 0, then the door will open, stay open for delay, and close.

integer toggle = 1;

// how long does the door stay open before reclosing?

float delay=10;

// On which channel should the door listen for configuration?

integer controlchannel=6;

// Starting list of users who can access the door.  Leave empty for only owner.

list accesslist = [ ];

// END OF CONFIGURATION
// **************************************************

integer locked = 0;
integer opened = 0;

rotation rotbeforeopen;

integer checkaccess(string whoname, key whokey) {
    integer ok;
    integer length;
    integer i;

    if (whokey == llGetOwner()) {
        ok = 1;
    } else {
        length = llGetListLength(accesslist);
        for (i=0  ; (!ok) && i<length ; ++i) {
            if (whoname == llList2String(accesslist, i)) {
                ok=1;
            }
        }
    }

    return ok;
}

opendoor()
{
    rotation newrot;
    integer i;

    if (opened) return;

    if (llGetLinkNumber() < 2) {
        rotbeforeopen = llGetRot();
    } else {
        rotbeforeopen = llGetLocalRot() / llGetRootRotation();
    }
    if (opensound!="") llPlaySound(opensound, 1);
    for (i = 0 ; i < steps ; ++i)
    {
        newrot = rotbeforeopen * llEuler2Rot(<0., 0., direction * (PI/2. * (float)(i+1)/(float)steps)>);
        llSetRot(newrot);
    }
    opened = 1;
}

closedoor()
{
    rotation newrot;
    integer i;

    if (!opened) return;

    if (closesound!="") llPlaySound(closesound, 1);
    for (i = 0 ; i < steps ; ++i)
    {
        newrot = rotbeforeopen *
            llEuler2Rot(<0., 0., direction * (PI/2. * (float)(steps-i-1)/(float)steps)> );
        llSetRot(newrot);
    }
    llSetRot(rotbeforeopen);  // be anal
    opened = 0;
}

default
{
    state_entry() {
        llListen(controlchannel, "", NULL_KEY, "");
    }

    touch_start(integer total_number)
    {
        integer ok = 0;

        string toucher = llDetectedName(0);
        string toucherkey = llDetectedKey(0);

        if (!locked) ok=1;
        else ok=checkaccess(toucher,toucherkey);

        if (!ok) {
            llSay(0, "Sorry, this door is locked.  Only authorized people can use it.");
            return;
        }

        if (opened)
        {
            if (toggle)
            {
                closedoor();
            }
        }
        else
        {
            opendoor();
            if (!toggle)
            {
                llSleep(delay);
                closedoor();
            }
        }
    }

    listen(integer chan, string name, key id, string message) {
        integer ok;
        integer length;
        integer i;
        string response;
        string val;
        list params;
        string com;
        string paramstring;
        integer dex;

        ok=checkaccess(name, id);
        if (!ok) return;

        params = llParseString2List(message, [" "], []);
        if (llGetListLength(params) < 1) return;
        com = llList2String(params, 0);
        paramstring = llGetSubString(message, llStringLength(com)+1, -1);

        length = llGetListLength(accesslist);
        response = "";

        if (com == "listaccess" || com == "accesslist") {
            response = "Access granted to: ";
            for (i=0 ; i<length ; ++i) {
                response += llList2String(accesslist,i);
                if (i < (length - 1)) response += " ";
            }
        }
        else if (com == "adduser") {
            dex=-1;
            for (i=0 ; i<length ; ++i) {
                if (paramstring == llList2String(accesslist, i))
                    dex = i;
            }
            if (dex >= 0) {
                response = "Already in access list: " + paramstring;
            } else {
                accesslist += paramstring;
                response = "Added to access list: " + paramstring;
            }
        }
        else if (com == "deluser") {
            dex=-1;
            for (i=0 ; i<length ; ++i) {
                if (paramstring == llList2String(accesslist, i))
                    dex = i;
            }
            if (dex >= 0) {
                accesslist = llDeleteSubList(accesslist, dex, dex);
                response = "Removed from access list: " + paramstring;
            }
            else {
                response = "Not on access list: " + paramstring;
            }
        }
        else if (com == "lock") {
            locked = 1;
            response = "Door locked.";
        }
        else if (com == "unlock") {
            locked = 0;
            response = "Door unlocked.";
        }
        else if (com == "togglemode")
        {
            if (toggle == 1)
            {
                toggle = 0;
                response = "Toggle mode disabled; door will automatically close after opened.";
            }
            else
            {
                toggle = 1;
                response = "Toggle mode enabled; door must be clicked again to close.";
            }
        }

        if (response != "") llSay(0, response);
    }
}