// ______           _  ______            _           _
// |  ___|         | | |  ___|          | |         (_)
// | |_ ___ _ __ __| | | |_ _ __ ___  __| | ___ _ __ ___  __
// |  _/ _ \ '__/ _` | |  _| '__/ _ \/ _` |/ _ \ '__| \ \/ /
// | ||  __/ | | (_| | | | | | |  __/ (_| |  __/ |  | |>  <
// \_| \___|_|  \__,_| \_| |_|  \___|\__,_|\___|_|  |_/_/\_\
//
// fred@mitsi.com  
// Macaw bird script
//
//Revisions:
// 01-28-2010 initial release in Second Life
// 06-25-2015 Opensim Macaw mods


integer debug = TRUE;
DEBUG(string msg)
{
    if (debug) llOwnerSay(msg);
}

integer Rez = FALSE;  // set to TRUE to rez a debug Object in fron of the bird showing the pat. Must be phantom, and temp on rez, and and named Object
string Call = "Macaw_Call";    // when taking off
string Cry = "Macaw_Cry";      // when finds fruit

integer listener;        // placeholder for listen handle so we can remove it.
float timeOut ;          // counter for timer moving
float MAXTIME = 100;     // 100 @ timerate (0.5) = 50 seconds to reach a dest

// state machine
integer stateMachine;
integer previousState;
integer STOPPED    = 0;  
integer WANTAVATAR = 1;
integer GOTOAVATAR = 2;
integer FLYING     = 3;
integer SEENFOOD   = 4;
integer FOUNDFOOD  = 5;
integer GOHOME     = 6;

setState(integer what)
{
    stateMachine = what;
    showState();
}

showState()
{
     string txt;
    if      (stateMachine == 0) txt = "STOPPED";
    else if (stateMachine == 1) txt = "WANTAVATAR";
    else if (stateMachine == 2) txt = "GOTOAVATAR";
    else if (stateMachine == 3) txt = "FLYING";
    else if (stateMachine == 4) txt = "SEENFOOD";
    else if (stateMachine == 5) txt = "FOUNDFOOD";
    else if (stateMachine == 6) txt = "GOHOME";
    else {
        DEBUG("Illegal state");
    }
    DEBUG("State is now " + txt);
}
integer ANIMATE = 1; // the prim animator number for llMessageLinked
// animations are recorded and named flightmode, standmode, landmade and catchmode
// wing commanda are fly and unfly on channel 0

float pauseTimerMin = 10;   // 10 seconds waiting after returning home
float pauseTimerMax = 30;   // 30 seconds waiting after returning home
integer HUNGERTIME = 60; // one minute to get hungry
integer foodCounter;

// Turns
float TOLERANCE = 1.0 ; // how close to target we have to get
float TURNSTRENGTH = 0.3;  // how hard to turn
float TURNDAMPING = 0.1;    // and how soon

// Speed
float MAX = 3.0;   // MIN speed 
float MIN = 1.0 ;  // MAX SPEED - yes, backwards, as this is time to travel in mps

// Defaults

float timerate = 0.2;      
float roam_range = 10;          // default range
string flag ; // they need integers for menu
float SPEED = 1;       // flight speed
float MOVETO_INCREMENT = 2;  // How far we want to move between ticks - we actually move twice this at half the speed

vector avatarDest ;      // where the avatar was when detected
vector gDestination;
vector rezpoint;    // home point
rotation rezrot;    // and rotation - saved on reset or HOME menu

string defaultS = "Home: Set the perch position.\nRange: how far to roam\nFly: Fly Away!\nStop: Return to perch\n";
list defaultL = ["Range","Fly","Stop","Home","Help","About","Flap"];
 
 


Dialog(string prompt,list buttons) 
{
    integer listen_chan=llCeil(llFrand(10000) + 10000);
    listener = llListen(listen_chan,"","","");
    llDialog(llGetOwner(),prompt,buttons,listen_chan);
}

float randBetween(float min, float max)
{
    return llFrand(max - min) + min;
}
    
DoMove()
{   
   // DEBUG("Moveto:" + (string) gDestination);
    vector myPos = llGetPos();
    vector goTo;

    // assume we move 1 meter per tick
    // the distance we move toward is then set at twice that because it exponentially decays
    // So we need to try to move at least 2 meters, at half speed
   
    integer jumps = (integer)(llVecDist(gDestination, llGetPos()) / MOVETO_INCREMENT) + 1;
   // DEBUG("Jumps:"+ (string) jumps);
    float VEL;
    // move an incremental distance toward dest
    if (llVecDist(myPos, gDestination) > TOLERANCE)
    {   
        vector delta =   gDestination - myPos  ;
       // DEBUG("Delta:" + (string) delta);
        vector offset = llVecNorm(delta) * (MOVETO_INCREMENT * 2);
        //DEBUG("Offset:" + (string) offset);
        myPos = myPos + offset ; //* llGetRot() ;
        goTo = myPos;
        VEL = SPEED*2;
    } else {
       // DEBUG("Last Step"); 
        goTo = gDestination;
        VEL = 4;
    }
    
   

   // if (Rez) llRezObject("Object",goTo,ZERO_VECTOR, ZERO_ROTATION,0);
    
    llLookAt(goTo,TURNSTRENGTH,TURNDAMPING);
    llMoveToTarget(goTo, 1); // *2 = half speed
    
     llSetStatus(STATUS_PHYSICS, TRUE);     
}


picNewDestination() 
{
     // random direction
    vector newDestination = rezpoint;

    while (llVecDist(newDestination, llGetPos()) < 9 )
    {
        newDestination.x += llFrand(roam_range) - 0.5 * roam_range;
        newDestination.y += llFrand(roam_range) - 0.5 * roam_range;
        newDestination.z += llFrand(1.0);
        DEBUG("trying " + (string) newDestination);
    }
    setDest(newDestination);
}


// always set the timeout when we change places
setDest(vector dest)
{
    gDestination = dest;
    timeOut = MAXTIME;
    DEBUG("New Dest:" + (string) gDestination);
}


default
{ 
    on_rez(integer a)
    {
        llResetScript();
    }
    changed(integer change)
    {
        if (change & CHANGED_OWNER) {
            llResetScript();
        }
    }
    state_entry()
    {
        integer i = llGetNumberOfPrims();
        integer j;
        for (j=1; j < i; j++)
        {
            llSetLinkPrimitiveParamsFast(j,[PRIM_PHYSICS_SHAPE_TYPE,PRIM_PHYSICS_SHAPE_NONE]);
        }
        
        setState(STOPPED);
        llMessageLinked(LINK_SET,0,"unflap","");
        llMessageLinked(LINK_SET,0,"unfly","");            // wings gone
    
        llMessageLinked(LINK_SET,ANIMATE,"standmode","");  // standing there
        
        llSetStatus(STATUS_DIE_AT_EDGE,FALSE);
        llSetStatus(STATUS_PHYSICS, FALSE);

        llOwnerSay("Click bird to start flying or to change settings.");

        rezpoint = llGetPos();
        rezrot = llGetRot();
        
        llMessageLinked(LINK_SET,0,"wing","");            // wings smnall
        
        Dialog(defaultS,defaultL);
    }
    touch_start(integer a)
    {
        if (llDetectedKey(0) == llGetOwner())
        {
            Dialog(defaultS,defaultL);
        }
    }
    timer()
    {
        showState();
        DoMove();
        
        if (stateMachine == FLYING && previousState != FLYING) {
              vector Z = llGetPos();
            if (gDestination.z > Z.z)
                llMessageLinked(LINK_SET,0,"Dowings","");
            else
                llMessageLinked(LINK_SET,0,"glide","");                    
        }
        
        previousState = stateMachine;
        //DEBUG("Distance:" + (string) llVecDist(gDestination,llGetPos()));
        DEBUG("t");
        
        if (--timeOut == 0)
        {
           // DEBUG("too long, returning");

            setState(GOHOME);
            setDest(rezpoint);
            return;
        }

        if (foodCounter++ == HUNGERTIME)
        {
            DEBUG("I am hungry");
            llSensorRepeat("apple","", ACTIVE|PASSIVE|SCRIPTED, roam_range, PI, 10.0);
        }
        // at destination
        if (stateMachine == GOTOAVATAR && llVecDist(gDestination,llGetPos()) < TOLERANCE)
        {
            DEBUG("At Avatar");
            picNewDestination();
            stateMachine = FLYING;
            return;
        }
        
         if (stateMachine == FLYING && llVecDist(gDestination,llGetPos()) < TOLERANCE)
        {
            DEBUG("At Destination");
            picNewDestination();
            return;
        }
        
        
        if (stateMachine == FLYING && llVecDist(gDestination,llGetPos()) > roam_range )
        {
            DEBUG("Too far");
            setDest(rezpoint + <0,0,2>);
            return;
        }
        
        
        if (stateMachine == SEENFOOD && llVecDist(gDestination,llGetPos()) < TOLERANCE)
        {
            DEBUG("Caught Fruit");
            llPlaySound(Cry,1.0);
            llWhisper(2212,"eat");
            llMessageLinked(LINK_SET,ANIMATE,"catchmode","");       // grab the fruit
            stateMachine = FOUNDFOOD;
            
            //  Calc a place at the fruit, up higher.
            setDest((llGetPos() + <0,0,0.5>));
            return;
        }

        if (stateMachine == FOUNDFOOD && llVecDist(gDestination,llGetPos()) < TOLERANCE)
        {
            setDest(rezpoint);
            stateMachine = GOHOME;
            DEBUG("Heading Home");
            return;
        }

        if (stateMachine == GOHOME && llVecDist(gDestination,llGetPos()) < TOLERANCE)
        {
            DEBUG("Landing");
            llSetStatus(STATUS_PHYSICS, FALSE);
            
            llSetRegionPos(rezpoint);
            llMessageLinked(LINK_SET,ANIMATE,"landmode","");       
            llSleep(1);                // time to set position with feet out
            llSetRot(rezrot);
            
            llMessageLinked(LINK_SET,0,"unfly","");      
            llMessageLinked(LINK_SET,1,"down","");       // Body down 

            llSetTimerEvent(randBetween(pauseTimerMin,pauseTimerMax));
            stateMachine = WANTAVATAR;
            
            llMessageLinked(LINK_SET,0,"wing","");            // wings small
            
            return;
        }

        if (stateMachine == WANTAVATAR)
        {
            DEBUG("Scanning");
            llSensorRepeat("","",AGENT,roam_range,PI,2);
        }
    }

    sensor(integer total_number)
    {
        llSensorRemove();
        // detected a person - time to fly
        if (stateMachine  & WANTAVATAR)
        {
            llPlaySound(Call,1.0);
            avatarDest = llDetectedPos(0);
            avatarDest.z += 2; // fly over their head
            gDestination = avatarDest;
            setDest(gDestination);
            
            setState(GOTOAVATAR);
            
            llMessageLinked(LINK_SET,0,"wing","");            // wings smnall
            llSleep(0.2);
            llMessageLinked(LINK_SET,1,"wing","");            // wings med
            llSleep(0.2);
            llMessageLinked(LINK_SET,2,"wing","");            // wings large
            llSleep(0.2);
            llMessageLinked(LINK_SET,-1,"wing","");            // wings gone
             llMessageLinked(LINK_SET,0,"fly","");      
            llMessageLinked(LINK_SET,ANIMATE,"flightmode","");   
       
            llSetTimerEvent(timerate);
                      
        } else if (stateMachine & FLYING)        
        {
            llPlaySound(Call,1.0);
            vector foodLoc = llDetectedPos(0);
            foodLoc.z += 0.2;    // just above it
            setDest(foodLoc);
            stateMachine = SEENFOOD;
        } else {
            DEBUG("Sensor fired for no good reason");
        }
    }
   
    listen(integer channel,string name, key id, string msg)
    {
        llListenRemove(listener);
        if (msg == "Fly") {
            setState(WANTAVATAR);
            llSensorRepeat("","",AGENT,roam_range,PI,5);
        }
        else if (msg == "Flap") {
             llTriggerSound("pigeon_wings",1);
            integer i;
            for (i = 0; i <= 3; i++)
            {
                llMessageLinked(LINK_SET,i,"wing","");
                llSleep(.4);
            }
             llMessageLinked(LINK_SET,-1,"fly","");
             llSleep(5); 
            for (i = 3; i >= -1; i--)
            {
                llMessageLinked(LINK_SET,i,"wing","");
                llSleep(.4);
            }
             llMessageLinked(LINK_SET,-1,"unfly","");


        }
        else if (msg == "Stop")
        {
            // Hard Shutdown;
            llSetTimerEvent(0);
            setState(STOPPED);
            llSensorRemove();
            llSetStatus(STATUS_PHYSICS, FALSE);
            llSleep(0.1); // needs a moment to shut off physics

            // Move home
            llSetRegionPos(rezpoint);
            llSetRot(rezrot);
            llMessageLinked(LINK_SET,0,"unfly","");       
            llMessageLinked(LINK_SET,ANIMATE,"landmode","");  

            llOwnerSay("Bird is now stopped and is at " + (string) rezpoint);
            Dialog(defaultS,defaultL);
        }
        else if (msg == "Range")
        {
            Dialog("Range from home in meters",["5","10","15","20","30","45","60","90","120"]);
            flag = "R";
        }
        else if ((integer) msg > 0 && flag == "R")
        {
            roam_range = (integer) msg;
            llOwnerSay("Flight range is " + (string) roam_range + " meters.");
            flag = "";
            Dialog(defaultS,defaultL);
        }
        else if (msg == "Help")
            llGiveInventory(llGetOwner(),"Help");
        else if (msg == "Home")
        {
            // save position and rotation
            rezpoint = llGetPos();
            rezrot = llGetRot();
            llOwnerSay("Position is set to " + (string) rezpoint);
            Dialog(defaultS,defaultL);
        }
         else if (msg =="About")
            llLoadURL(llGetOwner(),"More Info","http://www.outworldz.com");


    }
}


  