float INTERVAL = 9.993000;

float VOLUME = 1.0;
integer dialogCh = 55;

integer g_iSound;
integer g_iPlaying;
integer g_iLooping;
integer g_iListen;
integer g_iPlayAll;
integer songIndex;
integer start;
integer end;

list songs;
list beginNumbers;
list playList;

integer Channel;
integer Menu2;
integer Colors;
list Choices = ["Play Music", "Volume"];
list Colorb = ["DeepRed", "Red","White","Yellow","Green","Pink", "Aquamarine","Purple","Royal Black"];
list Volume_Options = ["0%", "10%", "20%", "30%", "40%", "50%", "60%", "70%", "80%", "90%", "100%"];
vector vColor;

Initialize()
{
    integer i;
    string name;
    songs = [];
    beginNumbers = [];
    for(i=0; i<llGetInventoryNumber(INVENTORY_SOUND); ++i)
    {
        if(name != llGetSubString(llGetInventoryName(INVENTORY_SOUND, i), 0, -3))
        {
            name = llGetSubString(llGetInventoryName(INVENTORY_SOUND, i), 0, -3);
            songs += [name];
            beginNumbers += [i];
        }
    }
    beginNumbers += [llGetInventoryNumber(INVENTORY_SOUND)];
    Channel = (integer)(llFrand(99999.0)* -1);//make a random channel 
    llListen(Channel, "", "", "");
    g_iPlaying = 0;
    g_iLooping = TRUE;
    g_iPlayAll = FALSE;
}



PlaySong(string song)
{
    VOLUME = 1.0;
    //llStopSound();            //this does not work, enable when bug is fixed.
    songIndex = llListFindList(songs, [song]); 
    start = llList2Integer(beginNumbers, songIndex);
    end = llList2Integer(beginNumbers, songIndex+1);
    llSetSoundQueueing(TRUE);
    if(g_iPlaying)                          // erase these two lines when 
        llSleep(15-llGetTime());            // llStopSound bug is fixed
    llSetTimerEvent(1.0);
    g_iPlaying = TRUE;;   
    g_iSound = start;
}


StopSong()
{
    g_iPlaying = 0;
    llWhisper(0,"Stopping...");
    //llStopSound();            //This does not work properly, enable this when bug is fixed
    llSetTimerEvent(0.0);
}

menu(key id)
{
    list buttons = ["Stop", "Play All"];
    if(g_iLooping)
        buttons += ["Unloop"];
    else
        buttons += ["Loop"];
    string text = "What song would you like to listen to?\n";
    integer i;
    for(i=0; i< llGetListLength(songs); ++i)
    {
        buttons += [(string)(i+1)];
        text += "\n"+(string)(i+1) + " - " + llList2String(songs, i);
    }
    
    llDialog(id, text, buttons, Channel);
}

default
{
    changed(integer change)
    {
        if(change & CHANGED_OWNER)
            llResetScript();
    }
    state_entry()
    {
        Initialize();
    }

    attach(key id)
    {
        if ( id != NULL_KEY )
        {
            llSetTimerEvent(0.0);
            g_iPlaying = FALSE;
            //menu(id);  //this line gives the songs menu, but we want the main menu first 
            llDialog(llGetOwner(),"\nWhat do you want to do?",Choices, Channel);
            VOLUME = 1.0;
            //llOwnerSay("Say .rose menu to get the menu thru chat to select a song.");
        }
    }
    
    touch_start(integer total_number)
    {
        llDialog(llDetectedKey(0),"\nWhat do you want to do?",Choices, Channel);
    }
    //These lines from the original masterscript II were:
    //{
    //    menu(llDetectedKey(0));
    //}
    
    listen(integer channel, string name, key id, string message)
    {
        if(message == "Play Music")
        {
            //menu(llDetectedKey(0));
            //menu(llGetOwner());
            menu(id);
        }
        else if(message == "Rose Color")
        {
            llDialog(id, "Choose your Color", Colorb, Channel);
        }
        else if(message == "Volume")
        {
            llDialog(id, "Choose your volume level", Volume_Options, Channel);
        }
        else if(llGetSubString(message, -1, -1) == "%")
        {
            VOLUME = ((integer)message)/100.0;
            llAdjustSoundVolume(VOLUME);
        }
        else if(message == "Play All")
        {
            integer i;
            playList = [];
            list temp;
            for(i=0; i<llGetListLength(songs); i++)
            {
                temp += [i];
            }
            for(i=0; i<llGetListLength(songs); i++)
            {
                integer num = llFloor(llFrand(llGetListLength(temp)));
                playList += [llList2Integer(temp, num)];
                temp = llDeleteSubList(temp, num, num);
            }
            
            g_iPlayAll = TRUE;
            llWhisper(0, "Playing all songs...");
            PlaySong(llList2String(songs, llList2Integer(playList, 0)));
        }
        else if(message == "Loop")
        {
            g_iLooping = TRUE;
            llWhisper(0, "Looping...");
            menu(id);
        } 
        else if(message == "Unloop")
        {
            g_iLooping = FALSE;
            llWhisper(0, "Unlooping...");
            menu(id);
        }
        else if((message == "Stop") || (message == "Stop Music"))
        {
            StopSong();
        }
        else if((integer)message > 0)
        {
            g_iPlayAll = FALSE;
            PlaySong(llList2String(songs, (integer)message - 1));
        }
        else if(message == ".rose menu")
        {
            menu(llGetOwner());
        }
        else if(message =="DeepRed")
        {
        vColor = <0.36863,0,0>;
        llSetColor(vColor, ALL_SIDES);
        llMessageLinked(LINK_ALL_CHILDREN, 101,(string)vColor,NULL_KEY);    
        }
        else if(message == "Red")
        {
        vColor = <0.41961,0,0>;
        llSetColor(vColor, ALL_SIDES);
        llMessageLinked(LINK_ALL_CHILDREN, 101,(string)vColor,NULL_KEY);    
        }    
        else if(message == "White")
        {
        vColor = <0.75,0.75,0.75>;
        llSetColor(vColor, ALL_SIDES);
        llMessageLinked(LINK_ALL_CHILDREN, 101,(string)vColor,NULL_KEY);    
        }
        else if(message == "Yellow")
        {
        vColor=<0.58431,0.58431,0>;    
        llSetColor(vColor, ALL_SIDES);
        llMessageLinked(LINK_ALL_CHILDREN, 101,(string)vColor,NULL_KEY);
        //llSay(0,"vColor sender = " + (string)vColor +"/n");
        //llSay(0,"nothing was passed along, because i didnt feel like it");
        }
        else if(message == "Green")
        {
        vColor = <0.59216,1,0.59216>;
        llSetColor(vColor, ALL_SIDES);
        llMessageLinked(LINK_ALL_CHILDREN, 101,(string)vColor,NULL_KEY);    
        }
        else if(message == "Pink")
        {
        vColor = <1,0.47843,1>;
        llSetColor(vColor, ALL_SIDES);
        llMessageLinked(LINK_ALL_CHILDREN, 101,(string)vColor,NULL_KEY);    
        }
        else if(message == "Aquamarine")
        {
        vColor = <0.27451,0.63922,1>;
        llSetColor(vColor, ALL_SIDES);
        llMessageLinked(LINK_ALL_CHILDREN, 101,(string)vColor,NULL_KEY);    
        }
        else if(message == "Purple")
        {
        vColor = <0.32157,0,0.32157>;
        llSetColor(vColor, ALL_SIDES);
        llMessageLinked(LINK_ALL_CHILDREN, 101,(string)vColor,NULL_KEY);    
        }
        else if(message == "Royal Black")
        {
        vColor = <0.06667,0,0.12549>;
        llSetColor(vColor, ALL_SIDES);
        llMessageLinked(LINK_ALL_CHILDREN, 101,(string)vColor,NULL_KEY);    
        }
    }

    timer()
    {
        llResetTime();
        if ( g_iPlaying )
        {
            if(g_iSound == start)
            {
                llWhisper(0,"Playing "+llList2String(songs, songIndex)+"...");
                llSetTimerEvent(5);
            }
            else if ( g_iSound == start+1)
            {
                llSetTimerEvent(INTERVAL);
            }
            llPlaySound(llGetInventoryName(INVENTORY_SOUND, g_iSound),VOLUME);
            g_iSound++;
            if( g_iSound < end-1)
            {
                llPreloadSound(llGetInventoryName(INVENTORY_SOUND, g_iSound+1));
            }
            if ( g_iSound >= end)
            {
                if(g_iPlayAll)
                {
                    if(songIndex == llList2Integer(playList, llGetListLength(playList)-1))
                    {
                        if(g_iLooping)
                        {
                            PlaySong(llList2String(songs, llList2Integer(playList, 0)));
                        }
                        else
                        {
                            g_iPlaying = FALSE;
                            llSetTimerEvent(0);
                        }
                    }
                    else
                    {
                        PlaySong(llList2String(songs, llList2Integer(playList, llListFindList(playList, [songIndex])+1)));
                    }
                }
                else
                {
                    g_iPlaying = FALSE;
                    llSetTimerEvent(0);
                }
                
            }
        }
    }
}
 