// Cubey's multi-destination teleporter
// May 15, 2005
// Script to use the llSitTarget properties to act as a teleporter. 
// Free to use, modify, and distribute. Not for resale!

// Destination can be 300m away, maximum. This limit is determined by LL's limitations on the use of llSitTarget.


// HOW TO SET UP TELEPORTER:
// STEP 1. Place this teleporter, then place the target teleport chamber. 


// STEP 2. Specify the total number of destinations that are to be used. Max number is no more than the destinations listed below.
integer totalDest = 1;


// STEP 3. Go to the destination chamber, write down its X, Y, and Z position, then come back and enter those values here. X and Y are the horizontal coords on your mini-map. Z is the height. For example, if your target is at Abbotts(100,54) at an altitude of 41.5 meters, enter a vector of <100, 54, 41.5>. 

// NOTE: This script only permits destinations within the same sim as the teleporter.

// Enter the destinations here:
vector dest1 = <220,148,38>;  
vector dest2 = <0.00, 0.00, 0.00>;
vector dest3 = <0.00, 0.00, 0.00>;
vector dest4 = <0.00, 0.00, 0.00>;


// STEP 4. Replace name of destinations with a short name. Example: "second floor".
string dest1_name = "downstairs";
string dest2_name = "REPLACE THIS WITH A DESTINATION NAME";
string dest3_name = "REPLACE THIS WITH A DESTINATION NAME";
string dest4_name = "REPLACE THIS WITH A DESTINATION NAME";



// STEP 5. Replace description of destinations with a short description. These will appear when the user clicks the button. Example: "living room and private bar".
string dest1_desc = ".";
string dest2_desc = "REPLACE THIS WITH A DESTINATION DESCRIPTION";
string dest3_desc = "REPLACE THIS WITH A DESTINATION DESCRIPTION";
string dest4_desc = "REPLACE THIS WITH A DESTINATION DESCRIPTION";


// STEP 6. Done! Now test it. 











// ------------------------- NO NEED TO MODIFY ANYTHING BELOW THIS LINE -------------------------
integer currentDestNum = 1;
vector currentDest;
string currentDestName;
string currentDestDesc;


rotate_to_zero()
{
    llSetRot(<0,0,0,0>);
}

setDestination()
{
    if (currentDestNum == 1)
    {
        currentDest = dest1;
        currentDestName = dest1_name;
        currentDestDesc = dest1_desc;
    }
    else if (currentDestNum == 2)
    {
        currentDest = dest2;
        currentDestName = dest2_name;
        currentDestDesc = dest2_desc;
    }
    else if (currentDestNum == 3)
    {
        currentDest = dest3;
        currentDestName = dest3_name;
        currentDestDesc = dest3_desc;
    }
    else if (currentDestNum == 4)
    {
        currentDest = dest4;
        currentDestName = dest4_name;
        currentDestDesc = dest4_desc;
    }
    
    vector pos = llGetPos();
    vector offset = currentDest - pos;

    llSitTarget(offset, ZERO_ROTATION);
    
    string hoverText = "Go to\n"+currentDestName+"\n"+currentDestDesc+"\n\n";
    llSetText(hoverText,<0,1,0>,1);
}

default
{
    state_entry()
    {
        rotate_to_zero();
        setDestination();
        llSetSitText("Teleport");
    }
    on_rez(integer num)
    {
        llResetScript();
    }
    changed(integer change)
    {
        if (change & CHANGED_LINK)
        {
            if (llAvatarOnSitTarget() != NULL_KEY)
            {
                llMessageLinked(LINK_SET, 0, "teleporting", "");
                llSleep(0.5); 
                llUnSit(llAvatarOnSitTarget());
            }
        }
    }
    touch_start(integer total_number)
    {
        currentDestNum += 1;
        if (currentDestNum > totalDest) currentDestNum = 1;
        rotate_to_zero();
        setDestination();
    }
}