//*****************************************************************************
//
// The simplest possible particle script.
//
// Use: Will start a particle system either when rezzed or the script is reset.
//
//*****************************************************************************

ParticleStart()
{
    llParticleSystem([
        PSYS_PART_FLAGS, 291,
        PSYS_SRC_PATTERN, 8,
        PSYS_PART_START_ALPHA, 0.60,
        PSYS_PART_END_ALPHA, 0.00,
        PSYS_PART_START_COLOR, <1.00,1.00,1.00>,
        PSYS_PART_END_COLOR, <1.00,1.00,1.00>,
        PSYS_PART_START_SCALE, <0.08,0.15,0.00>,
        PSYS_PART_END_SCALE, <0.08,0.15,0.00>,
        PSYS_PART_MAX_AGE, 4.00,
        PSYS_SRC_MAX_AGE, 0.00,
        PSYS_SRC_ACCEL, <0.00,0.00,-1.50>,
        PSYS_SRC_ANGLE_BEGIN, 0.00,
        PSYS_SRC_ANGLE_END, 0.18,
        PSYS_SRC_BURST_PART_COUNT, 40,
        PSYS_SRC_BURST_RADIUS, 0.10,
        PSYS_SRC_BURST_RATE, 0.01,
        PSYS_SRC_BURST_SPEED_MIN, 1.50,
        PSYS_SRC_BURST_SPEED_MAX, 3.00,
        PSYS_SRC_OMEGA, <0.00,0.00,0.00>,
        PSYS_SRC_TEXTURE, "eea3f66a-ef39-d37c-f437-757c082bccfc"
    ]);

}


//*****************************************************************************
//
// Default state: LSL will always start in this state.
//
//*****************************************************************************

default
{
    state_entry()
    {
        ParticleStart();
    }
}
