//
// Simple mailbox / guestbook script - Haplo Voss
// Free to use and abuse as you see fit
//
// Just drop this and a blank notecard named 'mailbox' into a prim of your choice. 
// When others click on it, they can leave you a message and it will leave you an IM that someone has done so.
// When you (the owner) click on it, it will list all messages within the notecard including name, key, time, and message. 
// Having the key is useful if you want to send an IM or something to that user at some point. 
// In a metaverse where there can be more than one of the same name - the UUID is good to have.
// On with the show...

integer listener;
string gMessage = "";   // Empty string to build the message for write to notecard
key visitor;            // key of person clicking on the object
key owner;              // your key
string v_Name = "";     // string to contain the visitors name

RetrieveMsgs()                                              // Optional retrieval and display function...
{
        string note = osGetNotecard("mailbox");             // Get contents of notecard and store it in temporary string 'note'
        list new_list = llParseString2List(note,"|","");    // Parse it out into a list
        integer i;
        string inbox;                                       // empty string to build individual message blocks
        
        for (i=0; i<llGetListLength(new_list); i++)         // loop that reads the list, displays the information to the owner.
        {
            inbox = "\n"+llList2String(new_list,i)+" "+llList2String(new_list,i+1)+" "+llList2String(new_list,i+2)+" "+llList2String(new_list,i+3);
            i=i+3;
            llOwnerSay(inbox); 
        }
            
}

WriteMsg()
{
    string note = osGetNotecard("mailbox");                 // Get contents of notecard and store it in temporary string 'note'
    llRemoveInventory("mailbox");                           // Delete the old notecard! (If you don't... well, you'll find out.)
    note += gMessage;                                       // Add the new message block to the contents of the old notecard
    gMessage="";                                            // Clear the message string! (Otherwise you duplicate and mess up your data)
    list new_list = llParseString2List(note,"|","");        // Parse the string into a list. Why? Cuz osMakeNotecard needs a list.
    osMakeNotecard("mailbox",new_list);                     // Make a new notecard with all the old and new data in it. woo!
}

default
{
    state_entry()
    {
        llOwnerSay("Mailbox Active");                       // Why not? 
    }
    
    touch_start(integer num)
    {
        visitor = llDetectedKey(0);                         // Just a few variable assignments. Pretty self explanatory here...
        v_Name = llKey2Name(visitor);
        owner = llGetOwner();
        
        if (visitor != owner)
        {
            llSay(0,"Thank you for stopping by!\nEnter your message in chat using one line.\nOnce you press ENTER your message will be saved and delivered!");
            listener = llListen(0,"",visitor,"");           // Open the listener channel to capture the next line in chat
        }
        
        else
        {
            RetrieveMsgs();             // Go read up top. It's really really interesting.
            // **** This is a completely optional portion of this script. You can always just open your notecard and read it ***
        }
            
    }
    
    listen (integer channel, string name, key id, string msg)
    {
        if (msg != "")
        {
            llListenRemove(listener);   // Close the listener. Don't need it or want it. No lag. *pets llListenRemove*
            gMessage = v_Name+"|"+(string)visitor+"|"+(string)llGetTime()+"|"+msg;  // Create the new message block
            WriteMsg();                 // Go up a ways, enrich yourself with scripting goodness.
                        
            llSay(0,"Thank you for taking the time to write me!");                  // Nothing much left to do. Tell them thanks, fire off an IM.
            llInstantMessage(owner,"You have mail! At region: "+llGetRegionName());
        }
    }
}