// Puts animations such as dances, face animations, gestures in a loop
//Retrieved from Free SL Scripts on http://www.gendersquare.org/sl 
//Loop Animation Example
//by Hank Ramos
 
list animations1  = [ "hinkelen", "hinkelem" ];

list animations2 = [ "hinkelen", "hinkelen", ];

list animations;

default
{
    state_entry()
    {
        //Do some initialization here
        animations = animations1 + animations2;
        animations1 = [];
        animations2 = [];
        llRequestPermissions(llGetOwner(), PERMISSION_TRIGGER_ANIMATION);
    }
    run_time_permissions(integer permissions)
    {
        //Only start the animation looping if we obtain permissions
        if (permissions & PERMISSION_TRIGGER_ANIMATION)
        {
            llSay(0, "Initialized Successfully...");
            state running;
        }
    }

}
state idle
{
    state_entry()
    {
        integer x;
        string animName;
        list animationList = llGetAnimationList(llGetOwner());
        
        llSay(0, "Stopping Animations...");
        //Disable all running animations
        for (x = 0; x < llGetListLength(animationList); x += 1)
        {
            animName = llList2String(animationList, x);
            llStopAnimation(animName);
        }
        llSay(0, "Animations Stopped.");
    }
    touch_start(integer num_detected)
    {
        if (llDetectedKey(0) == llGetOwner())
        {
            state running;
        }
    }
}
state running
{
    state_entry()
    {
        llSetTimerEvent(10);
    }
    on_rez(integer start_param)
    {
        llResetScript();
    }
    touch_start(integer num_detected)
    {
        if (llDetectedKey(0) == llGetOwner())
        {
            state idle;
        }
    }
    timer()
    {
        string animName;
        
        animName = llList2String(llListRandomize(animations, 0), 0);
        llSay(0, "Starting: " + animName);
        llStartAnimation(animName);
    }
} 