list    gInventoryList;

list getInventoryList()
{
    integer    i;
    integer    n = llGetInventoryNumber(INVENTORY_ALL);
    list          result = [];
    string name = llGetScriptName();
    string tname;
    for( i = 0; i < n; i++ )
    {
        tname = llGetInventoryName(INVENTORY_ALL, i);
        if( tname != name ) {
            result += [ tname ];
            if( llGetInventoryType( tname ) == INVENTORY_SCRIPT ) {
                llSetScriptState( tname , FALSE);
            }
        }
    }
    return result;
}

default
{
    state_entry()
    {
        llSetText("Linked Prim Animator Lite\nTouch to UnPack",<1,1,1>,1.0);
        gInventoryList = getInventoryList();
    }

    touch_start( integer n )
    {
        if( llDetectedKey(0) == llGetOwner() ) {
            llGiveInventoryList(llDetectedKey(0), llGetObjectName(), gInventoryList );        
        }
    }

    changed( integer change )
    {
       if ( change == CHANGED_INVENTORY )
           gInventoryList = getInventoryList();
    }
}