// OpenSimian BotKiller
// Kills all the NPC's in the region.. Please use with discretion.
// Iterate over a list of avatar keys, using them as an arguments to osNpcRemove
// Add a delay to the timer if sim performance starts to drag during logouts
// Feel free to use/distribute/modify to suit your needs
// Prepared for transfer to MOSES grid -  D Osborn  5.3.2013
 
integer who2kill = 0;
integer howmany = 0;
list avatars = [];
 
default
{
    state_entry()
    {
       llSetText("waiting ", <1.0, 0.0, 0.0>, 1.0);
    }
 
    touch_end(integer total_number)  // should not change state in touch_start events....
    {
       avatars = osGetAvatarList();
       howmany = llGetListLength(avatars)/3;
       state KillThem;
    }
 
    changed(integer change)    //  Reset on region restart
    {
       if (change & CHANGED_REGION_RESTART)
       {
           llResetScript();
       }
    }
}
 
state KillThem
 
{
    state_entry()
    {
       llSetText("Processing ", <1.0, 0.0, 0.0>, 1.0);
       llSetTimerEvent(3.0);                            // remove 1 every 3 seconds to minimize performance impact
    }
 
    timer()
    {
       osNpcRemove(llList2Key(avatars,who2kill*3));  
       llSetText("Removed so far : " + (string) (who2kill + 1), <1.0, 0.0, 0.0>, 1.0);
 
       who2kill++;       
       if(who2kill>=howmany)
           state default;          
 
       llSetTimerEvent(3.0/ llGetRegionTimeDilation());   // Use timedilation to add to the delay if lagging
    }
 
 
    touch_end(integer interrupt)   // abort by touching the object while it is processing
    {
       llResetScript();
    }
 
    changed(integer change)
    {
       if (change & CHANGED_REGION_RESTART)
       {
           llResetScript();
       }
    }
}