//                  PLEASE DO NOT REMOVE THIS HEADER                      \\
//========================================================================\\
//   COLOR PICKER SCRIPT FOR PARTICLE SCRIPT MAKER v.1 (updated on 22nd July 2016)    \\
//========================================================================\\
/*
LICENSE AGREEMENT: 
THIS WORK IS ONLY FOR EDUCATIONAL AND NON COMMERCIAL PURPOSE. 
YOU ARE FREE TO EXPERIMENT, STUDY, MODIFY, IMPROVE THE SCRIPTS
AND MATERIALS AND POST YOUR FEEDBACK OR WORK BACK HERE.
BUT UNDER NO CIRCUMSTANCES, YOU CAN SELL THE WHOLE OR ANY PART 
OF THE PARTICLE GENERATOR MACHINE OR USE FOR COMMERCIAL PURPOSE. 
ANY TYPE OF COMMERCIAL USAGE IS SIMPLY AND STRICTLY FORBIDDEN.
http://creativecommons.org/licenses/by-nc/4.0/
===============================================================================
    For Update, documentation, how-tos etc. Kinkdly  visit the following link:            
    http://forums.osgrid.org/viewtopic.php?f=5&t=5682
 ==============================================================================
*/

integer DIEWHENREZZERDIES=0x12124ef;
integer FACE=1;

vector HSVtoRGB( vector hsv )
/*
http://wiki.secondlife.com/wiki/Color_conversion_scripts

// by Sally LaSalle, code released to the public domain under GNU GPL version 3.0 license.
// you are free to use, and you are free to donate to me if you wish!! :P
 
// takes a vector encoded Hue Saturation Value (HSV) triplet
// HSV should be entered with floats the ranges: <float H(0 to 360), float S(0 to 1),float V(0 to 1)>
// And Returns a vector encode Red Green Blue (RGB) color triplet
// RGB will be returned with floats in ranges <float R(0 to 1),float G(0 to 1),float B(0 to 1)>
*/
{
    integer i;
    float H = 6 * hsv.x; if (H<0) H+=6; else if (H>=6)H-=6;// catch malformed HSV input
    float S = hsv.y; if (S<0) S=0; else if (S>1)S=1;
    float V = hsv.z; if (V<0)V=0; else if (V>1)V=1;
    float R;    float G;    float B; // variables for calculating base color mixing around the "spectrum circle"
    float f; float p; float q; float t;
    vector rgb;
    if( S == 0 ) { R = V; G = V; B = V;rgb.x = R;  rgb.y = G;  rgb.z = B;  return rgb;}// achromatic (grey) simply set R,G, & B = Value
    i = llFloor( H );      // integer floor of Hue
    f = H - i;            // fractional part of H
    p = V * ( 1 - S );  q = V * ( 1 - S * f );  t = V * ( 1 - S * ( 1 - f ) );
    if (i==0)return < V , t, p>; 
    else if (i==1) return <q, V,p>;
    else if (i==2)return < p, V,  t>; 
    else if (i==3) return < p,q,V>;
    else if (i==4)return <t,p, V>; 
    else return <V,p,q>;
}
 
vector RGBtoHSV( vector rgb ) // newly added by me 
/*
http://wiki.secondlife.com/wiki/Color_conversion_scripts
// by [[Sally LaSalle]], code released to the public domain under GNU GPL version 3.0 license.
// you are free to use, and you are free to donate to me if you wish!! :P
 
// takes an RGB color as a vector, with range <float R[0,1], float G[0,1], float B[0,1]>
// returns a vector with HSV ranged from <float H[0,360], float S[0,1],  float V[0,1]>
// H ranges smoothly from Red=0, Yellow=60, Green=120, Cyan=180, Blue=240, Violet=300 and back to Red
*/
{
    float R = rgb.x;if (R<0)  R=0; else if (R>1) R=1;  
    float G = rgb.y; if (G<0)G=0; else if (G>1) G=1;  
    float B = rgb.z;if (B<0)B=0; else if (B>1) B=1; 
    float H; float S; float V;
    list rgbList = [R, G, B]; 
    float min; float max; float achromatic; float delta; vector hsv;  
    min = llListStatistics(LIST_STAT_MIN, rgbList); 
    max = llListStatistics(LIST_STAT_MAX, rgbList);
    if (R==G && G==B) achromatic = 1;  else achromatic = 0;
    V = max;                    // V = brightness Value form 0 to 1
    delta = max - min;
    if( max ) S = delta / max;        // S = saturation from 0 to 1
    else return <0,0,0>;    
    if (achromatic == 1)H = 0;
    else if( R == max )H = 0 + ( G - B ) / delta;    // between red & yellow
    else if( G == max )H = 2 + ( B - R ) / delta;    // between yellow & cyan
    else H = 4 + ( R - G ) / delta;    // between cyan & red
      if( H < 0 )H += 6;
     return <H/6,S,V>;
}

integer SET_VALUE=0x4ea1203b;
integer ASK_VALUE=0x4ea1203c;
integer TELL_VALUE=0x4ea1203d;
integer TELL_COLOR=0x4ea1203e;

float x;
integer isgoodnumber(string s)
{
    x=(float)s;
    if(x<0){x=0;return 1;}
    if(x>0)return 1;
    return ~llSubStringIndex(s,"0");
}

vector HSV;
vector RGB;

send()
{
    llRegionSayTo(rezzer,mychannel, (string)RGB);    
}

integer mychannel;

integer makechannel(key k){return (integer)("0x"+(string)k);}
key rezzer;
integer rezerchannel;
default
{    
    on_rez(integer x)
    {
        if(!x)return;
        llListen((mychannel=makechannel(llGetKey())),"","","");
        llSetTimerEvent(10);
    }
    listen(integer c, string n, key k, string m)
    {
        rezzer=k;   
        
        vector rgb=(vector)m;
        llSetColor(rgb,FACE);
        HSV=RGBtoHSV(rgb);
            llMessageLinked(4,SET_VALUE,(string)HSV.x,"");                    
            llMessageLinked(3,SET_VALUE,(string)HSV.y,"");                    
            llMessageLinked(2,SET_VALUE,(string)HSV.z,"");                    
        state working;
    }
    timer()
    {
        llOwnerSay("no init");
        llDie();    
    }

}

state working
{
    
    state_entry()
    {
        llSetTimerEvent(0);               
        llMessageLinked(LINK_THIS,DIEWHENREZZERDIES,"",rezzer);
        llListen(mychannel,"","","");
    }
    

    listen(integer total_number, string n, key k, string m)
    {
        if("die"==m)llDie();
        else if("livelonger"==m)llMessageLinked(LINK_THIS,888,"","");
        else
        {
            RGB=(vector)m;
            llSetColor(RGB,FACE);            
            HSV=RGBtoHSV(RGB);
            llMessageLinked(4,SET_VALUE,(string)HSV.x,"");                    
            llMessageLinked(3,SET_VALUE,(string)HSV.y,"");                    
            llMessageLinked(2,SET_VALUE,(string)HSV.z,"");                                        
        }
    }
/*        
        list L=llParseString2List(m,[" ","<",">",","],[]);
        if(llGetListLength(L)!=3)return;        
        if( isgoodnumber( llList2String(L,0) ) )
        {
            float nH=x;
            float max=x;
            if(isgoodnumber(llList2String(L,1)))
            {
                float nS=x;
                if(x>max)max=x;
                if(isgoodnumber(llList2String(L,2)))
                {
                    float nV=x;
                    if(x>max)max=x;
                    HSV=<nH,nS,nV>;
                    if(max>255)HSV/=max;
                    else if(max>1)HSV/=255;
                    llSetColor(HSVtoRGB(HSV),-1);
                    llMessageLinked(4,SET_VALUE,(string)nH,"");                    
                    llMessageLinked(3,SET_VALUE,(string)nS,"");                    
                    llMessageLinked(2,SET_VALUE,(string)nV,"");                    
                }
            }
        }
    }
*/    
    link_message(integer from, integer i, string s, key k)
    {
        if(i==TELL_VALUE)
        {
            if(4==from)HSV.x=(float)s;
            else if(3==from)HSV.y=(float)s;
            else if(2==from)HSV.z=(float)s;
            else return;
            llSetColor((RGB=HSVtoRGB(HSV)),-1);            
            send();
        }
        else if(i==TELL_COLOR)
        {
            RGB=(vector)s;
            llSetColor(RGB,FACE);            
            HSV=RGBtoHSV(RGB);
            llMessageLinked(4,SET_VALUE,(string)HSV.x,"");                    
            llMessageLinked(3,SET_VALUE,(string)HSV.y,"");                    
            llMessageLinked(2,SET_VALUE,(string)HSV.z,"");                    
            send();
        }
    }
}
