//Original script by Aaron Linden
//modified and commented by Ramon Kothari 





// Global variables change these to match your specifics

float range = 200.0; // search radius, in meters
float rate = 5.0; // time between searches, in seconds

// add your email adress inside the quotes
string email_address = "bir@westiemail.com";

//add the name of the location if you want (the email will have the sim name and cordinates of 
// the counter already in it) 
string location_name = "Avias SteamToys";



//dont change these 

list single_name_list;
list visitor_list;
//end no change





// Returns true if "name" is already on the visitor_list and doesnt add it the list again 
integer isNameOnList( string name )
{
list single_name_list;
single_name_list += name;

return (-1 != llListFindList( visitor_list, single_name_list ) );
}

// sends email to the address above ,if added 

sendEmail()
{
string csv = llList2CSV( visitor_list );
llEmail( email_address, "Visitor List: " + location_name, csv );
}

//self explanatory 

resetList()
{
single_name_list = llDeleteSubList(single_name_list, 0, llGetListLength(single_name_list));
llSay( 0, "Done resetting.");
}


// Help commands
sayHelp( integer is_owner )
{
if( is_owner )
{
llSay( 0, "This object records the names of everyone who" );
llSay( 0, "comes within "+ (string)((integer)range) + " meters." );
llSay( 0, "Commands the owner can say:" );
llSay( 0, "'/1help' - Shows these instructions." );
llSay( 0, "'/1say list' - Says the names of all visitors on the list.");
llSay( 0, "'/1reset list' - Removes all the names from the list." );
llSay( 0, "'/1email list' - Emails the names on the list." );
}
else
{
llSay( 0, "Sorry, only the owner can use this object." );
}
}

// state the script starts in 

default
{
state_entry()
{
llSay(0, "Visitor List Maker started...");
llSay(0, "The owner can say '/1help' for instructions.");
llSensorRepeat( "", "", AGENT, range, TWO_PI, rate );
llListen(1, "", llGetOwner(), "");

//change this to how often you want the script to email the visitor list to you (or comment it out if you dont want the email .... by default its set to email you every hr then reset itself
//llSetTimerEvent( 60 * 60 );
}


// Sends email and resets list as set in the settimerevent above
timer()
{
sendEmail();
resetList();


} 




//says help if owner clicks on it 

touch_start( integer num_detected )
{
integer i;
for( i = 0; i < num_detected; i++ )
{
sayHelp( llDetectedKey(i) == llGetOwner() );
}
}

//detects avatars and keeps time 

sensor( integer number_detected )
{
integer i;
for( i = 0; i < number_detected; i++ )
{
// Don't ever add the owner to the list.

if( llDetectedKey( i ) != llGetOwner() )
{
string detected_name = llDetectedName( i );
if( isNameOnList( detected_name ) == FALSE )
{
float seconds = llGetWallclock();
float minutes = seconds / 60.0;
float hours = minutes / 60.0;
integer hours_int = (integer) hours;
integer minutes_int = ((integer)minutes) % 60;
if( minutes_int < 10 )
{
visitor_list += (string) hours_int + ":0" + (string) minutes_int;
}
else
{
visitor_list += (string) hours_int + ":" + (string) minutes_int;
}

visitor_list += detected_name;
}
}
} 
}

//Listens for commands from the Owner

listen( integer channel, string name, key id, string message )
{
if( id != llGetOwner() )
{
return;
}

if( message == "help" )
{
sayHelp( TRUE );
}
else
if( message == "say list" )
{
llSay( 0, "Visitor List:" );
integer len = llGetListLength( visitor_list );
integer i;
for( i = 0; i < len; i++ )
{
llSay( 0, llList2String(visitor_list, i) );
}
llSay( 0, "Total = " + (string)len ); 
}



else
if( message == "reset list" )
{
visitor_list = llDeleteSubList(visitor_list, 0, llGetListLength(visitor_list));
llSay( 0, "Done resetting.");
}




} 
}