//                  PLEASE DO NOT REMOVE THIS HEADER                      \\
//========================================================================\\
//   ROOT SCRIPT FOR PARTICLE SCRIPT MAKER v.1 (updated on 22nd July 2016)    \\
//========================================================================\\
/*
LICENSE AGREEMENT: 
THIS WORK IS ONLY FOR EDUCATIONAL AND NON COMMERCIAL PURPOSE. 
YOU ARE FREE TO EXPERIMENT, STUDY, MODIFY, IMPROVE THE SCRIPTS
AND MATERIALS AND POST YOUR FEEDBACK OR WORK BACK HERE.
BUT UNDER NO CIRCUMSTANCES, YOU CAN SELL THE WHOLE OR ANY PART 
OF THE PARTICLE GENERATOR MACHINE OR USE FOR COMMERCIAL PURPOSE. 
ANY TYPE OF COMMERCIAL USAGE IS SIMPLY AND STRICTLY FORBIDDEN.
http://creativecommons.org/licenses/by-nc/4.0/
===============================================================================
    For Update, documentation, how-tos etc. Kindly  visit the following link:            
    http://forums.osgrid.org/viewtopic.php?f=5&t=5682
 ==============================================================================
*/

 string  texture = "43f3d656-eccc-44fe-94b2-088af2b6e048"; // Osgrid uuid

integer PRESET_CHANNEL;

slider2param(  integer slider, float  setting )
{
    if(slider == endglowslider)
    {
        endglow=0;
        if(setting) endglow=llPow( 2, ( setting-1 ) * 8  );
    }
    else if(slider == startglowslider)
    {
        startglow=0;
        if(setting) startglow=llPow( 2, ( setting-1 ) * 8  );
    }
    else if( slider == maxspeedslider)
    {
        maxspeed=0; 
        if(setting)maxspeed=llPow( 2, ( setting-0.5 )*12 );
    }
    else if( slider == lifeslider )
    {
        life= 0.9375 * llPow( 2, ( setting-0.5 )* 10 );
        fixburstrate();
    }
    else if( slider == PPBslider )
    {
         PPB= llRound(llPow( 2,  setting* 10 ) );
        fixburstrate();
    }
    else if( slider == ATPslider )
    {
        totalparticles=llPow( 2, setting * 16 - 3 );
        fixburstrate();
    }
    else if( slider == gravityslider ){
        gravity=0; 
        if(setting)gravity=llPow( 10, ( setting-0.5 )* 4 );
    }
}

integer ASKSETTING=0x81aa1110;
integer SENDSETTING=0x81aa1111;
integer USERCLICKED=12345001;

dolisten(list params, string n)
{
            life = llList2Float(params,0);
            send(lifeslider,(string)(llLog(  life / 0.9375 ) /log2 / 10 + 0.5) );
//            hovertext(lifeslider);
            
            burstradius = llList2Float(params,1); 
            send(burstradiusslider,(string)(0.5+(( llLog(burstradius)/log2 )/ 11.288 )));
//            hovertext(burstradiusslider);
            
            start_angle = llList2Float(params,2);  
            send( startangleslider, (string)( 1 - start_angle /  PI) );
//            hovertext( startangleslider);
            
            end_angle = llList2Float(params,3);  
            send( endangleslider, (string)(1 - end_angle /  PI) );
//            hovertext( endangleslider);
           
            flags = llList2Integer(params,4);              
            EMISSIVE = flags & PSYS_PART_EMISSIVE_MASK;
            SOURCE = flags &  PSYS_PART_FOLLOW_SRC_MASK;
            RIBBON = flags &  PSYS_PART_RIBBON_MASK;
            WIND = flags &  PSYS_PART_WIND_MASK;
            VELOCITY = flags &  PSYS_PART_FOLLOW_VELOCITY_MASK;

            TARGET_LINEAR = flags &  PSYS_PART_TARGET_LINEAR_MASK;
            
            key target = llList2Key(params,23);                                 
            if("***"==target)
            {
                targetforRC="***";
                targetkind=TARGETSELF;                
        // if TARGET_LINEAR is set, and target is self, we ignore TARGET_LINEAR completely;
        // if user wants particles to be linear and selt, DROP pattern should be used
                TARGET_LINEAR=0;                                
            }
            else if ( target )
            {
                targetforRC= target;
                targetkind=TARGETNONSELF;
            }
            else
            {               
                targetforRC= "";
                targetkind=TARGETNONE;
                TARGET_LINEAR=0;
            }                            
            BOUNCE = flags & PSYS_PART_BOUNCE_MASK;
                        
            send( emissive_flag_switch,(string)EMISSIVE);
            send(fsflag_switch,(string)SOURCE);
            send(ribbon_flag_switch, (string)RIBBON);
            send(wind_flag_switch,(string)WIND);
            send( velocity_flag_switch, (string)VELOCITY);
            send(target_linear_flag_switch,(string)TARGET_LINEAR);
            send( bounce_flag_switch,(string)BOUNCE);
            
            pattern = llList2Integer(params,5);
            send(pattern_selector_button, (string)pattern); 
            
            PPB = llList2Integer(params,6);
            float x =  llLog(PPB)/(10*log2) ;
            send( PPBslider, (string)x );
                      
            burstrate = llList2Float(params,7);
                       
            totalparticles=life/burstrate*PPB;
            
            send ( ATPslider,  (string)((llLog(totalparticles)/  log2 +3  ) / 16 ) );
           
            texture = (key)llList2String(params,8);  
            send(texturepicker_button, texture);
           
            maxspeed =  llList2Float(params,10); 
            float minspeed=  llList2Float(params,9); 
            
            if(minspeed>maxspeed){float f = minspeed; minspeed=maxspeed; maxspeed=f;}
                                    
            if(maxspeed == 0) speedfactor=1;
            else speedfactor=minspeed/maxspeed;
            
            send(maxspeedslider,(string)(((llLog(maxspeed)/log2)/12)+0.5));            
            send(minspeedslider,(string)speedfactor);
                       
            start_color = (vector) llList2String(params,11); 
            end_color = (vector) llList2String(params,12);
            
            llMessageLinked ( startend_colorpicker, SET_COLORS, llList2CSV (  [start_color, end_color]  ) , "");
                     
            start_alpha = llList2Float(params,13); 
            send(startalphaslider, (string)start_alpha);
            
            end_alpha =  llList2Float(params,14); 
            send(endalphaslider, (string)end_alpha);
    
            alphaislocked = llFabs (start_alpha-end_alpha) < 0.01 ;
            llMessageLinked(alpha_lock_switch,SETTO,(string)alphaislocked,""); 
                
            startglow =  llList2Float(params,15); 
            if( startglow ==0){send(startglowslider,(string)( 0 ));}
            else{send(startglowslider,(string)( ((llLog(startglow) /log2) /8) +1 ) );}
       
            endglow =  llList2Float(params,16); 
            if( endglow == 0){send(endglowslider,(string)( 0 ));}    
            else{send(endglowslider,(string)( ((llLog(endglow) / log2) /8) +1 ) );}
            glowislocked = llFabs (startglow -endglow)<0.01 ;
            llMessageLinked(glow_lock_switch,SETTO,(string)glowislocked,""); 
            
            start_scale = (vector) llList2String(params,17);
            if(start_scale == <0,0,0>) start_scale = <.01,.01,.01>;
            vector ss = <0.015,((llLog(start_scale.x)/log2)/8 )+0.75 ,((llLog(start_scale.y)/log2)/8 )+0.75>;
            end_scale = (vector)llList2String(params,18);
            if(end_scale == <0,0,0>) end_scale = <.01,.01,.01>; 
            vector ss1 = <0.015,((llLog(end_scale.x)/log2)/8 )+0.75 ,((llLog(end_scale.y)/log2)/8 )+0.75>;
                        
            vector acceleration = (vector)llList2String(params,19);  
            gravity=llVecMag(acceleration);
            gravitydir=llVecNorm(acceleration);
            sendvalue(gravityslider);         
            hovertext(gravityslider);            
            hovertext(gravity_direction_prim);
                                   
            omega = (vector) llList2String(params,20); 
            omega_strength = llVecMag(omega);
            omega_direction = llVecNorm(omega);
            sendvalue(omega_slider);         
            hovertext(omega_slider);            
            hovertext(omega_direction_prim);
                        
            blendsrc = llList2Integer(params,21); 
            send(src_blend_button,(string)blendsrc);
            blenddest = llList2Integer(params,22); 
            send(dest_blend_button,(string)blenddest);
             
            integer ssx=llList2Integer(params,24);                       
            integer ssy=llList2Integer(params,25);                         
            integer esx=llList2Integer(params,26);                         
            integer esy=llList2Integer(params,27);                         
            
            if(ssx==0) if(ssy==0) if (esx==0) if (esy==0) // this is only needed for obsolete presets
            {
                ssx=llRound(start_scale.x*32);
                ssx=llRound(start_scale.y*32);
                esx=llRound(end_scale.x*32);
                esy=llRound(end_scale.y*32);
            }
            
            start_scale=<ssx,ssy,0>/32;
            end_scale=<esx,esy,0>/32;

            sizeislocked = ssx==esx & ssy == esy ;
            llMessageLinked(sizelock,SETTO,(string)sizeislocked,"");        
            
            // find size-slider settings from asked values
            float max=maxof(start_scale);
            llMessageLinked(startsize_slider,SETTO,(string)(max/4.0),"");
            startbig=max;
            if(ssx==ssy)startskew=.5;
            else if(ssy>ssx)startskew=0.5+0.5*(start_scale.y-start_scale.x)/start_scale.y;
            else  startskew=0.5-0.5*(start_scale.x-start_scale.y)/start_scale.x; 
                                
            max=maxof(end_scale);
            llMessageLinked(endsize_slider,SETTO,(string)(max/4.0),"");
            endbig=max;
            
            if(esx==esy)endskew=.5;
            else if(esy>esx)endskew=0.5+0.5*(end_scale.y-end_scale.x)/end_scale.y;
            else  endskew=0.5-0.5*(end_scale.x-end_scale.y)/end_scale.x;

            send(startskew_slider,(string)startskew);
            send(endskew_slider,(string)endskew);
            send(startsize_slider,(string)(startbig/4));
            send(endsize_slider,(string)(endbig/4));
            
//            hovertext(endskew_slider);
//            hovertext(endsize_slider);
//            hovertext(startsize_slider);
//            hovertext(startskew_slider);
            
//            hovertext( PPBslider );
//            hovertext( maxspeedslider );
//            hovertext( minspeedslider );
//            hovertext(startglowslider);
//            hovertext(endglowslider);
//            hovertext(targetmenu_button);
//            hovertext(startalphaslider);
//            hovertext(endalphaslider);
//            hovertext(endangleslider);
//            hovertext(startangleslider);
                        
            particle();
}

sendvalue(integer prim)
{
    if(0);
    else if(prim == gravityslider )     
    {            
       // llSay(0, "accel is now "+(string)( gravity*gravitydir ));                        
        float g;
        if (gravity)g=llLog(gravity)/  log10 / 4 +.5 ;
        send(gravityslider,(string)g);                
    }
    else if( prim == omega_slider)
    {
      //  llSay(0, "omega is now "+(string)( omega_strength* omega_direction ));                        
        float g;
        if (omega_strength)g=llLog(omega_strength)/  log10 / 4 +.5 ;
        send(omega_slider,(string)g);   
    }
}

integer SHOW_HOVERTEXT = 0xC9901aF4;
integer USER_PRESSED_SWITCH = 0xC9901aF3;

integer alpha_lock_switch; integer alphaislocked ;
integer glow_lock_switch; integer glowislocked; 

integer gravity_direction_prim;
vector gravitydir=<0,0,-1>;
float gravity;

integer gravityslider;

integer omega_slider;
float omega_strength;
vector omega_direction;
integer omega_direction_prim;

integer square;

integer startsize_slider; integer startskew_slider;
integer endsize_slider;integer endskew_slider;
integer sizelock=1;

float startskew=.5; float endskew=.5;
float startbig=1; float endbig=1;
integer sizeislocked=1;

vector start_scale=<1,1,0>; 
vector end_scale=<1,1,0>;

integer TARGETNONE=0;
integer TARGETSELF=1;
integer TARGETNONSELF=2;
integer targetkind;//=TARGETNONE; 

integer ASK_FOR_COLORS=0x1002a001;
integer SET_COLORS=0x1002a003;
integer SEND_COLORS=0x1002a002;
integer USER_WANTS_COLORS=0x1002a004;

integer CHANGE_REPORTED=0x4432123;
integer ACTIVATE=0x4432124;
integer SETTO = 0x4432125;

key targetforRC;

string particle_code;

float totalparticles = 5;
float life = 5;           
float burstrate = 1;      
integer PPB = 1;
float burstradius = 0;      
float maxspeed = 0.5;       
float startglow = 0;        
float endglow = 0.1;   

float start_angle; float end_angle; 
float start_alpha=1; float end_alpha=1;
vector start_color = <1,1,1>; vector end_color = <1,1,1>;

vector omega; 

float speedfactor=1; 
integer pattern = PSYS_SRC_PATTERN_ANGLE;

integer blendsrc = PSYS_PART_BF_SOURCE_ALPHA; 
integer blenddest = PSYS_PART_BF_ONE_MINUS_SOURCE_ALPHA; 

integer flags;
integer BOUNCE;
integer EMISSIVE = PSYS_PART_EMISSIVE_MASK;
integer SOURCE;
integer RIBBON;
integer WIND;
integer VELOCITY ;
integer TARGET_LINEAR; 

// child prim numbers

integer startend_colorpicker;

integer make_preset_button;

integer src_blend_button; integer dest_blend_button; integer reset_blend_switch;

integer startangleslider; integer endangleslider;

integer lifeslider;       
integer burstrateslider;   
integer PPBslider;
integer burstradiusslider; 
integer minspeedslider;    
integer maxspeedslider;    
integer startglowslider;    
integer endglowslider;     
integer startalphaslider;  
integer endalphaslider;     

integer ATPslider;

integer pattern_selector_button;
integer texturepicker_button;

integer bounce_flag_switch; 
integer emissive_flag_switch;
integer fsflag_switch;
integer wind_flag_switch;
integer ribbon_flag_switch;
integer velocity_flag_switch; 

integer target_linear_flag_switch;

integer code_generation_button;
integer targetmenu_button;

ppf( integer k, list all){llSetLinkPrimitiveParamsFast( k, all);}
say( string m){llSay(0,m);}
send( integer kid, string message){llMessageLinked ( kid , SETTO, message, "");}
settext(integer kid, string t){ ppf(kid,[PRIM_TEXT,t,<1,1,1>, 1 ]);} // set alpha to 0 to disable text

string h (float f)
{
    integer i = llRound(100*f);    
    if(i%100<10)return (string)(i/100)+".0"+(string)(i%100);
    return (string)(i/100)+"."+(string)(i%100);
}

string percent (float f)
{
    integer i = llRound(100*f);    
    return (string)i+" %";
}

integer a;integer b;integer c; integer d;

integer interpscaleneeded()
{
    a=(integer)llRound(start_scale.x*32);
    b=(integer)llRound(start_scale.y*32);
    c= (integer)llRound(end_scale.x*32);
    d=(integer)llRound(end_scale.y*32);
    if(a==c)if(b==d)return 0;
    return 1;    
}

particle()
{
    integer FLAGS= EMISSIVE|BOUNCE|SOURCE|RIBBON|WIND|VELOCITY;    
    if( targetkind==TARGETNONSELF) 
    {
        if(TARGET_LINEAR) FLAGS= FLAGS | PSYS_PART_TARGET_LINEAR_MASK ;
        else FLAGS=FLAGS|PSYS_PART_TARGET_POS_MASK ;
    }
    else if( targetkind==TARGETSELF) 
    {
        FLAGS=FLAGS|PSYS_PART_TARGET_POS_MASK ; ;         
    } 
    if( interpscaleneeded() ) FLAGS=FLAGS|PSYS_PART_INTERP_SCALE_MASK;
    if( interpcolorneeded() )FLAGS=FLAGS|PSYS_PART_INTERP_COLOR_MASK;
    particle_code = llDumpList2String ( [ 
            life,     burstradius,                start_angle,        end_angle,      FLAGS,
            pattern,    PPB,        burstrate,        texture,              maxspeed*speedfactor,
            maxspeed,    start_color,         end_color,   start_alpha,           end_alpha,
            startglow,      endglow,      "" ,        "",       gravity*gravitydir,
            omega_strength* omega_direction,
           
                       blendsrc,           blenddest,            targetforRC, a,
            b,  c,   d
        ],",");         
    
    integer RC_channel =  0xdecafbad ^ makechannel ( llGetOwner() ) ; 
    llShout(RC_channel,particle_code);  
}

integer interpcolorneeded(){
    if(llFabs(start_alpha-end_alpha)>0.01)return 1;
    if(llVecDist(start_color,end_color)>0.01) return 1;
    return 0;    
}

makecode()            
{
    string allflags=", 
    PSYS_PART_FLAGS, \n";       
    if( EMISSIVE ) allflags+="\t\t\tPSYS_PART_EMISSIVE_MASK |\n "; 
    if(BOUNCE)  allflags+= "\t \t \t PSYS_PART_BOUNCE_MASK |\n "; 
    if(SOURCE) allflags+= "\t \t \t  PSYS_PART_FOLLOW_SRC_MASK |\n ";
    if(RIBBON) allflags+= "\t \t \t PSYS_PART_RIBBON_MASK |\n ";
    if( WIND) allflags+= "\t \t \t PSYS_PART_WIND_MASK |\n ";
    if(VELOCITY) allflags+= "\t \t \t PSYS_PART_FOLLOW_VELOCITY_MASK |\n ";                
    if(interpcolorneeded()) allflags+= "\t \t \t PSYS_PART_INTERP_COLOR_MASK|\n "; 
    if(interpscaleneeded())allflags+= "\t \t \t PSYS_PART_INTERP_SCALE_MASK|\n "; 
    string targetline;
    if(targetkind == TARGETSELF )
    {
        targetline=(" PSYS_SRC_TARGET_KEY,llGetKey(),");
        allflags+= "\t \t \t PSYS_PART_TARGET_POS_MASK |\n " ; 
        // if TARGET_LINEAR is set, and target is self, we ignore TARGET_LINEAR completely;
        // if user wants particles to be linear and self, meaning nonmoving, DROP pattern should be used
    }
    else if(targetkind == TARGETNONSELF )
    {
        targetline=("PSYS_SRC_TARGET_KEY,(key)\"" + (string)targetforRC + "\" ,");                    
        if(TARGET_LINEAR) allflags+= "\t \t \t PSYS_PART_TARGET_LINEAR_MASK |\n ";
        else allflags+= "\t \t \t PSYS_PART_TARGET_POS_MASK |\n " ;
    }
    string pat="\n\t\t\t\tPSYS_SRC_PATTERN,";
    if( 4 == pattern)pat += "PSYS_SRC_PATTERN_ANGLE";
    else if (8 == pattern) pat += "PSYS_SRC_PATTERN_ANGLE_CONE";
    else if( 1 == pattern) pat += "PSYS_SRC_PATTERN_DROP";
    else /* if( 2 == pattern) */ pat += " PSYS_SRC_PATTERN_EXPLODE"; 
    say("/me \n
default
{ 
\tstate_entry()  
\t{ 
\t\tllLinkParticleSystem(LINK_THIS,[
\t\t\t\t"+targetline+pat+",
\t\t\t\tPSYS_SRC_BURST_RADIUS,"+ firstfive(burstradius)+",
\t\t\t\tPSYS_SRC_ANGLE_BEGIN,"+firstfive(start_angle) +", 
\t\t\t\tPSYS_SRC_ANGLE_END,"+ firstfive(end_angle)  +",  
\t\t\t\tPSYS_PART_START_COLOR,"+ (string)start_color+",
\t\t\t\tPSYS_PART_END_COLOR,"+(string)end_color+",
\t\t\t\tPSYS_PART_START_ALPHA,"+(string)start_alpha +",
\t\t\t\tPSYS_PART_END_ALPHA,"+(string)end_alpha+", 
\t\t\t\tPSYS_PART_START_GLOW,"+(string)startglow +",
\t\t\t\tPSYS_PART_END_GLOW,"+(string)endglow +", 
\t\t\t\tPSYS_PART_BLEND_FUNC_SOURCE,"+(string)blendsrc+",
\t\t\t\tPSYS_PART_BLEND_FUNC_DEST,"+(string) blenddest+",\n/*");                
                say("\n*/ 
\t\t\t\tPSYS_PART_START_SCALE,"+ (string) start_scale+",
\t\t\t\tPSYS_PART_END_SCALE,"+(string)end_scale+",
\t\t\t\tPSYS_SRC_TEXTURE,\""+ texture +"\",\n
\t\t\t\tPSYS_SRC_MAX_AGE,0,
\t\t\t\tPSYS_PART_MAX_AGE,"+ firstfive(life)+",
\t\t\t\tPSYS_SRC_BURST_RATE,"+ (string)burstrate+", 
\t\t\t\tPSYS_SRC_BURST_PART_COUNT,"+(string)PPB+",
\t\t\t\tPSYS_SRC_ACCEL,"+(string)(gravity*gravitydir)+",
\t\t\t\tPSYS_SRC_OMEGA,"+(string)(omega_direction * omega_strength)+",  
\t\t\t\tPSYS_SRC_BURST_SPEED_MIN,"+ firstfive(maxspeed*speedfactor)+", 
\t\t\t\tPSYS_SRC_BURST_SPEED_MAX,"+firstfive( maxspeed)
+ allflags+"\t\t\t\t0\n\t\t]);\n\t}\n}\n"
);
}

fixburstrate()                
{
    burstrate=life*PPB/totalparticles; 
    /*           
    if(burstrate>1)settext(burstrateslider, h(burstrate)+" sec\n between\n bursts");
    else settext(burstrateslider, h(1/burstrate) +" bursts\nper second "); 
    */
    if(burstrate>1)ppf(burstrateslider,[PRIM_TEXT, h(burstrate)+" sec\n between\n bursts", <1,1,1>,1]);
    else ppf(burstrateslider,[PRIM_TEXT, h(1/burstrate) +" bursts\nper second ",<1,1,0>,1]);    
}

string firstfive(float f){return llGetSubString((string)f,0,4);}

hovertext(integer from)
{
    if(from==startangleslider)   settext( from ,"Start\n Angle\n"+ (string) llRound(start_angle*RAD_TO_DEG)+"\n Deg");
    else if (from==endangleslider) settext( from ,"End\n Angle\n"+ (string) llRound(end_angle*RAD_TO_DEG)+"\n Deg"+"\n \n \n \n \n"); 
    else if(from == lifeslider)   settext(lifeslider,"Life\n"+ h(life)+" sec");
    else if(from == PPBslider) 
    {
        string ps; if( PPB-1)ps = "Particles"; else ps = "Particle";                
        settext(PPBslider,(string)(PPB)+"\n"+ps+"\nPer\nBurst" );
    }
    else if(from == burstradiusslider)                settext(burstradiusslider,"Burst\n Radius\n"+ h(burstradius)+" m");
    else if(from == maxspeedslider)                settext(maxspeedslider,"Max\n Speed\n"+h(maxspeed)+" m/s" +"\n \n \n \n \n \n ");
    else if(from == minspeedslider)                settext(minspeedslider,"Min\n Speed\n"+percent( speedfactor )+ "\nof\n Max Speed" );
    else if(from == ATPslider)
    {
                     if(totalparticles<5.5)
        settext(ATPslider,"AVERAGE \nTOTAL\nPARTICLES\n"+h(totalparticles));
        else settext(ATPslider,"AVERAGE \nTOTAL\nPARTICLES\n"+(string)llRound(totalparticles));

    } 
    else if(from == startglowslider) settext(startglowslider,"Start\n Glow\n"+h(startglow));
    else if(from == endglowslider)   settext(endglowslider,"End\n Glow\n"+h(endglow));

    else if(from == startalphaslider)settext(startalphaslider,"Start\n Alpha\n"+h(start_alpha)+"\n \n \n");
    else if(from == endalphaslider) settext(endalphaslider,"End\n Alpha\n"+h(end_alpha)+"\n \n \n");
    else if( from == targetmenu_button )
    {
        if(targetkind==TARGETSELF)    settext (from, "*target self*");
        else if(targetkind==TARGETNONSELF)    settext (from, "*target key*");
        else settext (from, "*target none*");                         
    }
    else if (from == startsize_slider)
    {
        settext(from,"startsize\n"+h(startbig)+"\n \n \n");
    }
    else if (from == endsize_slider)
    {
        settext(from,"endsize\n"+h(endbig)+"\n \n \n"); 
    }
    else if (from == startskew_slider)
    {
        settext(from,"start skew\n"+percent(startskew)+"\n \n \n");
    }    
    else if (from == endskew_slider)
    {
        settext(from,"end skew\n"+percent(endskew)+"\n \n \n"); 
    }           
    else if( from == startangleslider)
    {
       settext(from,"Start angle\n"+(string)start_angle); 
    }
    else if( from == endangleslider)  settext(from,"End angle\n"+(string)end_angle); 
    else if( from == gravityslider)  settext(from,"Gravity\n"+h(gravity)); 
    else if( from == gravity_direction_prim)
    {
        if(gravitydir)
        {
            if(gravitydir.z>0.7)settext(from,"Gravity UP"); 
            else if(gravitydir.z<-0.7)settext(from,"Gravity DOWN"); 
            else if(llFabs(gravitydir.x)>llFabs(gravitydir.y))
            {
                if(gravitydir.x>0) settext(from,"Gravity east"); 
                else  settext(from,"Gravity west"); 
            }
            else 
            {
                if(gravitydir.y>0) settext(from,"Gravity  north"); 
                else  settext(from,"Gravity south"); 
            }
        }
        else  settext(from,"Gravity OFF"); 
    }
    
    else if( from == omega_slider)  settext(from,"Omega\n"+h(omega_strength)); 
    else if( from == omega_direction_prim)
    {
        if(omega_direction)
        {
            if(omega_direction.z>0.7)settext(from,"OMEGA UP"); 
            else if(omega_direction.z<-0.7)settext(from,"OMEGA DOWN"); 
            else if(llFabs(omega_direction.x)>llFabs(omega_direction.y))
            {
                if(omega_direction.x>0) settext(from,"OMEGA east"); 
                else  settext(from,"OMEGA west"); 
            }
            else 
            {
                if(omega_direction.y>0) settext(from,"OMEGA  north"); 
                else  settext(from,"OMEGA south"); 
            }
        }
        else  settext(from,"OMEGA OFF"); 
    }
       
    else
    {
        llOwnerSay("mhovertext() got bad prim number "+(string)from);    
    }   
}

float maxof(vector size)
{            
    float max=size.x; 
    if(max<size.y)return size.y;
    return size.x;
}

saypreset()
{                                                
    say("\n \n
default
{
    touch_start(integer t)
    {
         string m = \""+particle_code+"\" ;
         llSay(0xDEADBEEF ^ (integer)(\"0x\"+(string)llGetOwner()),m);
         llSetText(llGetObjectName(),<1,1,1>,1);
    }
}\n"); 
}

float log2 = 0.6931472;
float log10=2.3025851;

integer makechannel(key k){return (integer)("0x"+(string)k);}

integer ASK_STATE = 0xC9901aF5;
integer SEND_STATE = 0xC9901aF6;

default
{
    state_entry()
    {
        ppf( -1, [PRIM_TEXT,"",<1,1,1>,1]);
        
        targetkind=TARGETNONE; 
        settext(LINK_SET,"");
        PRESET_CHANNEL =  0xdeadbeef ^  makechannel ( llGetOwner() ) ;
        llListen(PRESET_CHANNEL,"","","");
       
        say(" Total Free memory is "+(string)llGetFreeMemory()+ " bytes");    
          
        integer i = llGetObjectPrimCount( llGetKey() );
        for(;i>1;--i)
        {
            list L=llParseString2List(llGetLinkName(i),[" "],[]);
            string name=llList2String(L,0);
 
            if("make_preset" == name) { make_preset_button = i;}
            else if("startangle" == name){ startangleslider = i;}
            else if("endangle" == name){ endangleslider = i;}
            else if("maxage" == name){ lifeslider = i; }
            else if("burstrate" == name){ burstrateslider = i;}
            else if("particlecount" == name){ PPBslider = i;} // particles per burst
            else if("burstradius" == name){ burstradiusslider = i;}
            else if("minspeed" == name){ minspeedslider = i;}
            else if("maxspeed" == name){ maxspeedslider = i;}
            else if( "startglow" == name) { startglowslider = i; }
            else if( "endglow" == name){ endglowslider = i; }
            else if( "startalpha" == name) { startalphaslider = i;}
            else if( "endalpha" == name) { endalphaslider = i; }                      
            else if( "texturepicker" == name) {texturepicker_button = i;}
            else if( "pattern_selector" == name) {pattern_selector_button = i;}
            else if( "wind" == name) {wind_flag_switch = i;}
            else if( "followsource" == name) {fsflag_switch = i;}
            else if( "bounce" == name) { bounce_flag_switch = i;}
            else if( "emissive_flag" == name) { emissive_flag_switch = i;}
            else if( "ribbon_flag" == name) {ribbon_flag_switch = i;}
            else if( "followvel" == name) {velocity_flag_switch = i;}
            else if( "target_linear_flag" == name) {target_linear_flag_switch = i;}
            else if( "code_generation" == name) {code_generation_button = i;}
            else if( "key_set" == name) {targetmenu_button = i;}
            else if( "totalparticles" == name) { ATPslider = i;}
            else if("src_blend" == name) { src_blend_button = i;}
            else if("dest_blend" == name) { dest_blend_button = i;}
            else if("reset_blend" == name) {reset_blend_switch = i;}
         
            else if( "glow_lock" == name) {glow_lock_switch = i;}
            else if("startend_colorpicker" == name){startend_colorpicker = i;} 
            
           else if( "startsize" == name) {startsize_slider = i;}
           else if( "startskew" == name) {startskew_slider = i;}
           else if( "endsize" == name) {endsize_slider = i;}
           else if( "endskew" == name) {endskew_slider = i;}
           else if( "size-lock" == name) {sizelock = i;}   
           
           else if( "omega_slider" == name) { omega_slider = i;}
           else if("omega_direction" == name){ omega_direction_prim = i;}
           
           else if( "gravity_slider" == name) { gravityslider = i;} 
           else if( "gravity_direction" == name) { gravity_direction_prim = i;} 
           else if( "square" == name) { square = i;}  
           else if( "alpha_lock" == name) {alpha_lock_switch = i;}      
        }   
        
        alphaislocked = llFabs (start_alpha-end_alpha)<0.01 ;
        llMessageLinked(alpha_lock_switch,SETTO,(string)alphaislocked,""); 
        llMessageLinked(glow_lock_switch,SETTO,(string)glowislocked,"");                          
        sizeislocked = (startbig == endbig ) ; 
        llMessageLinked(sizelock,SETTO,(string)sizeislocked,"");        
        llMessageLinked(emissive_flag_switch,SHOW_HOVERTEXT,"","");        
        llMessageLinked( sizelock ,SHOW_HOVERTEXT,"","");  
        llMessageLinked( alpha_lock_switch ,SHOW_HOVERTEXT,"",""); 
        llMessageLinked( glow_lock_switch  ,SHOW_HOVERTEXT,"","");        

//        settext(square, "square\nparticles");
//        settext( code_generation_button , "make\nscript");
//        settext(make_preset_button , "make\npreset\nscript");

//        hovertext(endsize_slider);
//        hovertext(startsize_slider);
//        hovertext(startskew_slider);
//        hovertext(endskew_slider);

        llMessageLinked(maxspeedslider,ASKSETTING,"",""); 
        llMessageLinked(lifeslider,ASKSETTING,"",""); 
        llMessageLinked(PPBslider,ASKSETTING,"",""); 
        
        llMessageLinked(minspeedslider,ASKSETTING,"",""); 
//        hovertext(targetmenu_button);
        
        llMessageLinked(gravityslider,ASKSETTING,"",""); 
//        hovertext(gravity_direction_prim);  
        
//        hovertext(omega_direction_prim); /// added 
//        hovertext(omega_slider);           
//        hovertext(burstradiusslider);   
        
        llMessageLinked(ATPslider,ASKSETTING,"",""); 
        
        llMessageLinked(startalphaslider,ASKSETTING,"",""); 
        llMessageLinked(endalphaslider,ASKSETTING,"","");
        
        llMessageLinked(startglowslider,ASKSETTING,"",""); // working here
        llMessageLinked(endglowslider,ASKSETTING,"",""); // working here
        
        llMessageLinked( endangleslider,ASKSETTING,"",""); 
        llMessageLinked( startangleslider,ASKSETTING,"","");
        
        llMessageLinked(glow_lock_switch,ASK_STATE,"","");
                
        llSetTimerEvent(5);    
    }
    
    timer()
    {
        llSetTimerEvent(0);    
        say("now fixing the burst rate");
        fixburstrate();                
    }
 
    listen( integer c, string n, key k, string m) // listen event starts here
    {
        list params = llCSV2List(m);
        dolisten(params, n);
    }

    link_message(integer from, integer i, string s, key k) //link_message  event starts here
    { 
        if( i==  USER_WANTS_COLORS)
        {
            if(from==startend_colorpicker)
            {
                list L=llCSV2List(s);
                start_color = (vector) llList2String(L,0); 
                end_color = (vector) llList2String(L,1); 
                particle();
            }                
        }
        else if(i==SEND_STATE)
        {
            if(from==glow_lock_switch) glowislocked=(integer)s;
        }
        else if(i==USER_PRESSED_SWITCH)
        {
            integer sw=(integer)s;
            if( from == emissive_flag_switch) EMISSIVE = PSYS_PART_EMISSIVE_MASK*sw;
            else if( from == bounce_flag_switch)  BOUNCE = PSYS_PART_BOUNCE_MASK*sw;
            else if( from == fsflag_switch)
            {
                SOURCE = PSYS_PART_FOLLOW_SRC_MASK*sw;
                llMessageLinked(burstradiusslider,ACTIVATE,(string)(!sw),"");
            }
            else if( from == ribbon_flag_switch )RIBBON = PSYS_PART_RIBBON_MASK*sw;
            else if( from == wind_flag_switch )WIND = PSYS_PART_WIND_MASK*sw;
            else if( from == velocity_flag_switch )VELOCITY = PSYS_PART_FOLLOW_VELOCITY_MASK*sw;
            else if( from == sizelock )sizeislocked=sw;            
            else if( from == glow_lock_switch) glowislocked = sw;
            else if( from == alpha_lock_switch)alphaislocked = sw;             
            else if( from == target_linear_flag_switch) TARGET_LINEAR = PSYS_PART_TARGET_LINEAR_MASK*sw;
            particle();            
        }        
        else if(i==CHANGE_REPORTED)
        {
            float setting = (float)s;
            if( from == make_preset_button)
            {
                 saypreset();
            }            
            else if(from == startangleslider)
            {
                start_angle= PI * (1-setting);
//                hovertext(from);
            }
            else if(from == endangleslider)
            {
                end_angle  =  PI * (1-setting);
//                hovertext(from);
            }            
            else if(from == lifeslider)
            {
                slider2param(from,setting);       
                fixburstrate();
//                hovertext(from);
            }                
            else if(from == PPBslider) 
            {
                slider2param(from,setting);       
                fixburstrate();
//                hovertext(from);
            }            
            else if(from == burstradiusslider)
            {
                burstradius=0; 
                if( setting ) burstradius=llPow( 2, ( setting-0.5 )* 11.288 );
//                hovertext(from);
            }   

            else if( from == omega_slider)
            {
               omega_strength = 0;
               if(setting)omega_strength=llPow( 10, ( setting-0.5 )* 4 );
//               hovertext(from);      
                   
            } 
            else if( from == omega_direction_prim)
            {
                vector v= (vector)s;
                if(v)
                {
                    omega_direction = v;
                }
                else
                {
                    omega_strength = 0;
//                    hovertext( omega_slider );
                    sendvalue( omega_slider );         
                }
//                hovertext(from);  
            }
                       
            else if( from == gravityslider)
            {
                slider2param(from,setting);
//                hovertext(from);                
            }            
            else if( from == gravity_direction_prim)
            {
                vector v= (vector)s;
                if(v)
                {
                    gravitydir = v;
                }
                else // the gravitydirvector is NOT changed when user clicks "no gravity";
                    // instead, the slider is set to zero
                    // so, gravitydir vector has always length 1
                {
                    gravity = 0;
//                    hovertext( gravityslider );
                    sendvalue( gravityslider );         
                }
//                hovertext(from);
            }

            else if(from == maxspeedslider)
            {
                slider2param(from,setting);
//                hovertext(from);
            }
            else if(from == minspeedslider)
            {
                speedfactor=setting;
//                hovertext(from);
            }            
            else if(from == ATPslider)
            {
                slider2param(from, setting);
                fixburstrate();
//                hovertext(from);
            }            
            else if(from == startalphaslider)
            {
                start_alpha = setting;
//                hovertext(from);
                if(alphaislocked)
                {
                    end_alpha = start_alpha ;
                    send( endalphaslider, s);
//                    hovertext(endalphaslider);
                }
            }
            else if(from == endalphaslider)
            {
                end_alpha = setting;
//                hovertext(from);                
                if(alphaislocked)
                {
                    start_alpha = end_alpha ;
                    send( startalphaslider, s);
//                    hovertext(startalphaslider);
                }
            }            
            else if(from == startglowslider)
            {
                slider2param( from , setting );                
//                hovertext(from);                
                if(glowislocked)
                {
                    endglow = startglow;
                    send( endglowslider, s); 
//                    hovertext(endglowslider);
                }
            }
            else if(from == endglowslider)
            {
                slider2param( from , setting );      
//                hovertext(from);
                if(glowislocked)
                {
                    startglow = endglow ;
                    send( startglowslider, s);
//                    hovertext(startglowslider);
                }
            }         
            else if(from == startsize_slider)
            {
                startbig=4*setting;
                if(startskew>.5)start_scale = startbig*<2-startskew*2,1,0>;
                else start_scale = startbig*<1,startskew*2,0>;
//                hovertext(from);
                if(sizeislocked)
                {
                    end_scale=start_scale;
                    send(endsize_slider,s);    
                    endbig=startbig;
//                    hovertext(endsize_slider);
                }
            }
            else if(from == endsize_slider)
            {
                endbig=4*setting;                
                if(endskew>.5)end_scale = endbig*<2-endskew*2,1,0>;
                else end_scale = endbig*<1,endskew*2,0>;
//                hovertext(from);
                if(sizeislocked)
                {
                    start_scale=end_scale;
                    send(startsize_slider,s);   
                    startbig=endbig; 
//                    hovertext(startsize_slider);
                }
            }
            else if(from == startskew_slider)
            {
                startskew=setting;
                if(startskew>0.5)start_scale = startbig*<2-startskew*2,1,0>;
                else start_scale = startbig*<1,startskew*2,0>;
//                hovertext(from);
            }
            else if(from == endskew_slider)
            {
                endskew =setting;
                if(endskew>0.5)end_scale = endbig*<2-endskew*2,1,0>;
                else end_scale = endbig*<1,endskew*2,0>;
//                hovertext(from);
            }
            else if(from == square)
            {
                endskew=startskew=0.5;
                send(startskew_slider,".5");
                send(endskew_slider,".5");
                start_scale=<startbig,startbig,0>;
                end_scale=<endbig,endbig,0>;
//                hovertext(startskew_slider);
//                hovertext(endskew_slider);
            }           
            else if( from == src_blend_button){ blendsrc = (integer)s; }
            else if( from == dest_blend_button){blenddest = (integer)s;}
            else if( from == reset_blend_switch)
            {
                blendsrc = PSYS_PART_BF_SOURCE_ALPHA;
                blenddest =  PSYS_PART_BF_ONE_MINUS_SOURCE_ALPHA;
                send( src_blend_button, (string)blendsrc );
                send( dest_blend_button, (string)blenddest );
            }           
            else if( from == pattern_selector_button )  
            { 
                pattern = (integer)s;
            }
            else if( from == texturepicker_button ) 
            {
                texture = s; 
            }
            else if( from == targetmenu_button )
            { 
                key target = s;   
                targetforRC = target;
                if( target )targetkind=TARGETNONSELF;
                else if( "***" == s )targetkind=TARGETSELF;
                else targetkind=TARGETNONE; 
                hovertext(from);                
            }            
            else if ( from == code_generation_button)   makecode(); 
            
            particle();
        }        
        else if( i == SENDSETTING)
        {
            float setting=(float)s;
            if( from == startglowslider){ slider2param( from , setting ); }
            else if( from == endglowslider) { slider2param( from , setting ); }            
            else if( from == startalphaslider){ start_alpha = setting;}
            else if( from == endalphaslider){ end_alpha = setting;}           
            else if( from == startangleslider){ start_angle = PI * (1-setting); }
            else if ( from == endangleslider){end_angle =( PI * (1-setting)) ; }            
            else if( from == maxspeedslider){slider2param( from , setting ); }
            else if( from == PPBslider){  slider2param( from , setting ); }
            else if( from == ATPslider) {slider2param( from , setting ); }
            else if( from == lifeslider){slider2param( from , setting );}
            else if( from == gravityslider){ slider2param( from , setting );}
            else return;
//            hovertext( from ); 
        }   
    }
}

state screwup
{
    state_entry()
    {
        settext(LINK_THIS,"SCREWUP");    
    }    
}